# RiskAssessment Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RiskAssessment Transforms: R4 → SGHI R5**

## StructureMap: RiskAssessment Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/RiskAssessmentR4toSGHIR5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:RiskAssessmentR4toSGHIR5 |

 
RiskAssessmentTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "RiskAssessmentR4toSGHIR5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/RiskAssessmentR4toSGHIR5",
  "version" : "0.1.0",
  "name" : "RiskAssessmentR4toSGHIR5",
  "title" : "RiskAssessment Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "RiskAssessmentTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/RiskAssessment",
      "mode" : "source",
      "alias" : "RiskAssessmentR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/riskassessment",
      "mode" : "target",
      "alias" : "RiskAssessmentR5"
    }
  ],
  "group" : [
    {
      "name" : "RiskAssessment",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "RiskAssessmentR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "RiskAssessmentR5",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "v"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "v"
                }
              ]
            }
          ]
        },
        {
          "name" : "meta",
          "source" : [
            {
              "context" : "src",
              "element" : "meta",
              "variable" : "m"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "m"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "l"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "transform" : "evaluate",
              "parameter" : [
                {
                  "valueString" : "l.lower()"
                }
              ]
            }
          ]
        },
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "n"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "n"
                }
              ]
            }
          ]
        },
        {
          "name" : "status",
          "source" : [
            {
              "context" : "src",
              "element" : "status",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "s"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "c"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "c"
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "sbj"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "subject",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sbj"
                }
              ]
            }
          ]
        },
        {
          "name" : "encounter",
          "source" : [
            {
              "context" : "src",
              "element" : "encounter",
              "variable" : "enc"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "encounter",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "enc"
                }
              ]
            }
          ]
        },
        {
          "name" : "occurrence",
          "source" : [
            {
              "context" : "src",
              "element" : "occurrence",
              "variable" : "occ"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "occurrence",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "occ"
                }
              ]
            }
          ]
        },
        {
          "name" : "condition",
          "source" : [
            {
              "context" : "src",
              "element" : "condition",
              "variable" : "cond"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "condition",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "cond"
                }
              ]
            }
          ]
        },
        {
          "name" : "performer",
          "source" : [
            {
              "context" : "src",
              "element" : "performer",
              "variable" : "perf"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "performer",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "perf"
                }
              ]
            }
          ]
        },
        {
          "name" : "reasonCodeToReason",
          "source" : [
            {
              "context" : "src",
              "element" : "reasonCode",
              "variable" : "rc"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reason",
              "variable" : "r"
            },
            {
              "context" : "r",
              "element" : "concept",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "rc"
                }
              ]
            }
          ],
          "documentation" : "R4 reasonCode + reasonReference → R5 reason (CodeableReference)"
        },
        {
          "name" : "reasonRefToReason",
          "source" : [
            {
              "context" : "src",
              "element" : "reasonReference",
              "variable" : "rr"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reason",
              "variable" : "r2"
            },
            {
              "context" : "r2",
              "element" : "reference",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "rr"
                }
              ]
            }
          ]
        },
        {
          "name" : "basis",
          "source" : [
            {
              "context" : "src",
              "element" : "basis",
              "variable" : "b"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "basis",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "b"
                }
              ]
            }
          ]
        },
        {
          "name" : "prediction",
          "source" : [
            {
              "context" : "src",
              "element" : "prediction",
              "variable" : "p"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "prediction",
              "variable" : "tp"
            }
          ],
          "rule" : [
            {
              "name" : "outcome",
              "source" : [
                {
                  "context" : "p",
                  "element" : "outcome",
                  "variable" : "o"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "outcome",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "o"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "probabilityDecimal",
              "source" : [
                {
                  "context" : "p",
                  "element" : "probabilityDecimal",
                  "variable" : "d"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "probability",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "probabilityRange",
              "source" : [
                {
                  "context" : "p",
                  "element" : "probabilityRange",
                  "variable" : "pr"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "probability",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "pr"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "qualitativeRisk",
              "source" : [
                {
                  "context" : "p",
                  "element" : "qualitativeRisk",
                  "variable" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "qualitativeRisk",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "qr"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "relativeRisk",
              "source" : [
                {
                  "context" : "p",
                  "element" : "relativeRisk",
                  "variable" : "rr"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "relativeRisk",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "rr"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "whenPeriod",
              "source" : [
                {
                  "context" : "p",
                  "element" : "whenPeriod",
                  "variable" : "wp"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "when",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "wp"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "whenRange",
              "source" : [
                {
                  "context" : "p",
                  "element" : "whenRange",
                  "variable" : "wr"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "when",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "wr"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "rationale",
              "source" : [
                {
                  "context" : "p",
                  "element" : "rationale",
                  "variable" : "ra"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "rationale",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "ra"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "mitigation",
          "source" : [
            {
              "context" : "src",
              "element" : "mitigation",
              "variable" : "mit"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "mitigation",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "mit"
                }
              ]
            }
          ]
        },
        {
          "name" : "note",
          "source" : [
            {
              "context" : "src",
              "element" : "note",
              "variable" : "notes"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "note",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "notes"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
