# Patient Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Transforms: R4 → SGHI R5**

## StructureMap: Patient Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/Patient4toSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:Patient4toSGHI5 |

 
PatientTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "Patient4toSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/Patient4toSGHI5",
  "version" : "0.1.0",
  "name" : "Patient4toSGHI5",
  "title" : "Patient Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "PatientTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/Patient",
      "mode" : "source",
      "alias" : "PatientR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient",
      "mode" : "target",
      "alias" : "SGHIPatient"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/human-name",
      "mode" : "produced",
      "alias" : "SGHIHumanName"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/contact-point",
      "mode" : "produced",
      "alias" : "SGHIContactPoint"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept",
      "mode" : "produced",
      "alias" : "SGHICodeableConcept"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference",
      "mode" : "produced",
      "alias" : "SGHIReference"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIPatient",
      "extends" : "DomainResource",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "PatientR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIPatient",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "processoneidentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "identifier",
              "variable" : "s",
              "condition" : "(s.system != 'healthcloud.msisdn') and s.value.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t"
            }
          ],
          "rule" : [
            {
              "name" : "copyuse",
              "source" : [
                {
                  "context" : "s",
                  "element" : "use",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "use",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "copyvalue",
              "source" : [
                {
                  "context" : "s",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "copyperiod",
              "source" : [
                {
                  "context" : "s",
                  "element" : "period",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "period",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "mapidentifiertype",
              "source" : [
                {
                  "context" : "s",
                  "element" : "type",
                  "variable" : "ty"
                }
              ],
              "rule" : [
                {
                  "name" : "whensourcehascoding",
                  "source" : [
                    {
                      "context" : "ty",
                      "element" : "coding",
                      "listMode" : "first",
                      "variable" : "cf"
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "calltranslator",
                      "source" : [
                        {
                          "context" : "cf",
                          "element" : "system",
                          "variable" : "legacy"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t",
                          "element" : "type",
                          "variable" : "result"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "TranslateLegacyIdentifier",
                          "parameter" : [
                            {
                              "valueId" : "legacy"
                            },
                            {
                              "valueId" : "result"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "SetFixedIdentifierSystem",
              "source" : [
                {
                  "context" : "s"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "createandpopulateassigner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "managingOrganization",
                  "variable" : "mo"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "assigner",
                  "variable" : "t_assigner",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "setassignerreffrommo",
                  "source" : [
                    {
                      "context" : "mo",
                      "element" : "reference",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_assigner",
                      "element" : "reference",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "setassignerdisplayfrommo",
                  "source" : [
                    {
                      "context" : "mo",
                      "element" : "display",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_assigner",
                      "element" : "display",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "create the default FHIR ID identifier type",
          "source" : [
            {
              "context" : "src",
              "element" : "identifier",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_id"
            }
          ],
          "rule" : [
            {
              "name" : "copyuse",
              "source" : [
                {
                  "context" : "s_id",
                  "element" : "use",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "use",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "id",
              "source" : [
                {
                  "context" : "src",
                  "element" : "id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "period",
              "source" : [
                {
                  "context" : "s_id",
                  "element" : "period",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "period",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "type",
              "source" : [
                {
                  "context" : "s_id",
                  "element" : "type",
                  "variable" : "st"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "type",
                  "variable" : "tt"
                }
              ],
              "rule" : [
                {
                  "name" : "coding",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "coding"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt",
                      "element" : "coding",
                      "variable" : "tt",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "CodeableConcept"
                        }
                      ]
                    },
                    {
                      "context" : "tt",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    },
                    {
                      "context" : "tt",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "fhir-id"
                        }
                      ]
                    },
                    {
                      "context" : "tt",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "FHIR Id"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "SetFixedIdentifierSystem",
              "source" : [
                {
                  "context" : "s_id"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "name",
          "source" : [
            {
              "context" : "src",
              "element" : "name",
              "listMode" : "first",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "name",
              "variable" : "t"
            }
          ],
          "dependent" : [
            {
              "name" : "SGHIHumanNameMap",
              "parameter" : [
                {
                  "valueId" : "s"
                },
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "telecom",
          "source" : [
            {
              "context" : "src",
              "element" : "telecom",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "telecom",
              "variable" : "t"
            }
          ],
          "dependent" : [
            {
              "name" : "SGHIContactPointMap",
              "parameter" : [
                {
                  "valueId" : "s"
                },
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "mapgender",
          "source" : [
            {
              "context" : "src",
              "element" : "gender",
              "variable" : "v"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "gender",
              "transform" : "translate",
              "parameter" : [
                {
                  "valueId" : "v"
                },
                {
                  "valueString" : "http://hl7.org/fhir/uv/xver/ConceptMap/pat.gender-4to5"
                },
                {
                  "valueString" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "birthDate",
          "source" : [
            {
              "context" : "src",
              "element" : "birthDate",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "birthDate",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "deceasedBoolean",
          "source" : [
            {
              "context" : "src",
              "type" : "boolean",
              "element" : "deceased",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "deceased",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "deceasedDateTime",
          "source" : [
            {
              "context" : "src",
              "type" : "dateTime",
              "element" : "deceased",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "deceased",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "multipleBirthBoolean",
          "source" : [
            {
              "context" : "src",
              "type" : "boolean",
              "element" : "multipleBirth",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "multipleBirth",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "multipleBirthInteger",
          "source" : [
            {
              "context" : "src",
              "type" : "integer",
              "element" : "multipleBirth",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "multipleBirth",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "address",
          "source" : [
            {
              "context" : "src",
              "element" : "address",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "address",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "photo",
          "source" : [
            {
              "context" : "src",
              "element" : "photo",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "photo",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "contact",
          "source" : [
            {
              "context" : "src",
              "element" : "contact",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "contact",
              "variable" : "t"
            }
          ],
          "dependent" : [
            {
              "name" : "SGHIPatientContact",
              "parameter" : [
                {
                  "valueId" : "s"
                },
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "communication",
          "source" : [
            {
              "context" : "src",
              "element" : "communication",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "communication",
              "variable" : "t"
            }
          ],
          "dependent" : [
            {
              "name" : "PatientCommunication",
              "parameter" : [
                {
                  "valueId" : "s"
                },
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "managingOrganization",
          "source" : [
            {
              "context" : "src",
              "element" : "managingOrganization",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "managingOrganization",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "generalPractitioner",
          "source" : [
            {
              "context" : "src",
              "element" : "generalPractitioner",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "generalPractitioner",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "link",
          "source" : [
            {
              "context" : "src",
              "element" : "link",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "link",
              "variable" : "t"
            }
          ],
          "dependent" : [
            {
              "name" : "SGHIPatientLink",
              "parameter" : [
                {
                  "valueId" : "s"
                },
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "t_text",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "addprofiletometa",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "addprofile",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TranslateLegacyIdentifier",
      "input" : [
        {
          "name" : "legacy_code",
          "type" : "string",
          "mode" : "source"
        },
        {
          "name" : "result",
          "type" : "CodeableConcept",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "translatetocoding",
          "source" : [
            {
              "context" : "legacy_code"
            }
          ],
          "target" : [
            {
              "context" : "result",
              "element" : "coding",
              "transform" : "translate",
              "parameter" : [
                {
                  "valueId" : "legacy_code"
                },
                {
                  "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/LegacyIdentifierToSGHI"
                },
                {
                  "valueString" : "Coding"
                }
              ]
            }
          ]
        },
        {
          "name" : "settext",
          "source" : [
            {
              "context" : "legacy_code"
            }
          ],
          "target" : [
            {
              "context" : "result",
              "element" : "text"
            }
          ]
        }
      ]
    },
    {
      "name" : "SGHIHumanNameMap",
      "extends" : "HumanName",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "use",
          "source" : [
            {
              "context" : "src",
              "element" : "use",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "use",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "family",
          "source" : [
            {
              "context" : "src",
              "element" : "family",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "family",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "given",
          "source" : [
            {
              "context" : "src",
              "element" : "given",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "given",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "prefix",
          "source" : [
            {
              "context" : "src",
              "element" : "prefix",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "prefix",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "suffix",
          "source" : [
            {
              "context" : "src",
              "element" : "suffix",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "suffix",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "period",
          "source" : [
            {
              "context" : "src",
              "element" : "period",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "period",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SGHIContactPointMap",
      "extends" : "ContactPoint",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "value",
          "source" : [
            {
              "context" : "src",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "use",
          "source" : [
            {
              "context" : "src",
              "element" : "use",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "use",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "rank",
          "source" : [
            {
              "context" : "src",
              "element" : "rank",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "rank",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "period",
          "source" : [
            {
              "context" : "src",
              "element" : "period",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "period",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SGHICodeableConceptCopy",
      "extends" : "CodeableConcept",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "src",
              "element" : "coding",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "coding",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SGHIPatientContact",
      "extends" : "BackboneElement",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "relationship",
          "source" : [
            {
              "context" : "src",
              "element" : "relationship",
              "variable" : "r"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "relationship",
              "variable" : "t"
            }
          ],
          "dependent" : [
            {
              "name" : "SGHICodeableConceptCopy",
              "parameter" : [
                {
                  "valueId" : "r"
                },
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "name",
          "source" : [
            {
              "context" : "src",
              "element" : "name",
              "variable" : "n"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "name",
              "variable" : "tn"
            }
          ],
          "dependent" : [
            {
              "name" : "SGHIHumanNameMap",
              "parameter" : [
                {
                  "valueId" : "n"
                },
                {
                  "valueId" : "tn"
                }
              ]
            }
          ]
        },
        {
          "name" : "telecom",
          "source" : [
            {
              "context" : "src",
              "element" : "telecom",
              "listMode" : "first",
              "variable" : "c"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "telecom",
              "variable" : "tc"
            }
          ],
          "dependent" : [
            {
              "name" : "SGHIContactPointMap",
              "parameter" : [
                {
                  "valueId" : "c"
                },
                {
                  "valueId" : "tc"
                }
              ]
            }
          ]
        },
        {
          "name" : "address",
          "source" : [
            {
              "context" : "src",
              "element" : "address",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "address",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "mapcontactgender",
          "source" : [
            {
              "context" : "src",
              "element" : "gender",
              "variable" : "v"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "gender",
              "transform" : "translate",
              "parameter" : [
                {
                  "valueId" : "v"
                },
                {
                  "valueString" : "http://hl7.org/fhir/uv/xver/ConceptMap/pat.co.gender-4to5"
                },
                {
                  "valueString" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "organization",
          "source" : [
            {
              "context" : "src",
              "element" : "organization",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "organization",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "period",
          "source" : [
            {
              "context" : "src",
              "element" : "period",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "period",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "PatientCommunication",
      "extends" : "BackboneElement",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "preferred",
          "source" : [
            {
              "context" : "src",
              "element" : "preferred",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "preferred",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SGHIPatientLink",
      "extends" : "BackboneElement",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "other",
          "source" : [
            {
              "context" : "src",
              "element" : "other",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "other",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "maplinktype",
          "source" : [
            {
              "context" : "src",
              "element" : "type",
              "variable" : "v"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "type",
              "transform" : "translate",
              "parameter" : [
                {
                  "valueId" : "v"
                },
                {
                  "valueString" : "http://hl7.org/fhir/uv/xver/ConceptMap/pat.li.type-4to5"
                },
                {
                  "valueString" : "code"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
