# EpisodeOfCare Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EpisodeOfCare Transforms: R4 → SGHI R5**

## StructureMap: EpisodeOfCare Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/EpisodeOfCare4toSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:EpisodeOfCare4toSGHI5 |

 
EpisodeOfCareTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "EpisodeOfCare4toSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/EpisodeOfCare4toSGHI5",
  "version" : "0.1.0",
  "name" : "EpisodeOfCare4toSGHI5",
  "title" : "EpisodeOfCare Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "EpisodeOfCareTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/EpisodeOfCare",
      "mode" : "source",
      "alias" : "EpisodeOfCareR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/episodeofcare",
      "mode" : "target",
      "alias" : "SGHIEpisodeOfCare"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIEpisodeOfCare",
      "extends" : "DomainResource",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "EpisodeOfCareR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIEpisodeOfCare",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "true"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "tgt_n",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "creating identifier",
          "source" : [
            {
              "context" : "src",
              "variable" : "sc",
              "condition" : "identifier.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "tt_id",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "creating id",
              "source" : [
                {
                  "context" : "src",
                  "element" : "id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "creating use",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "creating identifier type",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "type",
                  "variable" : "ty"
                }
              ],
              "rule" : [
                {
                  "name" : "creating identifier type",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ty",
                      "element" : "coding",
                      "variable" : "ty_c",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "CodeableConcept"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "creating coding",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "creating code",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "creating display",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "creating system",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt_id",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "managingOrganization",
                  "source" : [
                    {
                      "context" : "src",
                      "element" : "managingOrganization",
                      "variable" : "sp"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt_id",
                      "element" : "assigner",
                      "variable" : "t_assigner",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "reference",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "reference",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_assigner",
                          "element" : "reference",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "display",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "display",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_assigner",
                          "element" : "display",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Create identifier"
        },
        {
          "name" : "managingOrganization",
          "source" : [
            {
              "context" : "src",
              "element" : "managingOrganization",
              "variable" : "smo"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "managingOrganization",
              "variable" : "tmo",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "reference",
              "source" : [
                {
                  "context" : "smo",
                  "element" : "reference",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tmo",
                  "element" : "reference",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "smo",
                  "element" : "display",
                  "variable" : "vvv",
                  "condition" : "display.exists()"
                }
              ],
              "target" : [
                {
                  "context" : "tmo",
                  "element" : "display",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "managingOrganization",
              "source" : [
                {
                  "context" : "src",
                  "element" : "managingOrganization",
                  "condition" : "display.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "tmo",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Organization"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "smo",
                  "element" : "display",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tmo",
                  "element" : "display",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "status",
          "source" : [
            {
              "context" : "src",
              "element" : "status",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "set profile in meta",
          "source" : [
            {
              "context" : "src",
              "element" : "meta",
              "variable" : "s_meta"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "lastUpdated",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "lastUpdated",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "lastUpdated",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "language",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "language",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "language",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "tags",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "tags",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "tags",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setprofileinmeta",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "condition" : "profile.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/episodeofcare"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "period",
          "source" : [
            {
              "context" : "src",
              "element" : "period",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "period",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "patient",
          "source" : [
            {
              "context" : "src",
              "element" : "patient",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "patient",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "creating status history",
          "source" : [
            {
              "context" : "src",
              "condition" : "statusHistory.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "statusHistory",
              "variable" : "th",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "BackboneElement"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "set default status",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "th",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "planned"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "copying status history period",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "th",
                  "element" : "period",
                  "variable" : "tp",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Period"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "period",
                  "source" : [
                    {
                      "context" : "src",
                      "element" : "period",
                      "variable" : "sp"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "th",
                      "element" : "period",
                      "variable" : "tp"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformPeriod",
                      "parameter" : [
                        {
                          "valueId" : "sp"
                        },
                        {
                          "valueId" : "tp"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformPeriod",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "start",
          "source" : [
            {
              "context" : "src",
              "element" : "start",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "start",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "end",
          "source" : [
            {
              "context" : "src",
              "element" : "end",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "end",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
