# Encounter Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter Transforms: R4 → SGHI R5**

## StructureMap: Encounter Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/Encounter4toSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:Encounter4toSGHI5 |

 
EncounterTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "Encounter4toSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/Encounter4toSGHI5",
  "version" : "0.1.0",
  "name" : "Encounter4toSGHI5",
  "title" : "Encounter Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "EncounterTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/Encounter",
      "mode" : "source",
      "alias" : "EncounterR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/encounter",
      "mode" : "target",
      "alias" : "SGHIEncounter"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIEncounter",
      "extends" : "DomainResource",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "EncounterR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIEncounter",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "true"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "tgt_n",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "creating identifier",
          "source" : [
            {
              "context" : "src",
              "variable" : "sc",
              "condition" : "identifier.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "tt_id",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "creating id",
              "source" : [
                {
                  "context" : "src",
                  "element" : "id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "creating use",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "creating identifier type",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "type",
                  "variable" : "ty"
                }
              ],
              "rule" : [
                {
                  "name" : "creating identifier type",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ty",
                      "element" : "coding",
                      "variable" : "ty_c",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "CodeableConcept"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "creating coding",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "creating code",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "creating display",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "creating system",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt_id",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "serviceProvider",
                  "source" : [
                    {
                      "context" : "src",
                      "element" : "serviceProvider",
                      "variable" : "sp"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt_id",
                      "element" : "assigner",
                      "variable" : "t_assigner",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "reference",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "reference",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_assigner",
                          "element" : "reference",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "display",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "display",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_assigner",
                          "element" : "display",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Create identifier"
        },
        {
          "name" : "episodeOfCare",
          "source" : [
            {
              "context" : "src",
              "element" : "episodeOfCare",
              "variable" : "se"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "episodeOfCare",
              "variable" : "te",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "reference",
              "source" : [
                {
                  "context" : "se",
                  "element" : "reference",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "reference",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "id",
              "source" : [
                {
                  "context" : "se",
                  "element" : "id",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "id",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "se",
                  "element" : "display",
                  "variable" : "vvv",
                  "condition" : "display.exists()"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "display",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "episodeOfCare",
              "source" : [
                {
                  "context" : "src",
                  "element" : "episodeOfCare",
                  "condition" : "display.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Encounter"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "se",
                  "element" : "display",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "display",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "status",
          "source" : [
            {
              "context" : "src",
              "element" : "status",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting R5 status in target",
          "source" : [
            {
              "context" : "src",
              "condition" : "status = 'finished'"
            }
          ],
          "rule" : [
            {
              "name" : "setting R5 status",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "completed"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "translate coding to codeableconcept",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "class",
              "variable" : "t_c"
            }
          ],
          "rule" : [
            {
              "name" : "class",
              "source" : [
                {
                  "context" : "src",
                  "element" : "class",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "t_c",
                  "element" : "coding",
                  "variable" : "tt",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformEncounterClass",
                  "parameter" : [
                    {
                      "valueId" : "sc"
                    },
                    {
                      "valueId" : "tt"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "serviceProvider",
          "source" : [
            {
              "context" : "src",
              "element" : "serviceProvider",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "serviceProvider",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "set profile in meta",
          "source" : [
            {
              "context" : "src",
              "element" : "meta",
              "variable" : "s_meta"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "lastUpdated",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "lastUpdated",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "lastUpdated",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "language",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "language",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "language",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "tags",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "tags",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "tags",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setprofileinmeta",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "condition" : "profile.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/encounter"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "period",
          "source" : [
            {
              "context" : "src",
              "element" : "period",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "actualPeriod",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "subject",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "episodeOfcare",
          "source" : [
            {
              "context" : "src",
              "element" : "episodeOfcare",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "episodeOfcare",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "sb"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "participant",
              "variable" : "tb"
            }
          ],
          "rule" : [
            {
              "name" : "set actor from subject",
              "source" : [
                {
                  "context" : "sb"
                }
              ],
              "target" : [
                {
                  "context" : "tb",
                  "element" : "actor",
                  "variable" : "ar",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "reference",
                  "source" : [
                    {
                      "context" : "sb",
                      "element" : "reference",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ar",
                      "element" : "reference",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "display",
                  "source" : [
                    {
                      "context" : "sb",
                      "element" : "display",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ar",
                      "element" : "display",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformEncounterClass",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "userSelected",
          "source" : [
            {
              "context" : "src",
              "element" : "userSelected",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "userSelected",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "version",
          "source" : [
            {
              "context" : "src",
              "element" : "version",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "version",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
