# DocumentReference Transforms: R4 to SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DocumentReference Transforms: R4 to SGHI R5**

## StructureMap: DocumentReference Transforms: R4 to SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/DocumentReferenceSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:DocumentReferenceSGHI5 |

 
DocumentReferenceTransformsR4toSGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "DocumentReferenceSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/DocumentReferenceSGHI5",
  "version" : "0.1.0",
  "name" : "DocumentReferenceSGHI5",
  "title" : "DocumentReference Transforms: R4 to SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "DocumentReferenceTransformsR4toSGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/DocumentReference",
      "mode" : "source",
      "alias" : "DocumentReferenceR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/documentreference",
      "mode" : "target",
      "alias" : "SGHIDocumentReference"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIDocumentReference",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "DocumentReferenceR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIDocumentReference",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "uuid"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "uuid"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "addtometa",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "addprofile",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/documentreference"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src",
              "condition" : "text.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "t_text",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting text",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "ttt",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "src",
                  "element" : "text",
                  "variable" : "st"
                }
              ],
              "rule" : [
                {
                  "name" : "status",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "status",
                      "variable" : "s"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "status",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueId" : "s"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "wraptextinhtml",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "div",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "div",
                      "transform" : "evaluate",
                      "parameter" : [
                        {
                          "valueString" : "'<div xmlns=\\\"http://www.w3.org/1999/xhtml\\\"><p>' + d + '</p></div>'"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "addfhirididentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_ident",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "copyid",
              "source" : [
                {
                  "context" : "s_id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setuse",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setsystem",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "inittype",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "type",
                  "variable" : "t_type",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "initcoding",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_type",
                      "element" : "coding",
                      "variable" : "t_code",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "typesystem",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typecode",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typedisplay",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting owner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_ident",
                      "element" : "assigner",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "context",
          "source" : [
            {
              "context" : "src",
              "element" : "context",
              "variable" : "sctx"
            }
          ],
          "rule" : [
            {
              "name" : "related",
              "source" : [
                {
                  "context" : "sctx",
                  "element" : "related",
                  "variable" : "sr"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "basedOn",
                  "variable" : "tr",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sr"
                    },
                    {
                      "valueId" : "tr"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "encounter",
              "source" : [
                {
                  "context" : "sctx",
                  "element" : "encounter",
                  "variable" : "se"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "context",
                  "variable" : "te",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "se"
                    },
                    {
                      "valueId" : "te"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "status",
          "source" : [
            {
              "context" : "src",
              "element" : "status",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "docStatus",
          "source" : [
            {
              "context" : "src",
              "element" : "docStatus",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "docStatus",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "category",
          "source" : [
            {
              "context" : "src",
              "element" : "category",
              "variable" : "sg"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "category",
              "variable" : "tg"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "sc"
                    },
                    {
                      "valueId" : "tc"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "type",
          "source" : [
            {
              "context" : "src",
              "element" : "type",
              "variable" : "stype"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "type",
              "variable" : "ttype"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "stype",
                  "element" : "coding",
                  "variable" : "scoding"
                }
              ],
              "target" : [
                {
                  "context" : "ttype",
                  "element" : "coding",
                  "variable" : "tcoding",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "scoding",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "code",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        },
                        {
                          "valueString" : "code"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "scoding",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "system",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        },
                        {
                          "valueString" : "system"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "scoding",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "display",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "scoding",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttype",
                      "element" : "text",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default type",
          "source" : [
            {
              "context" : "src",
              "condition" : "type.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "type",
              "variable" : "tconcept",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableConcept"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "setting coding",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tconcept",
                  "element" : "coding",
                  "variable" : "tcoding",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "setting system",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "setting code",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "referral"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "setting display",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "Referral"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "sb"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "subject",
              "variable" : "tb"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sb"
                },
                {
                  "valueId" : "tb"
                }
              ]
            }
          ]
        },
        {
          "name" : "date",
          "source" : [
            {
              "context" : "src",
              "element" : "date",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "date",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "author",
          "source" : [
            {
              "context" : "src",
              "element" : "author",
              "variable" : "sa"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "author",
              "variable" : "ta"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sa"
                },
                {
                  "valueId" : "ta"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting author",
          "source" : [
            {
              "context" : "src",
              "condition" : "author.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "setting author",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tgt",
                      "element" : "author",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "custodian",
          "source" : [
            {
              "context" : "src",
              "element" : "custodian",
              "variable" : "scd"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "custodian",
              "variable" : "tcd"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "scd"
                },
                {
                  "valueId" : "tcd"
                }
              ]
            }
          ]
        },
        {
          "name" : "set custodian",
          "source" : [
            {
              "context" : "src",
              "condition" : "custodian.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "setting custodian",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tgt",
                      "element" : "custodian",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "content",
          "source" : [
            {
              "context" : "src",
              "element" : "content",
              "variable" : "sct"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "content",
              "variable" : "tct",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "BackboneElement"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "attachment",
              "source" : [
                {
                  "context" : "sct",
                  "element" : "attachment",
                  "variable" : "sa"
                }
              ],
              "target" : [
                {
                  "context" : "tct",
                  "element" : "attachment",
                  "variable" : "ta"
                }
              ],
              "rule" : [
                {
                  "name" : "contentType",
                  "source" : [
                    {
                      "context" : "sa",
                      "element" : "contentType",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ta",
                      "element" : "contentType",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "title",
                  "source" : [
                    {
                      "context" : "sa",
                      "element" : "title",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ta",
                      "element" : "title",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "url",
                  "source" : [
                    {
                      "context" : "sa",
                      "element" : "url",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ta",
                      "element" : "url",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "Organization/"
                },
                {
                  "valueId" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformCoding",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "settingdefaultdisplay",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
