# Consent Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent Transforms: R4 → SGHI R5**

## StructureMap: Consent Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/ConsenttoSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:ConsenttoSGHI5 |

 
ConsentTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "ConsenttoSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/ConsenttoSGHI5",
  "version" : "0.1.0",
  "name" : "ConsenttoSGHI5",
  "title" : "Consent Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "ConsentTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/Consent",
      "mode" : "source",
      "alias" : "ConsentR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/consent",
      "mode" : "target",
      "alias" : "SGHIConsent"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIConsent",
      "extends" : "DomainResource",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "ConsentR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIConsent",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "true"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src",
              "condition" : "text.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "tgt_n",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "st"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "tt"
            }
          ],
          "rule" : [
            {
              "name" : "status",
              "source" : [
                {
                  "context" : "st",
                  "element" : "status",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tt",
                  "element" : "status",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "div",
              "source" : [
                {
                  "context" : "st",
                  "element" : "div",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tt",
                  "element" : "div",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting identifier",
          "source" : [
            {
              "context" : "src",
              "variable" : "sc",
              "condition" : "identifier.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "tt_id",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "creating id",
              "source" : [
                {
                  "context" : "src",
                  "element" : "id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "creating use",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting identifier type",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "type",
                  "variable" : "ty"
                }
              ],
              "rule" : [
                {
                  "name" : "creating identifier type",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ty",
                      "element" : "coding",
                      "variable" : "ty_c",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "CodeableConcept"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "creating coding",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "creating code",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "creating display",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "creating system",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt_id",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "setting owner",
                  "source" : [
                    {
                      "context" : "src",
                      "element" : "meta",
                      "variable" : "sm"
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "tag",
                      "source" : [
                        {
                          "context" : "sm",
                          "element" : "tag",
                          "listMode" : "first",
                          "variable" : "sm"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tt_id",
                          "element" : "assigner",
                          "variable" : "t_assigner",
                          "transform" : "create",
                          "parameter" : [
                            {
                              "valueString" : "Reference"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "TransformAssigner",
                          "parameter" : [
                            {
                              "valueId" : "sm"
                            },
                            {
                              "valueId" : "t_assigner"
                            }
                          ]
                        }
                      ]
                    }
                  ],
                  "documentation" : "creating identifier assigner"
                }
              ]
            }
          ],
          "documentation" : "Create identifier"
        },
        {
          "name" : "set profile in meta",
          "source" : [
            {
              "context" : "src",
              "element" : "meta",
              "variable" : "s_meta"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "lastUpdated",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "lastUpdated",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "lastUpdated",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "language",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "language",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "language",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "tags",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "tags",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "tags",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setprofileinmeta",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "condition" : "profile.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/consent"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "status",
          "source" : [
            {
              "context" : "src",
              "element" : "status",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "category",
          "source" : [
            {
              "context" : "src",
              "element" : "category",
              "variable" : "sc"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "category",
              "variable" : "tc"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformCoding",
              "parameter" : [
                {
                  "valueId" : "sc"
                },
                {
                  "valueId" : "tc"
                }
              ]
            }
          ]
        },
        {
          "name" : "patient",
          "source" : [
            {
              "context" : "src",
              "element" : "patient",
              "variable" : "sp"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "subject",
              "variable" : "tp"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sp"
                },
                {
                  "valueId" : "tp"
                }
              ]
            }
          ],
          "documentation" : "Patient has been translated to subject in R5"
        },
        {
          "name" : "dateTime",
          "source" : [
            {
              "context" : "src",
              "element" : "dateTime",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "date",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "provision",
          "source" : [
            {
              "context" : "src",
              "element" : "provision",
              "variable" : "spr"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "provision",
              "variable" : "tpr"
            }
          ],
          "rule" : [
            {
              "name" : "data",
              "source" : [
                {
                  "context" : "spr",
                  "element" : "data",
                  "variable" : "sd"
                }
              ],
              "target" : [
                {
                  "context" : "tpr",
                  "element" : "data",
                  "variable" : "td"
                }
              ],
              "rule" : [
                {
                  "name" : "meaning",
                  "source" : [
                    {
                      "context" : "sd",
                      "element" : "meaning",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "td",
                      "element" : "meaning",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "reference",
                  "source" : [
                    {
                      "context" : "sd",
                      "element" : "reference",
                      "variable" : "sf"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "td",
                      "element" : "reference",
                      "variable" : "tf"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformReference",
                      "parameter" : [
                        {
                          "valueId" : "sf"
                        },
                        {
                          "valueId" : "tf"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "performer",
          "source" : [
            {
              "context" : "src",
              "element" : "performer",
              "variable" : "sp",
              "condition" : "performer.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "grantee",
              "variable" : "tp"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sp"
                },
                {
                  "valueId" : "tp"
                }
              ]
            }
          ],
          "documentation" : "Performer has been translated to grantee in R5"
        },
        {
          "name" : "populating grantee with patient details",
          "source" : [
            {
              "context" : "src",
              "condition" : "performer.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "patient",
              "source" : [
                {
                  "context" : "src",
                  "element" : "patient",
                  "variable" : "sp"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "grantee",
                  "variable" : "tp"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sp"
                    },
                    {
                      "valueId" : "tp"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "patient",
              "source" : [
                {
                  "context" : "src",
                  "element" : "patient",
                  "variable" : "sp"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "grantor",
                  "variable" : "tp"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sp"
                    },
                    {
                      "valueId" : "tp"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Handles cases where performer does not exists in legacy R4 data"
        },
        {
          "name" : "organization",
          "source" : [
            {
              "context" : "src",
              "element" : "organization",
              "variable" : "so",
              "condition" : "organization.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "manager",
              "variable" : "tm"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "so"
                },
                {
                  "valueId" : "tm"
                }
              ]
            }
          ],
          "documentation" : "handles cases where organization exists in legacy R4 data"
        },
        {
          "name" : "organization",
          "source" : [
            {
              "context" : "src",
              "element" : "organization",
              "variable" : "so",
              "condition" : "organization.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "controller",
              "variable" : "tm"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "so"
                },
                {
                  "valueId" : "tm"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting manager and controller",
          "source" : [
            {
              "context" : "src",
              "condition" : "organization.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "meta",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "first",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tgt",
                      "element" : "manager",
                      "variable" : "tp"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "tp"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "first",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tgt",
                      "element" : "controller",
                      "variable" : "tp"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "tp"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "handles cases where organization does not exists in legacy R4 data"
        },
        {
          "name" : "setting rule policy",
          "source" : [
            {
              "context" : "src",
              "element" : "policyRule",
              "variable" : "sr",
              "condition" : "text.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "regulatoryBasis",
              "variable" : "tr",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableConcept"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sr",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tr",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting coding",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tr",
                  "element" : "coding",
                  "variable" : "tcc",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                },
                {
                  "context" : "tcc",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://hl7.org/fhir/R4/codesystem-consent-policy.html"
                    }
                  ]
                },
                {
                  "context" : "tcc",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "cric"
                    }
                  ]
                },
                {
                  "context" : "tcc",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Common Rule Informed Consent"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Policyrule has been translated to regulatoryBasis in R4"
        },
        {
          "name" : "setting verification",
          "source" : [
            {
              "context" : "src",
              "condition" : "verification.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "verification",
              "variable" : "tb",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "BackboneElement"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "setting verified status",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tb",
                  "element" : "verified",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "true"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting verification date",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tb",
                  "element" : "verificationDate",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "2025-06-16"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting verify by",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "setting verified by",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tb",
                      "element" : "verifiedBy",
                      "variable" : "tf",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "code",
                      "source" : [
                        {
                          "context" : "st",
                          "element" : "code",
                          "variable" : "org"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tf",
                          "element" : "reference",
                          "transform" : "append",
                          "parameter" : [
                            {
                              "valueString" : "Organization/"
                            },
                            {
                              "valueId" : "org"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "display",
                      "source" : [
                        {
                          "context" : "st",
                          "element" : "display",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tf",
                          "element" : "display",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "display",
                      "source" : [
                        {
                          "context" : "st",
                          "element" : "display",
                          "condition" : "display.exists().not()"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tf",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "Unknown display"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "code",
                      "source" : [
                        {
                          "context" : "st",
                          "element" : "code",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tf",
                          "element" : "id",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting reference",
              "source" : [
                {
                  "context" : "src",
                  "element" : "patient",
                  "variable" : "sp"
                }
              ],
              "target" : [
                {
                  "context" : "tb",
                  "element" : "verifiedWith",
                  "variable" : "trf",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sp"
                    },
                    {
                      "valueId" : "trf"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "category",
          "source" : [
            {
              "context" : "src",
              "element" : "category",
              "variable" : "sc"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "category",
              "variable" : "tc"
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sc",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tc",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sc",
                  "element" : "coding",
                  "variable" : "scc"
                }
              ],
              "target" : [
                {
                  "context" : "tc",
                  "element" : "coding",
                  "variable" : "tcc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "scc"
                    },
                    {
                      "valueId" : "tcc"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "provision",
          "source" : [
            {
              "context" : "src",
              "element" : "provision",
              "variable" : "sp"
            }
          ],
          "rule" : [
            {
              "name" : "type",
              "source" : [
                {
                  "context" : "sp",
                  "element" : "type",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "decision",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "dateTime",
          "source" : [
            {
              "context" : "src",
              "element" : "dateTime",
              "variable" : "sdt",
              "condition" : "dateTime.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "date",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sdt"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting consent date",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "date",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "2025-06-16"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "Organization/"
                },
                {
                  "valueId" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformCoding",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
