# SGHI Substance - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Substance**

## Resource Profile: SGHI Substance 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/substance | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHISubstance |

 
Profile for representing substances in the SGHI context 

**Usages:**

* Refer to this Profile: [SGHI Medication](StructureDefinition-medication.md)
* Examples for this Profile: [Substance/ExampleSGHISubstance](Substance-ExampleSGHISubstance.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/substance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-substance.csv), [Excel](StructureDefinition-substance.xlsx), [Schematron](StructureDefinition-substance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "substance",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/substance",
  "version" : "0.1.0",
  "name" : "SGHISubstance",
  "title" : "SGHI Substance",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Profile for representing substances in the SGHI context",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "orim",
      "uri" : "http://hl7.org/orim",
      "name" : "Ontological RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Substance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Substance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Substance",
        "path" : "Substance"
      },
      {
        "id" : "Substance.identifier",
        "path" : "Substance.identifier",
        "min" : 1
      },
      {
        "id" : "Substance.identifier.use",
        "path" : "Substance.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "Substance.identifier.type",
        "path" : "Substance.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "Substance.identifier.system",
        "path" : "Substance.identifier.system",
        "min" : 1
      },
      {
        "id" : "Substance.identifier.value",
        "path" : "Substance.identifier.value",
        "min" : 1
      },
      {
        "id" : "Substance.identifier.assigner",
        "path" : "Substance.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Substance.status",
        "path" : "Substance.status",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/substance-status"
        }
      },
      {
        "id" : "Substance.category",
        "path" : "Substance.category",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Substance.code",
        "path" : "Substance.code",
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ],
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/SubstanceDefinition"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/substance-codes"
        }
      },
      {
        "id" : "Substance.description",
        "path" : "Substance.description",
        "min" : 1
      },
      {
        "id" : "Substance.expiry",
        "path" : "Substance.expiry",
        "min" : 1
      },
      {
        "id" : "Substance.quantity",
        "path" : "Substance.quantity",
        "min" : 1
      },
      {
        "id" : "Substance.ingredient",
        "path" : "Substance.ingredient",
        "min" : 1
      },
      {
        "id" : "Substance.ingredient.quantity",
        "path" : "Substance.ingredient.quantity",
        "min" : 1
      },
      {
        "id" : "Substance.ingredient.substance[x]",
        "path" : "Substance.ingredient.substance[x]",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/substance-codes"
        }
      }
    ]
  }
}

```
