# SGHI Plan Definition Profile - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Plan Definition Profile**

## Resource Profile: SGHI Plan Definition Profile 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/plandefinition | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIPlanDefinition |

 
This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. 

**Usages:**

* Refer to this Profile: [SGHI Plan Definition Profile](StructureDefinition-plandefinition.md)
* Examples for this Profile: [PlanDefinition Name](PlanDefinition-ExampleSGHIPlanDefinition.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/plandefinition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-plandefinition.csv), [Excel](StructureDefinition-plandefinition.xlsx), [Schematron](StructureDefinition-plandefinition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "plandefinition",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-implements",
      "valueUri" : "http://hl7.org/fhir/StructureDefinition/MetadataResource"
    }
  ],
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/plandefinition",
  "version" : "0.1.0",
  "name" : "SGHIPlanDefinition",
  "title" : "SGHI Plan Definition Profile",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PlanDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PlanDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PlanDefinition",
        "path" : "PlanDefinition"
      },
      {
        "id" : "PlanDefinition.identifier",
        "path" : "PlanDefinition.identifier",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.identifier.use",
        "path" : "PlanDefinition.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "PlanDefinition.identifier.type",
        "path" : "PlanDefinition.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "PlanDefinition.identifier.system",
        "path" : "PlanDefinition.identifier.system",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.identifier.value",
        "path" : "PlanDefinition.identifier.value",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.identifier.assigner",
        "path" : "PlanDefinition.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "PlanDefinition.name",
        "path" : "PlanDefinition.name",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.title",
        "path" : "PlanDefinition.title",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.date",
        "path" : "PlanDefinition.date",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.useContext",
        "path" : "PlanDefinition.useContext",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.useContext.value[x]",
        "path" : "PlanDefinition.useContext.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "PlanDefinition.useContext.value[x]:valueCodeableConcept",
        "path" : "PlanDefinition.useContext.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "PlanDefinition.useContext.value[x]:valueReference",
        "path" : "PlanDefinition.useContext.value[x]",
        "sliceName" : "valueReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/plandefinition",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/fhir-location",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "PlanDefinition.action",
        "path" : "PlanDefinition.action",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.action.code",
        "path" : "PlanDefinition.action.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "PlanDefinition.action.reason",
        "path" : "PlanDefinition.action.reason",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      }
    ]
  }
}

```
