# SGHI Patient - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Patient**

## Resource Profile: SGHI Patient 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/patient | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIPatient |

 
Demographics and other administrative information about an individual or animal receiving care or other health-related services. 

**Usages:**

* Refer to this Profile: [SGHI AllergyIntolerance](StructureDefinition-allergyintolerance.md), [SGHI Appointment Profile](StructureDefinition-appointment.md), [SGHI Care Plan](StructureDefinition-careplan.md), [SGHI Composition](StructureDefinition-composition.md)...Show 15 more,[SGHI Condition](StructureDefinition-condition.md),[SGHI Consent](StructureDefinition-consent.md),[SGHI DiagnosticReport](StructureDefinition-diagnosticreport.md),[SGHI DocumentReference Profile.](StructureDefinition-documentreference.md),[SGHI Encounter](StructureDefinition-encounter.md),[SGHI EpisodeOfCare](StructureDefinition-episodeofcare.md),[SGHI Medication Dispense](StructureDefinition-medicationdispense.md),[SGHI MedicationRequest](StructureDefinition-medicationrequest.md),[SGHI Observation](StructureDefinition-observation.md),[SGHI Patient](StructureDefinition-patient.md),[SGHI Procedure](StructureDefinition-procedure.md),[SGHI RiskAssessment](StructureDefinition-riskassessment.md),[SGHI ServiceRequest](StructureDefinition-servicerequest.md),[SGHI Specimen](StructureDefinition-specimen.md)and[SGHI Task](StructureDefinition-task.md)
* Examples for this Profile: [Patient/ExampleSGHIPatient](Patient-ExampleSGHIPatient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient.csv), [Excel](StructureDefinition-patient.xlsx), [Schematron](StructureDefinition-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient",
  "version" : "0.1.0",
  "name" : "SGHIPatient",
  "title" : "SGHI Patient",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Demographics and other administrative information about an individual or animal receiving care or other health-related services.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "min" : 1
      },
      {
        "id" : "Patient.identifier.use",
        "path" : "Patient.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/patient-identifier-types"
        }
      },
      {
        "id" : "Patient.identifier.system",
        "path" : "Patient.identifier.system",
        "min" : 1
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "min" : 1
      },
      {
        "id" : "Patient.identifier.assigner",
        "path" : "Patient.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Patient.active",
        "path" : "Patient.active",
        "min" : 1
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/human-name"
            ]
          }
        ]
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "min" : 1,
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/contact-point"
            ]
          }
        ]
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "min" : 1
      },
      {
        "id" : "Patient.contact.relationship",
        "path" : "Patient.contact.relationship",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/contact-relationship"
        }
      },
      {
        "id" : "Patient.contact.name",
        "path" : "Patient.contact.name",
        "min" : 1,
        "type" : [
          {
            "code" : "HumanName",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/human-name"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.telecom",
        "path" : "Patient.contact.telecom",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/contact-point"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.organization",
        "path" : "Patient.contact.organization",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Patient.link.other",
        "path" : "Patient.link.other",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : false
              }
            ],
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      }
    ]
  }
}

```
