# SGHI Organization - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Organization**

## Resource Profile: SGHI Organization 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/organization | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIOrganization |

 
SGHI's profile for Organization 

**Usages:**

* Refer to this Profile: [SGHI Activity Defintion Profile](StructureDefinition-activitydefinition.md), [SGHI AllergyIntolerance](StructureDefinition-allergyintolerance.md), [SGHI Appointment Profile](StructureDefinition-appointment.md), [SGHI Care Plan](StructureDefinition-careplan.md)...Show 23 more,[SGHI Composition](StructureDefinition-composition.md),[SGHI Condition](StructureDefinition-condition.md),[SGHI Consent](StructureDefinition-consent.md),[SGHI DiagnosticReport](StructureDefinition-diagnosticreport.md),[SGHI DocumentReference Profile.](StructureDefinition-documentreference.md),[SGHI Encounter](StructureDefinition-encounter.md),[SGHI EpisodeOfCare](StructureDefinition-episodeofcare.md),[SGHI Location](StructureDefinition-fhir-location.md),[SGHI Medication](StructureDefinition-medication.md),[SGHI Medication Dispense](StructureDefinition-medicationdispense.md),[SGHI MedicationRequest](StructureDefinition-medicationrequest.md),[SGHI Observation](StructureDefinition-observation.md),[SGHI Organization](StructureDefinition-organization.md),[SGHI Patient](StructureDefinition-patient.md),[SGHI Plan Definition Profile](StructureDefinition-plandefinition.md),[SGHI Practitioner](StructureDefinition-practitioner.md),[SGHI PractitionerRole](StructureDefinition-practitionerrole.md),[SGHI Procedure](StructureDefinition-procedure.md),[SGHI RiskAssessment](StructureDefinition-riskassessment.md),[SGHI ServiceRequest](StructureDefinition-servicerequest.md),[SGHI Specimen](StructureDefinition-specimen.md),[SGHI Substance](StructureDefinition-substance.md)and[SGHI Task](StructureDefinition-task.md)
* Examples for this Profile: [SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-organization.csv), [Excel](StructureDefinition-organization.xlsx), [Schematron](StructureDefinition-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "organization",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization",
  "version" : "0.1.0",
  "name" : "SGHIOrganization",
  "title" : "SGHI Organization",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "SGHI's profile for Organization",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.use",
        "path" : "Organization.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "Organization.identifier.type",
        "path" : "Organization.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/organization-identifier-types"
        }
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.active",
        "path" : "Organization.active",
        "min" : 1
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "min" : 1
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Organization.qualification.issuer",
        "path" : "Organization.qualification.issuer",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      }
    ]
  }
}

```
