# SGHI HumanName - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI HumanName**

## Data Type Profile: SGHI HumanName 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/human-name | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIHumanName |

 
A specialized human name data type with stricter cardinalities. 

**Usages:**

* Use this DataType Profile: [SGHI Patient](StructureDefinition-patient.md), [SGHI Practitioner](StructureDefinition-practitioner.md) and [SGHI PractitionerRole](StructureDefinition-practitionerrole.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/human-name)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-human-name.csv), [Excel](StructureDefinition-human-name.xlsx), [Schematron](StructureDefinition-human-name.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "human-name",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/human-name",
  "version" : "0.1.0",
  "name" : "SGHIHumanName",
  "title" : "SGHI HumanName",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A specialized human name data type with stricter cardinalities.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "HumanName",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/HumanName",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "HumanName",
        "path" : "HumanName"
      },
      {
        "id" : "HumanName.use",
        "path" : "HumanName.use",
        "min" : 1
      },
      {
        "id" : "HumanName.text",
        "path" : "HumanName.text",
        "min" : 1
      },
      {
        "id" : "HumanName.family",
        "path" : "HumanName.family",
        "min" : 1
      },
      {
        "id" : "HumanName.given",
        "path" : "HumanName.given",
        "min" : 1
      }
    ]
  }
}

```
