# SGHI Location - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Location**

## Resource Profile: SGHI Location 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/fhir-location | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHILocation |

 
SGHI profile for location 

**Usages:**

* Refer to this Profile: [SGHI Appointment Profile](StructureDefinition-appointment.md), [SGHI Encounter](StructureDefinition-encounter.md), [SGHI Location](StructureDefinition-fhir-location.md), [SGHI Medication Dispense](StructureDefinition-medicationdispense.md)...Show 4 more,[SGHI Plan Definition Profile](StructureDefinition-plandefinition.md),[SGHI PractitionerRole](StructureDefinition-practitionerrole.md),[SGHI Procedure](StructureDefinition-procedure.md)and[SGHI ServiceRequest](StructureDefinition-servicerequest.md)
* Examples for this Profile: [SGHI Location](Location-ExampleSGHILocation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/fhir-location)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-fhir-location.csv), [Excel](StructureDefinition-fhir-location.xlsx), [Schematron](StructureDefinition-fhir-location.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "fhir-location",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/fhir-location",
  "version" : "0.1.0",
  "name" : "SGHILocation",
  "title" : "SGHI Location",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "SGHI profile for location",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location"
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "min" : 1
      },
      {
        "id" : "Location.identifier.use",
        "path" : "Location.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "Location.identifier.type",
        "path" : "Location.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "Location.identifier.system",
        "path" : "Location.identifier.system",
        "min" : 1
      },
      {
        "id" : "Location.identifier.value",
        "path" : "Location.identifier.value",
        "min" : 1
      },
      {
        "id" : "Location.identifier.assigner",
        "path" : "Location.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Location.status",
        "path" : "Location.status",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.operationalStatus",
        "path" : "Location.operationalStatus",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/bed-status"
        }
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.description",
        "path" : "Location.description",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.mode",
        "path" : "Location.mode",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.contact",
        "path" : "Location.contact",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Location.contact.telecom",
        "path" : "Location.contact.telecom",
        "min" : 1,
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/contact-point"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.contact.telecom.system",
        "path" : "Location.contact.telecom.system",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/contact-system"
        }
      },
      {
        "id" : "Location.contact.telecom.value",
        "path" : "Location.contact.telecom.value",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.contact.telecom.use",
        "path" : "Location.contact.telecom.use",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/contact-point-use"
        }
      },
      {
        "id" : "Location.contact.organization",
        "path" : "Location.contact.organization",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Location.form",
        "path" : "Location.form",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/location-form"
        }
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.partOf",
        "path" : "Location.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/fhir-location"
            ]
          }
        ]
      },
      {
        "id" : "Location.hoursOfOperation",
        "path" : "Location.hoursOfOperation",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      }
    ]
  }
}

```
