# SGHI Dosage - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Dosage**

## Data Type Profile: SGHI Dosage 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/dosage | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIDosage |

 
A comprehensive Dosage profile for SGHI prescriptions, ensuring structured routes, methods, timing, and dose details. 

**Usages:**

* Use this DataType Profile: [SGHI Activity Defintion Profile](StructureDefinition-activitydefinition.md), [SGHI Medication Dispense](StructureDefinition-medicationdispense.md), [SGHI MedicationRequest](StructureDefinition-medicationrequest.md) and [SGHI Task](StructureDefinition-task.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/dosage)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-dosage.csv), [Excel](StructureDefinition-dosage.xlsx), [Schematron](StructureDefinition-dosage.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "dosage",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/dosage",
  "version" : "0.1.0",
  "name" : "SGHIDosage",
  "title" : "SGHI Dosage",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A comprehensive Dosage profile for SGHI prescriptions, ensuring structured routes, methods, timing, and dose details.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Dosage",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Dosage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Dosage.additionalInstruction",
        "path" : "Dosage.additionalInstruction",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Dosage.timing",
        "path" : "Dosage.timing",
        "min" : 1
      },
      {
        "id" : "Dosage.asNeededFor",
        "path" : "Dosage.asNeededFor",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Dosage.site",
        "path" : "Dosage.site",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/body-site-value-set"
        }
      },
      {
        "id" : "Dosage.route",
        "path" : "Dosage.route",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/route-of-administration"
        }
      },
      {
        "id" : "Dosage.method",
        "path" : "Dosage.method",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/method-of-administration"
        }
      },
      {
        "id" : "Dosage.doseAndRate",
        "path" : "Dosage.doseAndRate",
        "min" : 1
      },
      {
        "id" : "Dosage.doseAndRate.type",
        "path" : "Dosage.doseAndRate.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]",
        "path" : "Dosage.doseAndRate.dose[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseQuantity",
        "path" : "Dosage.doseAndRate.dose[x]",
        "sliceName" : "doseQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseQuantity.system",
        "path" : "Dosage.doseAndRate.dose[x].system",
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseRange",
        "path" : "Dosage.doseAndRate.dose[x]",
        "sliceName" : "doseRange",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseRange.low.system",
        "path" : "Dosage.doseAndRate.dose[x].low.system",
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]:doseRange.high.system",
        "path" : "Dosage.doseAndRate.dose[x].high.system",
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]",
        "path" : "Dosage.doseAndRate.rate[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "Ratio"
          },
          {
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]:rateRatio",
        "path" : "Dosage.doseAndRate.rate[x]",
        "sliceName" : "rateRatio",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]:rateRatio.numerator.system",
        "path" : "Dosage.doseAndRate.rate[x].numerator.system",
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]:rateRatio.denominator.system",
        "path" : "Dosage.doseAndRate.rate[x].denominator.system",
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]:rateRange",
        "path" : "Dosage.doseAndRate.rate[x]",
        "sliceName" : "rateRange",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]:rateRange.low.system",
        "path" : "Dosage.doseAndRate.rate[x].low.system",
        "fixedUri" : "http://unitsofmeasure.org"
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]:rateRange.high.system",
        "path" : "Dosage.doseAndRate.rate[x].high.system",
        "fixedUri" : "http://unitsofmeasure.org"
      }
    ]
  }
}

```
