# SGHI DocumentReference Profile. - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI DocumentReference Profile.**

## Resource Profile: SGHI DocumentReference Profile. 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/documentreference | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIDocumentReference |

 
A reference to a document of any kind for any purpose. 

**Usages:**

* Refer to this Profile: [SGHI DocumentReference Profile.](StructureDefinition-documentreference.md)
* Examples for this Profile: [DocumentReference/ExampleSGHIDocumentReference](DocumentReference-ExampleSGHIDocumentReference.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/documentreference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-documentreference.csv), [Excel](StructureDefinition-documentreference.xlsx), [Schematron](StructureDefinition-documentreference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "documentreference",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/documentreference",
  "version" : "0.1.0",
  "name" : "SGHIDocumentReference",
  "title" : "SGHI DocumentReference Profile.",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A reference to a document of any kind for any purpose.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference"
      },
      {
        "id" : "DocumentReference.identifier",
        "path" : "DocumentReference.identifier",
        "min" : 1
      },
      {
        "id" : "DocumentReference.identifier.use",
        "path" : "DocumentReference.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "DocumentReference.identifier.type",
        "path" : "DocumentReference.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "DocumentReference.identifier.system",
        "path" : "DocumentReference.identifier.system",
        "min" : 1
      },
      {
        "id" : "DocumentReference.identifier.value",
        "path" : "DocumentReference.identifier.value",
        "min" : 1
      },
      {
        "id" : "DocumentReference.identifier.assigner",
        "path" : "DocumentReference.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.basedOn",
        "path" : "DocumentReference.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/appointment",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/medicationrequest",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/servicerequest"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.docStatus",
        "path" : "DocumentReference.docStatus",
        "min" : 1
      },
      {
        "id" : "DocumentReference.modality",
        "path" : "DocumentReference.modality",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.type",
        "path" : "DocumentReference.type",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/doc-typecodes"
        }
      },
      {
        "id" : "DocumentReference.category",
        "path" : "DocumentReference.category",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.context",
        "path" : "DocumentReference.context",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/appointment",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/encounter",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/episodeofcare"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.event",
        "path" : "DocumentReference.event",
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.bodySite",
        "path" : "DocumentReference.bodySite",
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ],
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/BodyStructure"]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/all-loinc-codes"
        }
      },
      {
        "id" : "DocumentReference.facilityType",
        "path" : "DocumentReference.facilityType",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.practiceSetting",
        "path" : "DocumentReference.practiceSetting",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.date",
        "path" : "DocumentReference.date",
        "min" : 1
      },
      {
        "id" : "DocumentReference.author",
        "path" : "DocumentReference.author",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitionerrole",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitioner",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.attester.mode",
        "path" : "DocumentReference.attester.mode",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.attester.party",
        "path" : "DocumentReference.attester.party",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitioner",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitionerrole"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.custodian",
        "path" : "DocumentReference.custodian",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.relatesTo.code",
        "path" : "DocumentReference.relatesTo.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.relatesTo.target",
        "path" : "DocumentReference.relatesTo.target",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/documentreference"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.securityLabel",
        "path" : "DocumentReference.securityLabel",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      }
    ]
  }
}

```
