# SGHI Consent - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Consent**

## Resource Profile: SGHI Consent 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/consent | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIConsent |

 
A record of a healthcare consumer’s choices or choices made on their behalf by a third party, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time. 

**Usages:**

* Refer to this Profile: [SGHI Consent](StructureDefinition-consent.md)
* Examples for this Profile: [Consent/ExampleSGHIConsent](Consent-ExampleSGHIConsent.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/consent)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-consent.csv), [Excel](StructureDefinition-consent.xlsx), [Schematron](StructureDefinition-consent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "consent",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/consent",
  "version" : "0.1.0",
  "name" : "SGHIConsent",
  "title" : "SGHI Consent",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A record of a healthcare consumer’s choices or choices made on their behalf by a third party, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Consent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent"
      },
      {
        "id" : "Consent.identifier",
        "path" : "Consent.identifier",
        "min" : 1
      },
      {
        "id" : "Consent.identifier.use",
        "path" : "Consent.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "Consent.identifier.type",
        "path" : "Consent.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "Consent.identifier.system",
        "path" : "Consent.identifier.system",
        "min" : 1
      },
      {
        "id" : "Consent.identifier.value",
        "path" : "Consent.identifier.value",
        "min" : 1
      },
      {
        "id" : "Consent.identifier.assigner",
        "path" : "Consent.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Consent.category",
        "path" : "Consent.category",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Consent.subject",
        "path" : "Consent.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "Consent.date",
        "path" : "Consent.date",
        "min" : 1
      },
      {
        "id" : "Consent.grantor",
        "path" : "Consent.grantor",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "Consent.grantee",
        "path" : "Consent.grantee",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Consent.manager",
        "path" : "Consent.manager",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "Consent.controller",
        "path" : "Consent.controller",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "Consent.sourceAttachment",
        "path" : "Consent.sourceAttachment",
        "type" : [
          {
            "code" : "Attachment",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/attachment"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Consent.sourceReference",
        "path" : "Consent.sourceReference",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/consent"
            ]
          }
        ]
      },
      {
        "id" : "Consent.regulatoryBasis",
        "path" : "Consent.regulatoryBasis",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Consent.policyBasis.reference",
        "path" : "Consent.policyBasis.reference",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ]
      },
      {
        "id" : "Consent.policyText",
        "path" : "Consent.policyText",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DocumentReference"]
          }
        ]
      },
      {
        "id" : "Consent.verification",
        "path" : "Consent.verification",
        "min" : 1
      },
      {
        "id" : "Consent.verification.verificationType",
        "path" : "Consent.verification.verificationType",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Consent.verification.verifiedBy",
        "path" : "Consent.verification.verifiedBy",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Consent.verification.verifiedWith",
        "path" : "Consent.verification.verifiedWith",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "Consent.verification.verificationDate",
        "path" : "Consent.verification.verificationDate",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Consent.decision",
        "path" : "Consent.decision",
        "min" : 1
      },
      {
        "id" : "Consent.provision.actor.role",
        "path" : "Consent.provision.actor.role",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Consent.provision.actor.reference",
        "path" : "Consent.provision.actor.reference",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Consent.provision.action",
        "path" : "Consent.provision.action",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Consent.provision.code",
        "path" : "Consent.provision.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/consent-content-code"
        }
      },
      {
        "id" : "Consent.provision.data.reference",
        "path" : "Consent.provision.data.reference",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ]
      }
    ]
  }
}

```
