# SGHI Care Plan - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Care Plan**

## Resource Profile: SGHI Care Plan 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/careplan | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHICarePlan |

 
A profile on the R5 CarePlan resource to represent a patient's treatment or management plan, such as a chemotherapy regimen. 

**Usages:**

* Examples for this Profile: [CarePlan/ExampleSGHICarePlan](CarePlan-ExampleSGHICarePlan.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/careplan)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-careplan.csv), [Excel](StructureDefinition-careplan.xlsx), [Schematron](StructureDefinition-careplan.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "careplan",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/careplan",
  "version" : "0.1.0",
  "name" : "SGHICarePlan",
  "title" : "SGHI Care Plan",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A profile on the R5 CarePlan resource to represent a patient's treatment or management plan, such as a chemotherapy regimen.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CarePlan",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CarePlan",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CarePlan",
        "path" : "CarePlan"
      },
      {
        "id" : "CarePlan.identifier",
        "path" : "CarePlan.identifier",
        "min" : 1
      },
      {
        "id" : "CarePlan.identifier.use",
        "path" : "CarePlan.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "CarePlan.identifier.type",
        "path" : "CarePlan.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "CarePlan.identifier.system",
        "path" : "CarePlan.identifier.system",
        "min" : 1
      },
      {
        "id" : "CarePlan.identifier.value",
        "path" : "CarePlan.identifier.value",
        "min" : 1
      },
      {
        "id" : "CarePlan.identifier.assigner",
        "path" : "CarePlan.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.instantiatesCanonical",
        "path" : "CarePlan.instantiatesCanonical",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.title",
        "path" : "CarePlan.title",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.description",
        "path" : "CarePlan.description",
        "min" : 1
      },
      {
        "id" : "CarePlan.subject",
        "path" : "CarePlan.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.created",
        "path" : "CarePlan.created",
        "min" : 1
      },
      {
        "id" : "CarePlan.custodian",
        "path" : "CarePlan.custodian",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.activity",
        "path" : "CarePlan.activity",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.activity.performedActivity",
        "path" : "CarePlan.activity.performedActivity",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ],
            "targetProfile" : ["https://fhir.slade360.co.ke/fhir/StructureDefinition/task"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.note.author[x]",
        "path" : "CarePlan.note.author[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "CarePlan.note.author[x]:authorReference",
        "path" : "CarePlan.note.author[x]",
        "sliceName" : "authorReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitioner"
            ]
          }
        ]
      }
    ]
  }
}

```
