# SGHI Activity Defintion Profile - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Activity Defintion Profile**

## Resource Profile: SGHI Activity Defintion Profile 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/activitydefinition | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIActivityDefinition |

 
This resouce allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context. 

**Usages:**

* Examples for this Profile: [Example ActivityDefition Name](ActivityDefinition-ExampleActivityDefintion.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/activitydefinition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-activitydefinition.csv), [Excel](StructureDefinition-activitydefinition.xlsx), [Schematron](StructureDefinition-activitydefinition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "activitydefinition",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-implements",
      "valueUri" : "http://hl7.org/fhir/StructureDefinition/MetadataResource"
    }
  ],
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/activitydefinition",
  "version" : "0.1.0",
  "name" : "SGHIActivityDefinition",
  "title" : "SGHI Activity Defintion Profile",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This resouce allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ActivityDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ActivityDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ActivityDefinition",
        "path" : "ActivityDefinition"
      },
      {
        "id" : "ActivityDefinition.identifier",
        "path" : "ActivityDefinition.identifier",
        "min" : 1
      },
      {
        "id" : "ActivityDefinition.identifier.use",
        "path" : "ActivityDefinition.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "ActivityDefinition.identifier.type",
        "path" : "ActivityDefinition.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "ActivityDefinition.identifier.system",
        "path" : "ActivityDefinition.identifier.system",
        "min" : 1
      },
      {
        "id" : "ActivityDefinition.identifier.value",
        "path" : "ActivityDefinition.identifier.value",
        "min" : 1
      },
      {
        "id" : "ActivityDefinition.identifier.assigner",
        "path" : "ActivityDefinition.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "ActivityDefinition.name",
        "path" : "ActivityDefinition.name",
        "min" : 1
      },
      {
        "id" : "ActivityDefinition.title",
        "path" : "ActivityDefinition.title",
        "min" : 1
      },
      {
        "id" : "ActivityDefinition.dosage",
        "path" : "ActivityDefinition.dosage",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/dosage"
            ]
          }
        ]
      }
    ]
  }
}

```
