# ExampleSGHIServiceRequest - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIServiceRequest**

## Example ServiceRequest: ExampleSGHIServiceRequest

Profile: [SGHI ServiceRequest](StructureDefinition-servicerequest.md)

**identifier**: Visit Number/APT123456 (use: official, )

**basedOn**: [MedicationRequest: identifier = Prescription Number: RX123456789 (use: official, ); status = active; intent = plan; category = Inpatient; priority = routine; authoredOn = 2025-01-22; effectiveDosePeriod = 2025-01-22 --> 2025-02-01](MedicationRequest-ExampleSGHIMedicationRequest.md)

**status**: Active

**intent**: Plan

**category**: Laboratory procedure

**priority**: Routine

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | Procedure |

> **orderDetail**

### ParameterFocus

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication Request](MedicationRequest-ExampleSGHIMedicationRequest.md) |

### Parameters

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Laboratory studies (set) | Value String |


**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**authoredOn**: 2025-02-01 10:30:00+0000

**requester**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

**performer**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Condition](Condition-ExampleSGHICondition.md) |



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "ExampleSGHIServiceRequest",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/servicerequest"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "VN",
            "display" : "Visit Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "APT123456",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "basedOn" : [
    {
      "reference" : "MedicationRequest/ExampleSGHIMedicationRequest"
    }
  ],
  "status" : "active",
  "intent" : "plan",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "108252007",
          "display" : "Laboratory procedure"
        }
      ]
    }
  ],
  "priority" : "routine",
  "code" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "71388002",
          "display" : "Procedure"
        }
      ],
      "text" : "Procedure"
    }
  },
  "orderDetail" : [
    {
      "parameterFocus" : {
        "reference" : {
          "reference" : "MedicationRequest/ExampleSGHIMedicationRequest",
          "display" : "Medication Request"
        }
      },
      "parameter" : [
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "26436-6",
                "display" : "Laboratory studies (set)"
              }
            ],
            "text" : "Laboratory studies (set)"
          },
          "valueString" : "Value String"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "authoredOn" : "2025-02-01T10:30:00Z",
  "requester" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "performer" : [
    {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  ],
  "reason" : [
    {
      "reference" : {
        "reference" : "Condition/ExampleSGHICondition",
        "display" : "Condition"
      }
    }
  ]
}

```
