# ExampleSGHIPractitioner - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIPractitioner**

## Example Practitioner: ExampleSGHIPractitioner

Profile: [SGHI Practitioner](StructureDefinition-practitioner.md)

**identifier**: Medical Record Number/12345

**active**: true

**name**: James Pond(Official)

**telecom**: [+254-722-123456](tel:+254-722-123456)

**gender**: Male

**birthDate**: 1990-07-15

### Qualifications

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Identifier** | **Code** | **Period** | **Issuer** |
| * | Medical Record Number/Q-12345 | Nurse Practitioner | 2010-07-15 --> 2030-07-15 | [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md) |



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "ExampleSGHIPractitioner",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitioner"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "12345",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "text" : "James Pond",
      "family" : "Pond",
      "given" : ["James"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+254-722-123456"
    }
  ],
  "gender" : "male",
  "birthDate" : "1990-07-15",
  "qualification" : [
    {
      "identifier" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "MR",
                "display" : "Medical Record Number"
              }
            ]
          },
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "value" : "Q-12345",
          "assigner" : {
            "reference" : "Organization/ExampleSGHIOrganization"
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0360",
            "code" : "NP",
            "display" : "Nurse Practitioner"
          }
        ]
      },
      "period" : {
        "start" : "2010-07-15",
        "end" : "2030-07-15"
      },
      "issuer" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ]
}

```
