# ExampleSGHIPatient - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIPatient**

## Example Patient: ExampleSGHIPatient

Profiles: [SGHI Patient](StructureDefinition-patient.md), `{{HAPI_FHIR_BASE_URL}}/StructureDefinition/patient`

James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)

-------

| | |
| :--- | :--- |
| Active: | true |
| Contact Detail | [+254-722-123456](tel:+254-722-123456) |
| Next of kin: | * Mary Pond(Official)
* [+254-733-987654](tel:+254-733-987654)
 |
| Links: | * Managing Organization: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ExampleSGHIPatient",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient",
      "{{HAPI_FHIR_BASE_URL}}/StructureDefinition/patient"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "12345",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "text" : "James Pond",
      "family" : "Pond",
      "given" : ["James"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+254-722-123456"
    }
  ],
  "gender" : "male",
  "birthDate" : "1990-07-15",
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "N",
              "display" : "Next of kin"
            }
          ]
        }
      ],
      "name" : {
        "use" : "official",
        "text" : "Mary Pond",
        "family" : "Pond",
        "given" : ["Mary"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+254-733-987654"
        }
      ]
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  }
}

```
