# ExampleSGHIObservation - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIObservation**

## Example Observation: ExampleSGHIObservation

Profile: [SGHI Observation](StructureDefinition-observation.md)

**identifier**: Medical Record Number/3456789QWERTY (use: official, )

**status**: Final

**category**: Laboratory

**code**: Normal

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**effective**: 2025-02-10 08:00:00+0000

**issued**: 2025-02-10 08:00:00+0000

**performer**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

**interpretation**: Normal



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ExampleSGHIObservation",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/observation"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "3456789QWERTY",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "N",
        "display" : "Normal"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "effectiveInstant" : "2025-02-10T08:00:00Z",
  "issued" : "2025-02-10T08:00:00Z",
  "performer" : [
    {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  ],
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ]
    }
  ]
}

```
