# SGHI Medication Dispense - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Medication Dispense**

## Example MedicationDispense: SGHI Medication Dispense

Profile: [SGHI Medication Dispense](StructureDefinition-medicationdispense.md)

**identifier**: Medical record number/example-medication-dispense-id (use: official, )

**status**: Completed

### Medications

| | | |
| :--- | :--- | :--- |
| - | **Concept** | **Reference** |
| * | Medication Name | [Panadol](Medication-ExampleSGHIMedication.md) |

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md) |

**location**: [Pharmacy Location](Location-ExampleSGHILocation.md)

**authorizingPrescription**: [MedicationRequest: identifier = Prescription Number: RX123456789 (use: official, ); status = active; intent = plan; category = Inpatient; priority = routine; authoredOn = 2025-01-22; effectiveDosePeriod = 2025-01-22 --> 2025-02-01](MedicationRequest-ExampleSGHIMedicationRequest.md)

**type**: None

**quantity**: 30 tablets(Details: UCUM codetablet = 'tablet')

**whenPrepared**: 2023-10-20 10:00:00+0000

**whenHandedOver**: 2023-10-20 11:00:00+0000

**destination**: [Patient's Home](Location-ExampleSGHILocation.md)

**receiver**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**renderedDosageInstruction**: 

Take one tablet daily with meals

> **dosageInstruction****sequence**: 1**text**: Take 500 mg by mouth twice daily for 10 days after meals**additionalInstruction**:Take with food**patientInstruction**: Drink plenty of water with each dose**timing**: 2 per 1 day**asNeeded**: false**site**:Oral cavity structure**route**:Oral**method**:Swallow whole

### DoseAndRates

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Dose[x]** | **Rate[x]** |
| * | Calculated dose | 500 mg(Details: UCUM codemg = 'mg') | 100 mL(Details: UCUM codemL = 'mL')/1 hr(Details: UCUM codeh = 'h') |


### Substitutions

| | | | |
| :--- | :--- | :--- | :--- |
| - | **WasSubstituted** | **Type** | **ResponsibleParty** |
| * | false | None | [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md) |



## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "ExampleSGHIMedicationDispense",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/medicationdispense"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical record number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "example-medication-dispense-id",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "completed",
  "medication" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
          "code" : "123456",
          "display" : "Medication Name"
        }
      ]
    },
    "reference" : {
      "reference" : "Medication/ExampleSGHIMedication",
      "display" : "Panadol"
    }
  },
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "location" : {
    "reference" : "Location/ExampleSGHILocation",
    "display" : "Pharmacy Location"
  },
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/ExampleSGHIMedicationRequest"
    }
  ],
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution",
        "code" : "DF",
        "display" : "None"
      }
    ]
  },
  "quantity" : {
    "value" : 30,
    "unit" : "tablets",
    "system" : "http://unitsofmeasure.org",
    "code" : "tablet"
  },
  "whenPrepared" : "2023-10-20T10:00:00Z",
  "whenHandedOver" : "2023-10-20T11:00:00Z",
  "destination" : {
    "reference" : "Location/ExampleSGHILocation",
    "display" : "Patient's Home"
  },
  "receiver" : [
    {
      "reference" : "Patient/ExampleSGHIPatient"
    }
  ],
  "renderedDosageInstruction" : "Take one tablet daily with meals",
  "dosageInstruction" : [
    {
      "sequence" : 1,
      "text" : "Take 500 mg by mouth twice daily for 10 days after meals",
      "additionalInstruction" : [
        {
          "coding" : [
            {
              "system" : "http://example.org/fhir/CodeSystem/AdditionalInstructions",
              "code" : "withFood",
              "display" : "Take with food"
            }
          ]
        }
      ],
      "patientInstruction" : "Drink plenty of water with each dose",
      "timing" : {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2025-01-22",
            "end" : "2025-02-01"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "asNeeded" : false,
      "site" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "N",
            "display" : "Oral cavity structure"
          }
        ]
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration",
            "code" : "PO",
            "display" : "Oral"
          }
        ]
      },
      "method" : {
        "coding" : [
          {
            "system" : "http://example.org/fhir/CodeSystem/MedicationAdministrationMethod",
            "code" : "SWALLOW",
            "display" : "Swallow whole"
          }
        ]
      },
      "doseAndRate" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                "code" : "calculated",
                "display" : "Calculated dose"
              }
            ]
          },
          "doseQuantity" : {
            "value" : 500,
            "unit" : "mg",
            "system" : "http://unitsofmeasure.org",
            "code" : "mg"
          },
          "rateRatio" : {
            "numerator" : {
              "value" : 100,
              "unit" : "mL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mL"
            },
            "denominator" : {
              "value" : 1,
              "unit" : "hr",
              "system" : "http://unitsofmeasure.org",
              "code" : "h"
            }
          }
        }
      ]
    }
  ],
  "substitution" : {
    "wasSubstituted" : false,
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution",
          "code" : "N",
          "display" : "None"
        }
      ]
    },
    "responsibleParty" : {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  }
}

```
