# SGHI Medication resource example - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Medication resource example**

## Example Medication: SGHI Medication resource example

Profiles: [SGHI Medication](StructureDefinition-medication.md), `{{HAPI_FHIR_BASE_URL}}/StructureDefinition/medication`

**identifier**: Serial Number/example-medication-id (use: official, )

**code**: Panadol 500mg tablets

**status**: Active

**marketingAuthorizationHolder**: [Organization](Organization-ExampleSGHIOrganization.md)

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Substance Paracetamol](Substance-ExampleSGHISubstance.md) |

**isActive**: true**strength**: 250 mg(Details: UCUM codemg = 'mg')/1 tablet(Details: Orderable Drug Form codeTAB = 'Tablet')



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "ExampleSGHIMedication",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/medication",
      "{{HAPI_FHIR_BASE_URL}}/StructureDefinition/medication"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "SNO",
            "display" : "Serial Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "example-medication-id",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "code" : {
    "coding" : [
      {
        "code" : "AMP",
        "display" : "Panadol 500mg tablets"
      }
    ]
  },
  "status" : "active",
  "marketingAuthorizationHolder" : {
    "reference" : "Organization/ExampleSGHIOrganization",
    "display" : "Organization"
  },
  "ingredient" : [
    {
      "item" : {
        "reference" : {
          "reference" : "Substance/ExampleSGHISubstance"
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "numerator" : {
          "value" : 250,
          "unit" : "mg",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "tablet",
          "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
          "code" : "TAB"
        }
      }
    }
  ]
}

```
