# ExampleSGHILocation - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHILocation**

## Example Location: ExampleSGHILocation

Profile: [SGHI Location](StructureDefinition-fhir-location.md)

**identifier**: Jurisdictional health number/JHN123456789 (use: official, )

**status**: Active

**operationalStatus**: [not stated]: ISOLATED (Isolated)

**name**: SGHI Location

**description**: 

SGHI Location description

**mode**: Kind

### Contacts

| | |
| :--- | :--- |
| - | **Telecom** |
| * | [+254790360360](tel:+254790360360) |

**form**: Wing

**managingOrganization**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

> **hoursOfOperation**

### AvailableTimes

| | |
| :--- | :--- |
| - | **AllDay** |
| * | true |




## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "ExampleSGHILocation",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/fhir-location"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "JHN",
            "display" : "Jurisdictional health number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "JHN123456789",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "active",
  "operationalStatus" : {
    "code" : "ISOLATED",
    "display" : "Isolated"
  },
  "name" : "SGHI Location",
  "description" : "SGHI Location description",
  "mode" : "kind",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+254790360360",
          "use" : "work"
        }
      ]
    }
  ],
  "form" : {
    "coding" : [
      {
        "code" : "wi",
        "display" : "Wing"
      }
    ]
  },
  "managingOrganization" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "hoursOfOperation" : [
    {
      "availableTime" : [
        {
          "allDay" : true
        }
      ]
    }
  ]
}

```
