# ExampleSGHIEncounter - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIEncounter**

## Example Encounter: ExampleSGHIEncounter

Profile: [SGHI Encounter](StructureDefinition-encounter.md)

**identifier**: Visit Number/VN123456789 (use: official, )

**status**: In Progress

**class**: Ambulatory

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**episodeOfCare**: [EpisodeOfCare: identifier = Visit Number: EOC1234567890 (use: official, ); status = active; period = 2025-01-01 --> 2025-01-31](EpisodeOfCare-ExampleSGHIEpisodeOfCare.md)

**serviceProvider**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

### Participants

| | |
| :--- | :--- |
| - | **Actor** |
| * | [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md) |

**appointment**: [Appointment: identifier = Accession ID: APT123456 (use: official, ); status = booked; specialty = General practice; appointmentType = Routine appointment; priority = Routine; start = 2023-11-25 09:00:00+0000; end = 2023-11-25 09:30:00+0000; created = 2023-11-20 10:00:00+0000; note = Patient requested morning appointment](Appointment-ExampleSGHIAppointment.md)

> **diagnosis**

### Conditions

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Condition Hypertension](Condition-ExampleSGHICondition.md) |




## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "ExampleSGHIEncounter",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/encounter"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "VN",
            "display" : "Visit Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "VN123456789",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "in-progress",
  "class" : [
    {
      "coding" : [
        {
          "code" : "AMB",
          "display" : "Ambulatory"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "episodeOfCare" : [
    {
      "reference" : "EpisodeOfCare/ExampleSGHIEpisodeOfCare"
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "participant" : [
    {
      "actor" : {
        "reference" : "Patient/ExampleSGHIPatient"
      }
    }
  ],
  "appointment" : [
    {
      "reference" : "Appointment/ExampleSGHIAppointment"
    }
  ],
  "diagnosis" : [
    {
      "condition" : [
        {
          "reference" : {
            "reference" : "Condition/ExampleSGHICondition"
          }
        }
      ]
    }
  ]
}

```
