# ExampleSGHIDiagnosticReport - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIDiagnosticReport**

## Example DiagnosticReport: ExampleSGHIDiagnosticReport

Profile: [SGHI DiagnosticReport](StructureDefinition-diagnosticreport.md)

## Hospice care Note (CAT Scan ) 

| | |
| :--- | :--- |
| Subject | James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345) |
| When For | 2025-02-10 08:00:00+0000 |
| Reported | 2025-02-10 08:00:00+0000 |
| Performer | [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md) |
| Identifier | Medical Record Number/qwerty3456789 (use: official, ) |

**Report Details**



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "ExampleSGHIDiagnosticReport",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/diagnosticreport"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "qwerty3456789",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "basedOn" : [
    {
      "reference" : "MedicationRequest/ExampleSGHIMedicationRequest"
    }
  ],
  "status" : "partial",
  "category" : [
    {
      "coding" : [
        {
          "code" : "CT",
          "display" : "CAT Scan"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "code" : "100018-1",
        "display" : "Hospice care Note"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "effectiveDateTime" : "2025-02-10T08:00:00Z",
  "issued" : "2025-02-10T08:00:00Z",
  "performer" : [
    {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  ],
  "resultsInterpreter" : [
    {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  ]
}

```
