# Example SGHI Consent - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example SGHI Consent**

## Example Consent: Example SGHI Consent

Profile: [SGHI Consent](StructureDefinition-consent.md)

**identifier**: Medical Record Number/550e8400-e29b-41d4-a716-446655440000 (use: official, )

**status**: Active

**category**: Patient Consent

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**date**: 2025-01-27

**grantor**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

**grantee**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**manager**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

**controller**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

### Verifications

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Verified** | **VerifiedBy** | **VerifiedWith** | **VerificationDate** |
| * | true | [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md) | [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md) | 2025-01-27 |

**decision**: Permit

> **provision**

### Actors

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Organization](Organization-ExampleSGHIOrganization.md) |




## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "ExampleSGHIConsent",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/consent"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "550e8400-e29b-41d4-a716-446655440000",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "code" : "59284-0",
          "display" : "Patient Consent"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "date" : "2025-01-27",
  "grantor" : [
    {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  ],
  "grantee" : [
    {
      "reference" : "Patient/ExampleSGHIPatient"
    }
  ],
  "manager" : [
    {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  ],
  "controller" : [
    {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  ],
  "verification" : [
    {
      "verified" : true,
      "verifiedBy" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      },
      "verifiedWith" : {
        "reference" : "Patient/ExampleSGHIPatient"
      },
      "verificationDate" : ["2025-01-27"]
    }
  ],
  "decision" : "permit",
  "provision" : [
    {
      "actor" : [
        {
          "reference" : {
            "reference" : "Organization/ExampleSGHIOrganization",
            "display" : "Organization"
          }
        }
      ]
    }
  ]
}

```
