# ExampleSGHICondition - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHICondition**

## Example Condition: ExampleSGHICondition

Profile: [SGHI Condition](StructureDefinition-condition.md)

**identifier**: Accession ID/AC123456789 (use: official, )

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Problem List Item

**severity**: Mild

**code**: Hypertension

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**recordedDate**: 2025-01-22

### Participants

| | |
| :--- | :--- |
| - | **Actor** |
| * | [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md) |



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "ExampleSGHICondition",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/condition"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ACSN",
            "display" : "Accession ID"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "AC123456789",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "code" : "problem-list-item",
          "display" : "Problem List Item"
        }
      ]
    }
  ],
  "severity" : {
    "coding" : [
      {
        "code" : "255604002",
        "display" : "Mild"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "code" : "123456",
        "display" : "Hypertension"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "recordedDate" : "2025-01-22",
  "participant" : [
    {
      "actor" : {
        "reference" : "Patient/ExampleSGHIPatient"
      }
    }
  ]
}

```
