# CIEL → ICD-11 Condition Map (generated 2025-07-09) - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CIEL → ICD-11 Condition Map (generated 2025-07-09)**

## ConceptMap: CIEL → ICD-11 Condition Map (generated 2025-07-09) 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoICD11Condition | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*: |



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "CIELtoICD11Condition",
  "url" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoICD11Condition",
  "version" : "0.1.0",
  "title" : "CIEL → ICD-11 Condition Map (generated 2025-07-09)",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "*",
      "target" : "https://icd.who.int/browse/2025-01/mms/en",
      "element" : [
        {
          "code" : "10",
          "display" : "Acute bronchitis",
          "target" : [
            {
              "code" : "CA42.Z",
              "display" : "Acute bronchitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "11",
          "display" : "Bronchitis, recurrent",
          "target" : [
            {
              "code" : "CA20.11",
              "display" : "Mucopurulent chronic bronchitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "80",
          "display" : "Joint pain",
          "target" : [
            {
              "code" : "VV12",
              "display" : "Pain in joints",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "106",
          "display" : "Acute Coryza",
          "target" : [
            {
              "code" : "CA00",
              "display" : "Acute nasopharyngitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "112",
          "display" : "Tonsillitis",
          "target" : [
            {
              "code" : "CA03.Z",
              "display" : "Acute tonsillitis, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "119",
          "display" : "Dermatitis",
          "target" : [
            {
              "code" : "EA8Z",
              "display" : "Dermatitis or eczema, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "124",
          "display" : "Amoebiasis",
          "target" : [
            {
              "code" : "1A36.Z",
              "display" : "Amoebiasis, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "134",
          "display" : "Cellulitis",
          "target" : [
            {
              "code" : "1B70",
              "display" : "cellulitis NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "147",
          "display" : "Bronchitis",
          "target" : [
            {
              "code" : "CA20.Z",
              "display" : "Bronchitis, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "151",
          "display" : "Abdominal pain",
          "target" : [
            {
              "code" : "MD81",
              "display" : "Abdominal or pelvic pain",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "226",
          "display" : "Neonatal sepsis",
          "target" : [
            {
              "code" : "KA60",
              "display" : "Sepsis of fetus or newborn",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "298",
          "display" : "Candidiasis, vaginal",
          "target" : [
            {
              "code" : "1F23.10",
              "display" : "Vulvovaginal candidosis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "432",
          "display" : "Medical examination, routine",
          "target" : [
            {
              "code" : "QA03.0",
              "display" : "Occupational health examination",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "490",
          "display" : "Hyperemesis gravidarum",
          "target" : [
            {
              "code" : "JA60.1",
              "display" : "Hyperemesis gravidarum with metabolic disturbance",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "512",
          "display" : "Rash",
          "target" : [
            {
              "code" : "ME66.6Z",
              "display" : "Rash, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "837",
          "display" : "Hyperacidity",
          "target" : [
            {
              "code" : "VV40",
              "display" : "hyperacidity of stomach",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "874",
          "display" : "Eye discharge",
          "target" : [
            {
              "code" : "MC14",
              "display" : "Eye discharge",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "879",
          "display" : "Pruritus",
          "target" : [
            {
              "code" : "EC90.Z",
              "display" : "Pruritus, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "902",
          "display" : "Pelvic inflammatory disease",
          "target" : [
            {
              "code" : "GA05.Z",
              "display" : "Female pelvic inflammatory diseases, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "994",
          "display" : "Adenitis, nos",
          "target" : [
            {
              "code" : "BD90",
              "display" : "adenitis NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1036",
          "display" : "Neisseria gonorrhoeae polymerase chain reaction",
          "target" : [
            {
              "code" : "MG50.6Y",
              "display" : "Neisseria gonorrhoeae resistant to other antibiotic",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1107",
          "display" : "None",
          "target" : [
            {
              "code" : "XS8H",
              "display" : "None",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1115",
          "display" : "Normal",
          "target" : [
            {
              "code" : "QA1C",
              "display" : "problem was normal state",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1226",
          "display" : "Anemia, iron deficiency",
          "target" : [
            {
              "code" : "3A00.Z",
              "display" : "Iron deficiency anaemia, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1293",
          "display" : "Gastroesophageal reflux disease",
          "target" : [
            {
              "code" : "DA22.Z",
              "display" : "Gastro-oesophageal reflux disease",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1387",
          "display" : "Depo-provera use",
          "target" : [
            {
              "code" : "QA21.5",
              "display" : "Surveillance of contraceptive drugs",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1425",
          "display" : "Antenatal visit number",
          "target" : [
            {
              "code" : "QA44",
              "display" : "Expectant parent pre-birth visit",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1488",
          "display" : "Non-productive cough",
          "target" : [
            {
              "code" : "MD12",
              "display" : "Cough",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1592",
          "display" : "Antenatal services",
          "target" : [
            {
              "code" : "QA45.Z",
              "display" : "Antenatal screening",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1622",
          "display" : "Antenatal care services",
          "target" : [
            {
              "code" : "QA45.Z",
              "display" : "Antenatal screening",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1623",
          "display" : "Postnatal care services",
          "target" : [
            {
              "code" : "QA48.Z",
              "display" : "Postpartum care or examination",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1721",
          "display" : "First trimester",
          "target" : [
            {
              "code" : "QA42.0",
              "display" : "Supervision of normal first pregnancy",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1724",
          "display" : "Time of first antenatal visit",
          "target" : [
            {
              "code" : "QA42.0",
              "display" : "Supervision of normal first pregnancy",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1853",
          "display" : "Growth monitoring in past 6 months",
          "target" : [
            {
              "code" : "QA42.0",
              "display" : "Supervision of normal first pregnancy",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5271",
          "display" : "Family planning",
          "target" : [
            {
              "code" : "QA21.1",
              "display" : "Contact with health services for general counselling or advice on contraception",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5275",
          "display" : "Intrauterine device",
          "target" : [
            {
              "code" : "QA21.60",
              "display" : "Retained intrauterine device without injury or harm in non-pregnant uterus",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5334",
          "display" : "Candidiasis, oral",
          "target" : [
            {
              "code" : "1F23.0",
              "display" : "Candidosis of lips or oral mucous membranes",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5483",
          "display" : "Family planning services",
          "target" : [
            {
              "code" : "QA21.1",
              "display" : " Contact with health services for general counselling or advice on contraception",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5957",
          "display" : "Productive cough",
          "target" : [
            {
              "code" : "MD12",
              "display" : "Cough",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "110736",
          "display" : "Cracked Tooth",
          "target" : [
            {
              "code" : "DA08.13",
              "display" : "Abfraction",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "111633",
          "display" : "Urinary tract infection",
          "target" : [
            {
              "code" : "GC08.Z",
              "display" : "Urinary tract infection",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "111636",
          "display" : "Urinary incontinence",
          "target" : [
            {
              "code" : "MF50.2Z",
              "display" : "Urinary incontinence",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "112348",
          "display" : "Tooth Disease",
          "target" : [
            {
              "code" : "DA0Z",
              "display" : "Diseases or disorders of orofacial complex",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "112934",
          "display" : "Skin Ulcer",
          "target" : [
            {
              "code" : "ME60.2",
              "display" : "Ulcer of skin",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "113224",
          "display" : "Rhinitis",
          "target" : [
            {
              "code" : "CA09.0",
              "display" : "Chronic rhinitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "114100",
          "display" : "Pneumonia",
          "target" : [
            {
              "code" : "CA40",
              "display" : "Pneumonia",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "114262",
          "display" : "Peptic ulcer",
          "target" : [
            {
              "code" : "DA61",
              "display" : "Peptic ulcer",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "114395",
          "display" : "Leg pain",
          "target" : [
            {
              "code" : "FB56.4",
              "display" : "Pain in limb",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "114702",
          "display" : "Osteoarthrosis",
          "target" : [
            {
              "code" : "FA01.Z",
              "display" : "Osteoarthritis of knee",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "114734",
          "display" : "Tooth Infection",
          "target" : [
            {
              "code" : "DA09.62",
              "display" : "Periapical abscess without sinus",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "115268",
          "display" : "Neuropathy",
          "target" : [
            {
              "code" : "8C0Z",
              "display" : "Polyneuropathy, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "115285",
          "display" : "Neuritis",
          "target" : [
            {
              "code" : "8C1Z",
              "display" : "Mononeuropathy",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "115915",
          "display" : "Mastitis, Associated with Childbirth",
          "target" : [
            {
              "code" : "JB45.1",
              "display" : "Nonpurulent mastitis associated with childbirth",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "116128",
          "display" : "Malaria",
          "target" : [
            {
              "code" : "1F4Z",
              "display" : "Malaria",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "116214",
          "display" : "Hypotension",
          "target" : [
            {
              "code" : "BA2Z",
              "display" : "Hypotension, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "117146",
          "display" : "Trichomoniasis",
          "target" : [
            {
              "code" : "1A92",
              "display" : "Trichomoniasis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "117243",
          "display" : "Incomplete spontaneous abortion",
          "target" : [
            {
              "code" : "JA00.03",
              "display" : "Spontaneous abortion, incomplete, with other or unspecified complications",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "117245",
          "display" : "Tooth Decalcification",
          "target" : [
            {
              "code" : "DA08.Y",
              "display" : "Other specified diseases of hard tissues of teeth",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "117399",
          "display" : "Hypertension",
          "target" : [
            {
              "code" : "BA00.Z",
              "display" : "Essential hypertension",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "117547",
          "display" : "Herpes labialis",
          "target" : [
            {
              "code" : "1F00.01",
              "display" : "Herpes simplex labialis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "117617",
          "display" : "Haemorrhage in early pregnancy",
          "target" : [
            {
              "code" : "JA40",
              "display" : "Haemorrhage in early pregnancy",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "117767",
          "display" : "Gonorrhea",
          "target" : [
            {
              "code" : "1A7Z",
              "display" : "Gonococcal infection",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "117889",
          "display" : "Gastroenteritis",
          "target" : [
            {
              "code" : "1A40.0",
              "display" : "Gastroenteritis or colitis without specification of origin",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "118794",
          "display" : "Dysmenorrhea",
          "target" : [
            {
              "code" : "GA34.3",
              "display" : "Dysmenorrhoea",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "119022",
          "display" : "Skin disorder",
          "target" : [
            {
              "code" : "ME67",
              "display" : "Skin disorder of uncertain or unspecified nature",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "119525",
          "display" : "Fungal skin infection",
          "target" : [
            {
              "code" : "EA60.Z",
              "display" : "Fungal infection of the skin",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "119558",
          "display" : "Dental caries",
          "target" : [
            {
              "code" : "DA08.0",
              "display" : "Dental caries",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "120749",
          "display" : "Chest pain",
          "target" : [
            {
              "code" : "MD30.Z",
              "display" : "Chest pain",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "121367",
          "display" : "Asthmatic Bronchitis",
          "target" : [
            {
              "code" : "CA23.32",
              "display" : "asthmatic bronchitis NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "121629",
          "display" : "Anaemia",
          "target" : [
            {
              "code" : "3A9Z",
              "display" : "Anaemias or other erythrocyte disorders, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "122110",
          "display" : "Pyelonephritis",
          "target" : [
            {
              "code" : "GB51",
              "display" : "Acute pyelonephritis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "122594",
          "display" : "Amebiasis",
          "target" : [
            {
              "code" : "1A36.Z",
              "display" : "Amoebiasis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "122713",
          "display" : "Acute Abdominal Complaint",
          "target" : [
            {
              "code" : "MD81.3",
              "display" : "Acute abdomen",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "122983",
          "display" : "Vomiting",
          "target" : [
            {
              "code" : "MD90.1",
              "display" : "Vomiting",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "123114",
          "display" : "Viral Gastroenteritis",
          "target" : [
            {
              "code" : "1A2Z",
              "display" : "Viral intestinal infections",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "123240",
          "display" : "Ventricular septal defect",
          "target" : [
            {
              "code" : "LA88.4Z",
              "display" : "Ventricular septal defect",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "123396",
          "display" : "Vaginal discharge",
          "target" : [
            {
              "code" : "MF3A",
              "display" : "Vaginal discharge",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "123468",
          "display" : "Urticaria",
          "target" : [
            {
              "code" : "EB05",
              "display" : "Urticaria of unspecified type",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "123491",
          "display" : "Urinary tract infection in pregnancy",
          "target" : [
            {
              "code" : "JA62.3",
              "display" : "Infections of other parts of urinary tract in pregnancy",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "123565",
          "display" : "Upper respiratory infection",
          "target" : [
            {
              "code" : "CA07.0",
              "display" : "Acute upper respiratory infection, site unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "124601",
          "display" : "Toothache",
          "target" : [
            {
              "code" : "DA0A.Y",
              "display" : "Other specified disorders of teeth and supporting structures",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "124647",
          "display" : "Tinea Cruris",
          "target" : [
            {
              "code" : "1F28.3",
              "display" : "Tinea cruris",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "124654",
          "display" : "Tinea capitis",
          "target" : [
            {
              "code" : "1F28.0",
              "display" : "Tinea capitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "124774",
          "display" : "Haemorrhoids Thrombosed",
          "target" : [
            {
              "code" : "DB61",
              "display" : "thrombosed external haemorrhoid",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "124997",
          "display" : "Abdominal Tenderness, Epigastric",
          "target" : [
            {
              "code" : "MD81.0",
              "display" : "Abdominal tenderness",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "125205",
          "display" : "Swelling of Limb",
          "target" : [
            {
              "code" : "FB56.6",
              "display" : "Other specified soft tissue disorders",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "125860",
          "display" : "Stomatitis",
          "target" : [
            {
              "code" : "DA01",
              "display" : "stomatitis NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "126297",
          "display" : "Soft Tissue Swelling",
          "target" : [
            {
              "code" : "FB3Z",
              "display" : "Disorders of muscles, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "126319",
          "display" : "Sneezing",
          "target" : [
            {
              "code" : "MD11.A",
              "display" : "Sneezing",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "126401",
          "display" : "Skin Irritation",
          "target" : [
            {
              "code" : "EK5Y",
              "display" : "Other specified skin disorders provoked by external factors",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "126423",
          "display" : "Sinusitis",
          "target" : [
            {
              "code" : "SK99",
              "display" : "Sinusitis disorder (TM2)",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "126702",
          "display" : "Septicaemia",
          "target" : [
            {
              "code" : "SK99",
              "display" : "Sinusitis disorder (TM2)",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "127417",
          "display" : "Rheumatoid arthritis",
          "target" : [
            {
              "code" : "FA20.Z",
              "display" : "Rheumatoid arthritis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "128047",
          "display" : "Pustule",
          "target" : [
            {
              "code" : "ME66.Y",
              "display" : "Other specified skin changes",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "128096",
          "display" : "Pulpitis",
          "target" : [
            {
              "code" : "DA09.0",
              "display" : "Pulpitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "130093",
          "display" : "Plantar Fasciitis",
          "target" : [
            {
              "code" : "FB40.1",
              "display" : "Plantar fasciitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "130305",
          "display" : "Pharyngitis",
          "target" : [
            {
              "code" : "CA02.Z",
              "display" : "pharyngitis NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "131568",
          "display" : "Other and unspecified conjunctivitis",
          "target" : [
            {
              "code" : "9A60.Y",
              "display" : "Other specified conjunctivitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "131694",
          "display" : "Oropharyngeal dysphagia",
          "target" : [
            {
              "code" : "MD93",
              "display" : "Dysphagia",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "132387",
          "display" : "Onychomycosis",
          "target" : [
            {
              "code" : "EE12.1",
              "display" : "Onychomycosis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "133469",
          "display" : "Neck pain",
          "target" : [
            {
              "code" : "ME84.0",
              "display" : "neck pain",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "134151",
          "display" : "Mild Hyperemesis Gravidarum",
          "target" : [
            {
              "code" : "JA60.0",
              "display" : "Mild hyperemesis gravidarum",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "134345",
          "display" : "Hypermenorrhoea",
          "target" : [
            {
              "code" : "GA20.50",
              "display" : "Heavy menstrual bleeding",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "134615",
          "display" : "Mastitis",
          "target" : [
            {
              "code" : "GB21",
              "display" : "Inflammatory disorders of breast",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "135488",
          "display" : "Lymphadenopathy",
          "target" : [
            {
              "code" : "MA01",
              "display" : "Lymphadenopathy",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "135556",
          "display" : "Lower Respiratory Tract Infection",
          "target" : [
            {
              "code" : "CA4Y",
              "display" : "Acute lower respiratory tract infection NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "136245",
          "display" : "Knee pain",
          "target" : [
            {
              "code" : "FB56.4",
              "display" : "Pain in limb, knee joint",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "136248",
          "display" : "Knee Joint - Tender",
          "target" : [
            {
              "code" : "FA2Z",
              "display" : "Inflammatory arthropathies, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "137352",
          "display" : "Infection by Taenia",
          "target" : [
            {
              "code" : "1F76.0",
              "display" : "Taeniasis due to Taenia solium",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "138130",
          "display" : "Hypertrophy of Nasal Turbinates",
          "target" : [
            {
              "code" : "CA0E",
              "display" : "Hypertrophy of nasal turbinates",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "138291",
          "display" : "Hyperglycaemia",
          "target" : [
            {
              "code" : "MA18.0Z",
              "display" : "Elevated blood glucose level",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "138377",
          "display" : "Hydrocele of Testis",
          "target" : [
            {
              "code" : "GB00.Y",
              "display" : "Other specified hydrocele or spermatocele",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "138571",
          "display" : "HIV positive",
          "target" : [
            {
              "code" : "1C62",
              "display" : "HIV positive NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "139054",
          "display" : "Heat Pyrexia",
          "target" : [
            {
              "code" : "NF01.0",
              "display" : "heat pyrexia",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "139083",
          "display" : "Headache Disorder",
          "target" : [
            {
              "code" : "8A8Z",
              "display" : "Headache disorders",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "139084",
          "display" : "Headache",
          "target" : [
            {
              "code" : "MB4D",
              "display" : "Headache",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "139984",
          "display" : "Foot Pain",
          "target" : [
            {
              "code" : "FB56.4",
              "display" : "pain in foot NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "140237",
          "display" : "Fever with chills",
          "target" : [
            {
              "code" : "MG26",
              "display" : "Fever of other or unknown origin",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "140238",
          "display" : "Fever",
          "target" : [
            {
              "code" : "1C33",
              "display" : "Q fever",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "140987",
          "display" : "Essential hypertension",
          "target" : [
            {
              "code" : "BA00",
              "display" : "Essential hypertension",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "141005",
          "display" : "Esophageal Bleeding",
          "target" : [
            {
              "code" : "ME24.A2",
              "display" : "Oesophageal haemorrhage",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "141128",
          "display" : "Epigastric pain",
          "target" : [
            {
              "code" : "MD81.10",
              "display" : "Pain localised to upper abdomen",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "141585",
          "display" : "Ear Problem",
          "target" : [
            {
              "code" : "AB70.2",
              "display" : "earache symptom",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "141586",
          "display" : "Ear Discharge Present",
          "target" : [
            {
              "code" : "AB70.0",
              "display" : "ear discharge present",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "142412",
          "display" : "Diarrhea",
          "target" : [
            {
              "code" : "ME05.1",
              "display" : "Diarrhoea",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "142583",
          "display" : "Dental Plaque",
          "target" : [
            {
              "code" : "DA08.4",
              "display" : "Deposits on teeth",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "143193",
          "display" : "Croup",
          "target" : [
            {
              "code" : "CA06.0",
              "display" : "croup",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "143264",
          "display" : "Cough",
          "target" : [
            {
              "code" : "MD12",
              "display" : "Cough",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "145136",
          "display" : "Chronic Urticaria",
          "target" : [
            {
              "code" : "EB00.1",
              "display" : "Chronic urticaria",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "145198",
          "display" : "Chronic Pulpitis",
          "target" : [
            {
              "code" : "DA09.0",
              "display" : "Chronic pulpitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "145995",
          "display" : "Cellulitis of Nasopharynx",
          "target" : [
            {
              "code" : "CA0K.0",
              "display" : "Cellulitis of nasopharynx",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "146520",
          "display" : "Candidal Vulvovaginitis",
          "target" : [
            {
              "code" : "1F23.10",
              "display" : "Vulvovaginal candidosis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "146871",
          "display" : "Acute bronchospasm",
          "target" : [
            {
              "code" : "CA41.Y",
              "display" : "Other specified acute bronchiolitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "146928",
          "display" : "Breast Tenderness",
          "target" : [
            {
              "code" : "GB22",
              "display" : "Hypertrophy of breast",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "146939",
          "display" : "Breast Engorgement in Pregnancy, the Puerperium or Lactation - Delivered",
          "target" : [
            {
              "code" : "KC41.0",
              "display" : "Breast engorgement of newborn",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "147083",
          "display" : "Boil of Trunk NOS",
          "target" : [
            {
              "code" : "1B75.0",
              "display" : "Furuncle",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "147091",
          "display" : "Boil of Buttock NOS",
          "target" : [
            {
              "code" : "1B75.0",
              "display" : "Furuncle",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "147228",
          "display" : "Bleeding Internal Hemorrhoids",
          "target" : [
            {
              "code" : "DB60.Z",
              "display" : "Haemorrhoids",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "147241",
          "display" : "Bleeding",
          "target" : [
            {
              "code" : "MG27",
              "display" : "bleeding",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "148029",
          "display" : "Bacteraemia",
          "target" : [
            {
              "code" : "MA15.0",
              "display" : "Bacteraemia",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "148035",
          "display" : "Back pain",
          "target" : [
            {
              "code" : "ME84.Z",
              "display" : "back pain NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "148432",
          "display" : "Arthritis",
          "target" : [
            {
              "code" : "FA20",
              "display" : "Rheumatoid arthritis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "148888",
          "display" : "Anaphylaxis",
          "target" : [
            {
              "code" : "4A84",
              "display" : "Anaphylaxis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "149004",
          "display" : "Amebic dysentery",
          "target" : [
            {
              "code" : "1A36.00",
              "display" : "Acute amoebiasis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "149478",
          "display" : "Acute Upper Respiratory Infection",
          "target" : [
            {
              "code" : "CA07.0",
              "display" : "Acute upper respiratory infection, site unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "149554",
          "display" : "Acute pyelonephritis",
          "target" : [
            {
              "code" : "GB51",
              "display" : "Acute pyelonephritis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "149561",
          "display" : "Acute Pulpitis",
          "target" : [
            {
              "code" : "DA09.0",
              "display" : "Pulpitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "149609",
          "display" : "Acute Otitis Media",
          "target" : [
            {
              "code" : "AB00",
              "display" : "Acute otitis media",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "149779",
          "display" : "Acute Gastroenteritis",
          "target" : [
            {
              "code" : "1A40",
              "display" : "Gastroenteritis or colitis without specification of infectious agent",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "149856",
          "display" : "Acute Diarrhea",
          "target" : [
            {
              "code" : "ME05.1",
              "display" : "Diarrhoea",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "149866",
          "display" : "Acute Conjunctivitis",
          "target" : [
            {
              "code" : "9A60.Z",
              "display" : "acute conjunctivitis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "150589",
          "display" : "Abscess of Lip",
          "target" : [
            {
              "code" : "1B75.3",
              "display" : "abscess NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "150598",
          "display" : "Abscess of Hand",
          "target" : [
            {
              "code" : "1B75.3",
              "display" : "abscess NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "150599",
          "display" : "Abscess of Groin",
          "target" : [
            {
              "code" : "FB40.0",
              "display" : "abscess of tendon",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "150632",
          "display" : "Abscess",
          "target" : [
            {
              "code" : "1B75.3",
              "display" : "Pyogenic abscess of the skin",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "150634",
          "display" : "Abrasion of Finger",
          "target" : [
            {
              "code" : "NC51.00",
              "display" : "Abrasion of finger or thumb",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "150916",
          "display" : "Abdominal Discomfort",
          "target" : [
            {
              "code" : "ME1Y",
              "display" : "abdominal discomfort",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "152162",
          "display" : "Examination of blood pressure",
          "target" : [
            {
              "code" : "QA09.Y",
              "display" : "Other specified special screening examination for neoplasms",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "153869",
          "display" : "fever of newborn",
          "target" : [
            {
              "code" : "KD11",
              "display" : "Fever of newborn",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "154604",
          "display" : "accidental cut",
          "target" : [
            {
              "code" : "PL11.0",
              "display" : "Cut, puncture or tear, as mode of injury or harm",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "154909",
          "display" : "aching headache",
          "target" : [
            {
              "code" : "MG31.1",
              "display" : "Acute headache, not elsewhere classified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "154959",
          "display" : "acute low back pain",
          "target" : [
            {
              "code" : "ME84.2Z",
              "display" : "Low back pain",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "155029",
          "display" : "allergic cough",
          "target" : [
            {
              "code" : "1C12.Y",
              "display" : "Other specified whooping cough",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "155436",
          "display" : "Caries of dentine",
          "target" : [
            {
              "code" : "DA08.0",
              "display" : "Caries of dentine",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "155554",
          "display" : "chronic back pain",
          "target" : [
            {
              "code" : "ME86.2Z",
              "display" : "Chronic back pain, not otherwise specified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "156471",
          "display" : "generalized pruritus",
          "target" : [
            {
              "code" : "EC90.Z",
              "display" : "Pruritus, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "156648",
          "display" : "history of menorrhagia",
          "target" : [
            {
              "code" : "SB90",
              "display" : "Menorrhagia disorder (TM1)",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "157544",
          "display" : "Lower abdominal pain",
          "target" : [
            {
              "code" : "MD81.12",
              "display" : "lower abdominal pain",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "157830",
          "display" : "Multiple bruises",
          "target" : [
            {
              "code" : "ND30",
              "display" : "Multiple bruises",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "157872",
          "display" : "muscle spasms of head or neck",
          "target" : [
            {
              "code" : "MB47.3",
              "display" : "Cramp or spasm",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "158602",
          "display" : "putrescent pulpitis",
          "target" : [
            {
              "code" : "DA09.1",
              "display" : "Necrosis of pulp",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "159094",
          "display" : "tongue thrust",
          "target" : [
            {
              "code" : "DA0E.7",
              "display" : "Dentofacial parafunctional disorders",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "159328",
          "display" : "Wound",
          "target" : [
            {
              "code" : "ND56.1",
              "display" : "Open wound of unspecified body region",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "159618",
          "display" : "Obstetric ultrasound",
          "target" : [
            {
              "code" : "QA45.Y",
              "display" : "Other specified antenatal screening",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "159922",
          "display" : "Deworming",
          "target" : [
            {
              "code" : "1F90.Z",
              "display" : "Infestation by parasitic worms, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "159937",
          "display" : "Maternal and child health program",
          "target" : [
            {
              "code" : "JA86.Y",
              "display" : "Maternal care for other specified fetal problems",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "159950",
          "display" : "Uncomplicated malaria",
          "target" : [
            {
              "code" : "1F45",
              "display" : "Malaria without parasitological confirmation",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "160148",
          "display" : "Malaria, confirmed",
          "target" : [
            {
              "code" : "1F44",
              "display" : "Malaria confirmed",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "160208",
          "display" : "Urinary symptoms",
          "target" : [
            {
              "code" : "MF59",
              "display" : "Urinary symptom or complaint",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "160446",
          "display" : "Antenatal Visit",
          "target" : [
            {
              "code" : "QA45.Z",
              "display" : "Antenatal screening",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "160544",
          "display" : "Under five clinic",
          "target" : [
            {
              "code" : "QA00.1",
              "display" : "Routine child health examination",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "161252",
          "display" : "Dental",
          "target" : [
            {
              "code" : "DA09.62",
              "display" : "Periapical abscess without sinus",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "161644",
          "display" : "Hypertensive crisis",
          "target" : [
            {
              "code" : "BA03",
              "display" : "Hypertensive crisis",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "161655",
          "display" : "Antenatal case number",
          "target" : [
            {
              "code" : "QA45.0",
              "display" : "Antenatal screening for chromosomal anomalies",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "161903",
          "display" : "Dental caries, class I",
          "target" : [
            {
              "code" : "DA08.0",
              "display" : "Primary dental caries",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "162049",
          "display" : "Child Services Program",
          "target" : [
            {
              "code" : "QA00.1",
              "display" : "Routine child health examination",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "162129",
          "display" : "Wound intact and healing",
          "target" : [
            {
              "code" : "NF2Y",
              "display" : "Other specified injury, poisoning or certain other consequences of external causes",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "163110",
          "display" : "Maternal and Child Welfare Center (MCWC)",
          "target" : [
            {
              "code" : "JA65.Y",
              "display" : "Maternal care for other specified conditions predominantly related to pregnancy",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "163395",
          "display" : "Deworming/Anti-parasitic drugs",
          "target" : [
            {
              "code" : "MG55.Z",
              "display" : "Finding of parasite resistant to antimicrobial drugs, unspecified",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "163465",
          "display" : "Diarrhea for less than two weeks",
          "target" : [
            {
              "code" : "DD91.2",
              "display" : "Functional diarrhoea",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "163499",
          "display" : "First neonatal visit",
          "target" : [
            {
              "code" : "KA21.4Z",
              "display" : "Prematurity NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "163725",
          "display" : "Test status",
          "target" : [
            {
              "code" : "QA87",
              "display" : "Problem with clinical documentation without injury or harm",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "163894",
          "display" : "Swelling",
          "target" : [
            {
              "code" : "9C40.AY",
              "display" : "Other specified optic disc swelling",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "166083",
          "display" : "Antenatal",
          "target" : [
            {
              "code" : "QA45.Y",
              "display" : "Other specified antenatal screening",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "166328",
          "display" : "Mouth",
          "target" : [
            {
              "code" : "LA31.Y",
              "display" : "Other specified structural developmental anomalies of mouth or tongue",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "166340",
          "display" : "Lower back",
          "target" : [
            {
              "code" : "ME84.2Z",
              "display" : "lower back pain",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "166836",
          "display" : "Surgical extraction of tooth",
          "target" : [
            {
              "code" : "NA0D.15",
              "display" : "Avulsion of tooth",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "167079",
          "display" : "Follow-up need status",
          "target" : [
            {
              "code" : "QB9Z",
              "display" : "aftercare NOS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "167090",
          "display" : "Normal weight",
          "target" : [
            {
              "code" : "XS43",
              "display" : " Normal weight BMI 18.5–24.9 kg/m²",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "168737",
          "display" : "Diarrhea without dehydration",
          "target" : [
            {
              "code" : "ME05.1",
              "display" : "watery diarrhoea",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "168250",
          "display" : "Ability to lie down",
          "target" : [
            {
              "code" : "6C20.Z",
              "display" : "Bodily distress disorder",
              "relationship" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
