# SGHI Specialty Code System - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Specialty Code System**

## CodeSystem: SGHI Specialty Code System 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/specialtycodesystem | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:SGHISpecialtyCodeSystem |

 
A Specialty Code System to be used in SGHI's environment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SGHISpecialtyVs](ValueSet-speciality.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "specialtycodesystem",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/specialtycodesystem",
  "version" : "0.1.0",
  "name" : "SGHISpecialtyCodeSystem",
  "title" : "SGHI Specialty Code System",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A Specialty Code System to be used in  SGHI's environment.",
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "general-practitioner",
      "display" : "General Practitioner",
      "definition" : "A Specialties for primary healthcare and general medical services"
    },
    {
      "code" : "pediatrician",
      "display" : "Pediatrician",
      "definition" : "Specialized for child healthcare, vaccination programs, and neonatal care."
    },
    {
      "code" : "obstetrician",
      "display" : "Obstetrician",
      "definition" : "Specializes in maternal health, pregnancy care, and childbirth services."
    },
    {
      "code" : "surgeon",
      "display" : "Surgeon",
      "definition" : "Specializes in general surgical procedures for trauma, emergencies, and routine operations."
    },
    {
      "code" : "anaesthesiologist",
      "display" : "Anesthesiologist",
      "definition" : "Necessary for surgical support and pain management."
    },
    {
      "code" : "radiologist",
      "display" : "Radiologist",
      "definition" : "Specializes in diagnostic imaging such as X-rays and ultrasounds."
    },
    {
      "code" : "dentist",
      "display" : "Dentist",
      "definition" : "Specialist in dental health."
    }
  ]
}

```
