# SGHI Identifier Code System - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Identifier Code System**

## CodeSystem: SGHI Identifier Code System 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:SGHIIdentifierCodeSystem |

 
A single code system enumerating the many local identifier types used across SGHI's environment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem Supplement is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "identifier-codesystem",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem",
  "version" : "0.1.0",
  "name" : "SGHIIdentifierCodeSystem",
  "title" : "SGHI Identifier Code System",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A single code system enumerating the many local identifier types used across SGHI's environment.",
  "content" : "supplement",
  "concept" : [
    {
      "code" : "vtmid",
      "display" : "VTM ID",
      "definition" : "dm+d identifier for a Virtual Therapeutic Moiety (VTM) concept."
    },
    {
      "code" : "vtmidprev",
      "display" : "Previous VTM ID",
      "definition" : "Deprecated VTM identifier retained for traceability."
    },
    {
      "code" : "isid",
      "display" : "IS ID",
      "definition" : "dm+d identifier for an Ingredient Substance (IS) concept."
    },
    {
      "code" : "isidprev",
      "display" : "Previous IS ID",
      "definition" : "Deprecated IS identifier retained for traceability."
    },
    {
      "code" : "vpid",
      "display" : "VP ID",
      "definition" : "dm+d identifier for a Virtual Product (VP) concept."
    },
    {
      "code" : "vpidprev",
      "display" : "Previous VP ID",
      "definition" : "Deprecated VP identifier retained for traceability."
    },
    {
      "code" : "vppid",
      "display" : "VPP ID",
      "definition" : "dm+d identifier for a Virtual Product Pack (VPP)."
    },
    {
      "code" : "apid",
      "display" : "AP ID",
      "definition" : "dm+d identifier for an Actual Medicinal Product (AMP)."
    },
    {
      "code" : "appid",
      "display" : "APP ID",
      "definition" : "dm+d identifier for an Actual Product Pack (APP)."
    },
    {
      "code" : "dbid",
      "display" : "DB ID",
      "definition" : "dm+d identifier referencing the primary key stored in our database."
    },
    {
      "code" : "slade-concept-code",
      "display" : "Slade Concept Code",
      "definition" : "A unique drug identifier assigned by slade 360."
    },
    {
      "code" : "stat",
      "display" : "STAT",
      "definition" : "A unique identifier assigned for highest priority cases (e.g., emergency)"
    },
    {
      "code" : "asap",
      "display" : "ASAP",
      "definition" : "As soon as possible, next highest priority after STAT"
    },
    {
      "code" : "routine",
      "display" : "Routine",
      "definition" : "Routine service, do at usual work hours"
    },
    {
      "code" : "preop",
      "display" : "PREOP",
      "definition" : "Used to indicate that a service is to be performed prior to a scheduled surgery"
    },
    {
      "code" : "elective",
      "display" : "Elective",
      "definition" : "Low priority. Beneficial to the patient but not essential for survival"
    },
    {
      "code" : "inpatient",
      "display" : "In Patient",
      "definition" : "A patient encounter where a patient is admitted by a hospital or equivalent facility, assigned to a location where patients generally stay at least overnight and provided with room, board, and continuous nursing service."
    },
    {
      "code" : "outpatient",
      "display" : "Ambulatory (Out Patient)",
      "definition" : "A comprehensive term for health care provided in a healthcare facility on a nonresident basis."
    },
    {
      "code" : "emergency",
      "display" : "Emergency",
      "definition" : "A patient encounter that takes place at a dedicated healthcare service delivery location where the patient receives immediate evaluation and treatment."
    },
    {
      "code" : "closed",
      "display" : "Closed",
      "definition" : "Closed"
    },
    {
      "code" : "housekeeping",
      "display" : "Housekeeping",
      "definition" : "Housekeeping"
    },
    {
      "code" : "occupied",
      "display" : "Occupied",
      "definition" : "Occupied"
    },
    {
      "code" : "unoccupied",
      "display" : "Unoccupied",
      "definition" : "Unoccupied"
    },
    {
      "code" : "contaminated",
      "display" : "Contaminated",
      "definition" : "Contaminated"
    },
    {
      "code" : "isolated",
      "display" : "Isolated",
      "definition" : "Isolated"
    },
    {
      "code" : "instance",
      "display" : "Instance",
      "definition" : "The Location resource represents a specific instance of a location (e.g., Operating Theatre 1A)."
    },
    {
      "code" : "kind",
      "display" : "Kind",
      "definition" : "The Location represents a class of locations (e.g., Any Operating Theatre)."
    },
    {
      "code" : "work",
      "display" : "Work",
      "definition" : "An office contact point. First choice for business-related contacts during business hours."
    },
    {
      "code" : "mobile",
      "display" : "Mobile",
      "definition" : "A telecommunication device that moves and stays with its owner."
    },
    {
      "code" : "phone",
      "display" : "Phone",
      "definition" : "The value is a telephone number used for voice calls."
    },
    {
      "code" : "email",
      "display" : "Email",
      "definition" : "The value is an email address."
    },
    {
      "code" : "building",
      "display" : "Building",
      "definition" : "Any Building or structure. This may contain rooms, corridors, wings, etc."
    },
    {
      "code" : "wing",
      "display" : "Wing",
      "definition" : "A Wing within a Building, often contains levels, rooms, and corridors."
    },
    {
      "code" : "ward",
      "display" : "Ward",
      "definition" : "A section of a medical facility that may contain rooms and other types of location."
    },
    {
      "code" : "room",
      "display" : "Room",
      "definition" : "A space that is allocated as a room."
    },
    {
      "code" : "bed",
      "display" : "Bed",
      "definition" : "A space that is allocated for sleeping or laying on."
    },
    {
      "code" : "vehicle",
      "display" : "Vehicle",
      "definition" : "A means of transportation, e.g., mobile clinics."
    },
    {
      "code" : "house",
      "display" : "House",
      "definition" : "A residential dwelling where a person/patient may reside."
    },
    {
      "code" : "area",
      "display" : "Area",
      "definition" : "A defined physical boundary of something, such as a flood risk zone or region."
    },
    {
      "code" : "virtual",
      "display" : "Virtual",
      "definition" : "A location that is virtual in nature, such as a conference call or virtual meeting space."
    },
    {
      "code" : "26436-6",
      "display" : "Laboratory studies (set)",
      "definition" : "Laboratory studies (set)"
    },
    {
      "code" : "18748-4",
      "display" : "Diagnostic imaging study",
      "definition" : "Diagnostic imaging study"
    },
    {
      "code" : "21938-6",
      "display" : "Surgical approach",
      "definition" : "Surgical approach"
    },
    {
      "code" : "24642003",
      "display" : "Psychiatry procedure or service",
      "definition" : "Psychiatry procedure or service"
    },
    {
      "code" : "409063005",
      "display" : "Counseling",
      "definition" : "Counseling"
    },
    {
      "code" : "409073007",
      "display" : "Education",
      "definition" : "Education"
    },
    {
      "code" : "387713003",
      "display" : "Surgical procedure (procedure)",
      "definition" : "Surgical procedure (procedure)"
    },
    {
      "code" : "103693007",
      "display" : "Diagnostic procedure",
      "definition" : "Diagnostic procedure"
    },
    {
      "code" : "46947000",
      "display" : "Chiropractic manipulation",
      "definition" : "Chiropractic manipulation"
    },
    {
      "code" : "410606002",
      "display" : "Social service procedure (procedure)",
      "definition" : "Social service procedure (procedure)"
    },
    {
      "code" : "385669000",
      "display" : "Successful",
      "definition" : "Successful"
    },
    {
      "code" : "385671000",
      "display" : "Unsuccessful",
      "definition" : "Unsuccessful"
    },
    {
      "code" : "385670004",
      "display" : "Partially successful",
      "definition" : "Partially successful"
    },
    {
      "code" : "18949003",
      "display" : "Change of dressing",
      "definition" : "The process of replacing or altering a wound dressing."
    },
    {
      "code" : "30549001",
      "display" : "Removal of suture",
      "definition" : "The process of removing sutures (stitches) from a wound."
    },
    {
      "code" : "241031001",
      "display" : "Removal of drain",
      "definition" : "The process of removing a drainage device from a body cavity or wound."
    },
    {
      "code" : "35963001",
      "display" : "Removal of staples",
      "definition" : "The process of removing surgical staples from a wound."
    },
    {
      "code" : "225164002",
      "display" : "Removal of ligature",
      "definition" : "The process of removing a ligature (tie) used to bind tissue or vessels."
    },
    {
      "code" : "447346005",
      "display" : "Cardiopulmonary exercise test (procedure)",
      "definition" : "A test to assess the performance of the heart and lungs during physical exertion."
    },
    {
      "code" : "229506003",
      "display" : "Scar tissue massage",
      "definition" : "Therapeutic massage applied to scar tissue to improve mobility and reduce discomfort."
    },
    {
      "code" : "274441001",
      "display" : "Suction drainage",
      "definition" : "The process of removing fluid or debris from a body cavity using suction."
    },
    {
      "code" : "394725008",
      "display" : "Diabetes medication review (procedure)",
      "definition" : "A review of medications prescribed for diabetes management."
    },
    {
      "code" : "359825008",
      "display" : "Cytopathology, review of bronchioalveolar lavage specimen",
      "definition" : "The examination of cells obtained from a bronchioalveolar lavage specimen for diagnostic purposes."
    },
    {
      "code" : "doctor",
      "display" : "Doctor",
      "definition" : "A qualified/registered medical practitioner."
    },
    {
      "code" : "nurse",
      "display" : "Nurse",
      "definition" : "A practitioner with nursing experience that may be qualified/registered."
    },
    {
      "code" : "pharmacist",
      "display" : "Pharmacist",
      "definition" : "A qualified/registered/licensed pharmacist."
    },
    {
      "code" : "researcher",
      "display" : "Researcher",
      "definition" : "A practitioner that may perform research."
    },
    {
      "code" : "408467006",
      "display" : "Adult mental illness",
      "definition" : "Specialty focused on the diagnosis and treatment of mental illnesses in adults."
    },
    {
      "code" : "394577000",
      "display" : "Anesthetics",
      "definition" : "Specialty focused on administering anesthesia and managing pain during surgical procedures."
    },
    {
      "code" : "394578005",
      "display" : "Audiological medicine",
      "definition" : "Specialty focused on the diagnosis and treatment of hearing and balance disorders."
    },
    {
      "code" : "421661004",
      "display" : "Blood banking and transfusion medicine",
      "definition" : "Specialty focused on the collection, storage, and transfusion of blood and blood products."
    },
    {
      "code" : "408462000",
      "display" : "Burns care",
      "definition" : "Specialty focused on the treatment and management of burn injuries."
    },
    {
      "code" : "111002",
      "display" : "Parathyroid gland",
      "definition" : "Parathyroid gland"
    },
    {
      "code" : "apply",
      "display" : "Apply",
      "definition" : "Apply"
    },
    {
      "code" : "inject",
      "display" : "Inject",
      "definition" : "Inject"
    },
    {
      "code" : "dialysis",
      "display" : "Dialysis",
      "definition" : "Dialysis"
    },
    {
      "code" : "insert",
      "display" : "Insert",
      "definition" : "Insert"
    },
    {
      "code" : "implant",
      "display" : "Implant",
      "definition" : "Implant"
    },
    {
      "code" : "infuse",
      "display" : "Infuse",
      "definition" : "Infuse"
    },
    {
      "code" : "chemo",
      "display" : "Chemotherapy"
    },
    {
      "code" : "surg",
      "display" : "Surgery"
    },
    {
      "code" : "radio",
      "display" : "Radiotherapy"
    },
    {
      "code" : "iv",
      "display" : "Intravenous",
      "definition" : "Intravenous"
    },
    {
      "code" : "im",
      "display" : "Intramuscular",
      "definition" : "Intramuscular"
    },
    {
      "code" : "it",
      "display" : "Intrathecal",
      "definition" : "Intrathecal"
    },
    {
      "code" : "ro",
      "display" : "Oral",
      "definition" : "Oral"
    },
    {
      "code" : "braf",
      "display" : "BRAF Mutation"
    },
    {
      "code" : "kras",
      "display" : "KRAS Mutation"
    },
    {
      "code" : "nras",
      "display" : "NRAS Mutation"
    },
    {
      "code" : "egfr",
      "display" : "EGFR Mutation"
    },
    {
      "code" : "alk",
      "display" : "ALK Rearrangement"
    },
    {
      "code" : "her2",
      "display" : "HER2 Amplification"
    },
    {
      "code" : "pik3ca",
      "display" : "PIK3CA Mutation"
    },
    {
      "code" : "pt53",
      "display" : "TP53 Mutation"
    },
    {
      "code" : "msi",
      "display" : "Microsatellite Instability"
    },
    {
      "code" : "pdli",
      "display" : "PD-L1 Expression"
    },
    {
      "code" : "other",
      "display" : "Other"
    },
    {
      "code" : "bone",
      "display" : "Bone"
    },
    {
      "code" : "liver",
      "display" : "Liver"
    },
    {
      "code" : "lung",
      "display" : "Lung"
    },
    {
      "code" : "brain",
      "display" : "Brain"
    },
    {
      "code" : "skin",
      "display" : "Skin"
    },
    {
      "code" : "dln",
      "display" : "Distant Lymph Nodes"
    },
    {
      "code" : "gradeI",
      "display" : "Well Differentiated"
    },
    {
      "code" : "gradeII",
      "display" : "Moderately Differentiated"
    },
    {
      "code" : "gradeIII",
      "display" : "Poorly Differentiated"
    },
    {
      "code" : "gradeIV",
      "display" : "Undifferentiated/ Anaplastic"
    },
    {
      "code" : "none",
      "display" : "Not Graded"
    },
    {
      "code" : "benign",
      "display" : "Benign"
    },
    {
      "code" : "malignant",
      "display" : "Malignant"
    },
    {
      "code" : "insitu",
      "display" : "In Situ"
    },
    {
      "code" : "borderline",
      "display" : "Borderline"
    },
    {
      "code" : "uncertain",
      "display" : "Uncertain"
    },
    {
      "code" : "positive",
      "display" : "Positive"
    },
    {
      "code" : "negative",
      "display" : "Negative"
    },
    {
      "code" : "equivocal",
      "display" : "Equivocal"
    },
    {
      "code" : "nottested",
      "display" : "Not Tested"
    },
    {
      "code" : "cnb",
      "display" : "Core Needle Biopsy"
    },
    {
      "code" : "excision",
      "display" : "Excision"
    },
    {
      "code" : "fna",
      "display" : "Fine Needle Aspiration"
    },
    {
      "code" : "ib",
      "display" : "Incisional Biopsy"
    },
    {
      "code" : "pb",
      "display" : "Punch Biopsy"
    },
    {
      "code" : "sb",
      "display" : "Shave Biopsy"
    },
    {
      "code" : "eb",
      "display" : "Endoscopic Biopsy"
    },
    {
      "code" : "ras",
      "display" : "Resection Autopsy Specimen"
    },
    {
      "code" : "hematology",
      "display" : "Hematology"
    },
    {
      "code" : "cytology",
      "display" : "Cytology"
    },
    {
      "code" : "histopathology",
      "display" : "Histopathology"
    },
    {
      "code" : "ich",
      "display" : "Immunohistochemistry"
    },
    {
      "code" : "fc",
      "display" : "Flow Cytometry"
    },
    {
      "code" : "molecular",
      "display" : "Molecular"
    },
    {
      "code" : "right",
      "display" : "Right"
    },
    {
      "code" : "left",
      "display" : "Left"
    },
    {
      "code" : "bilateral",
      "display" : "Bilateral"
    },
    {
      "code" : "unknown",
      "display" : "Unknown"
    },
    {
      "code" : "stage1",
      "display" : "Stage 1"
    },
    {
      "code" : "stage2",
      "display" : "Stage 2"
    },
    {
      "code" : "stage3",
      "display" : "Stage 3"
    },
    {
      "code" : "stage4",
      "display" : "Stage 4"
    },
    {
      "code" : "sghidefaultcode",
      "display" : "SGHI Default Code"
    },
    {
      "code" : "powder",
      "display" : "Powder"
    },
    {
      "code" : "tablets",
      "display" : "Tablets"
    },
    {
      "code" : "capsule",
      "display" : "Capsule"
    },
    {
      "code" : "solution",
      "display" : "Solution"
    },
    {
      "code" : "lozenge",
      "display" : "Lozenge"
    },
    {
      "code" : "suspension",
      "display" : "Suspension"
    },
    {
      "code" : "syrup",
      "display" : "Syrup"
    }
  ]
}

```
