# Example CarePlan - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example CarePlan**

## Example CarePlan: Example CarePlan

Profile: [SGHI Care Plan](StructureDefinition-careplan.md)

**identifier**: ID/QwErTy102938 (use: official, )

**instantiatesCanonical**: `http://slade360.hl7.org/fhir/v2-0203`

**status**: Active

**intent**: Plan

**title**: Example CarePlan

**description**: Example CarePlan

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**created**: 2025-06-03 14:30:00+0000

**custodian**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

> **activity**

### PerformedActivities

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Task: identifier = Placer Identifier: TASK123456 (use: official, ); status = in-progress; businessStatus = In Progress; intent = order; priority = routine; authoredOn = 2023-11-20 09:00:00+0000; lastModified = 2023-11-20 09:30:00+0000](Task-ExampleSGHITask.md) |


**note**: By Organization/ExampleSGHIOrganization

> 

Example Note




## Resource Content

```json
{
  "resourceType" : "CarePlan",
  "id" : "ExampleSGHICarePlan",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/careplan"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ID",
            "display" : "ID"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "QwErTy102938",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "instantiatesCanonical" : ["http://slade360.hl7.org/fhir/v2-0203"],
  "status" : "active",
  "intent" : "plan",
  "title" : "Example CarePlan",
  "description" : "Example CarePlan",
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "created" : "2025-06-03T14:30:00Z",
  "custodian" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "activity" : [
    {
      "performedActivity" : [
        {
          "reference" : {
            "reference" : "Task/ExampleSGHITask"
          }
        }
      ]
    }
  ],
  "note" : [
    {
      "authorReference" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      },
      "text" : "Example Note"
    }
  ]
}

```
