# ExampleSGHIAppointment - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIAppointment**

## Example Appointment: ExampleSGHIAppointment

Profile: [SGHI Appointment Profile](StructureDefinition-appointment.md)

**identifier**: Accession ID/APT123456 (use: official, )

**status**: Booked

**specialty**: General practice

**appointmentType**: Routine appointment

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Observation](Condition-ExampleSGHICondition.md) |

**priority**: Routine

**start**: 2023-11-25 09:00:00+0000

**end**: 2023-11-25 09:30:00+0000

**created**: 2023-11-20 10:00:00+0000

**note**: 

> 

Patient requested morning appointment


**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

### Participants

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Actor** | **Status** |
| * | Attender | [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md) | Accepted |



## Resource Content

```json
{
  "resourceType" : "Appointment",
  "id" : "ExampleSGHIAppointment",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/appointment"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ACSN",
            "display" : "Accession ID"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "APT123456",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "booked",
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org/",
          "code" : "394814009",
          "display" : "General practice"
        }
      ]
    }
  ],
  "appointmentType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0276",
        "code" : "ROUTINE",
        "display" : "Routine appointment"
      }
    ]
  },
  "reason" : [
    {
      "reference" : {
        "reference" : "Condition/ExampleSGHICondition",
        "display" : "Observation"
      }
    }
  ],
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActPriority",
        "code" : "R",
        "display" : "Routine"
      }
    ]
  },
  "start" : "2023-11-25T09:00:00Z",
  "end" : "2023-11-25T09:30:00Z",
  "created" : "2023-11-20T10:00:00Z",
  "note" : [
    {
      "text" : "Patient requested morning appointment"
    }
  ],
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "ATND",
              "display" : "Attender"
            }
          ]
        }
      ],
      "actor" : {
        "reference" : "Patient/ExampleSGHIPatient"
      },
      "status" : "accepted"
    }
  ]
}

```
