# ExampleSGHIAllergyIntolerance - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIAllergyIntolerance**

## Example AllergyIntolerance: ExampleSGHIAllergyIntolerance

Profile: [SGHI AllergyIntolerance](StructureDefinition-allergyintolerance.md)

**identifier**: Medical Record Number/ALL123456789 (use: official, )

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**type**: allergy

**category**: Food

**criticality**: High Risk

**code**: Meat Allergy

**patient**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**onset**: 2025-01-01 10:30:00+0000

**recordedDate**: 2025-01-22

### Participants

| | |
| :--- | :--- |
| - | **Actor** |
| * | [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md) |

> **reaction****substance**:Meat

### Manifestations

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Observation](Observation-ExampleSGHIObservation.md) |

**description**: Severe rash and difficulty breathing**severity**: Severe**exposureRoute**:Oral



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "ExampleSGHIAllergyIntolerance",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/allergyintolerance"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "ALL123456789",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "type" : {
    "coding" : [
      {
        "code" : "allergy"
      }
    ]
  },
  "category" : ["food"],
  "criticality" : "high",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "227493005",
        "display" : "Meat Allergy"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "onsetDateTime" : "2025-01-01T10:30:00Z",
  "recordedDate" : "2025-01-22",
  "participant" : [
    {
      "actor" : {
        "reference" : "Patient/ExampleSGHIPatient"
      }
    }
  ],
  "reaction" : [
    {
      "substance" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "227493005",
            "display" : "Meat"
          }
        ]
      },
      "manifestation" : [
        {
          "reference" : {
            "reference" : "Observation/ExampleSGHIObservation",
            "display" : "Observation"
          }
        }
      ],
      "description" : "Severe rash and difficulty breathing",
      "severity" : "severe",
      "exposureRoute" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/route-codes",
            "code" : "oral",
            "display" : "Oral"
          }
        ]
      }
    }
  ]
}

```
