# Home - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/ImplementationGuide/silfhirprofileig | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIFHIRProfileImplementationGuide |

# SGHI FHIR Profile Implementation Guide

Welcome to the SGHI FHIR Profile Implementation Guide, a comprehensive resource designed to support the integration and use of the SGHI-specific FHIR profiles in healthcare systems. This guide provides detailed specifications, examples, and implementation best practices to ensure interoperability, consistency, and compliance with the SGHI standards for healthcare data exchange.

By leveraging these profiles, implementers can standardize the representation of healthcare data such as encounters, patients, and other clinical resources, facilitating seamless integration across SGHI systems and beyond. This guide is intended for developers, integrators, and system architects who aim to implement FHIR-based solutions tailored to SGHI requirements.

[SGHI FHIR Profile Implementation Guide code repository](https://github.com/savannahghi/sil_fhir_profile_ig)



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "silfhirprofileig",
  "url" : "https://fhir.slade360.co.ke/fhir/ImplementationGuide/silfhirprofileig",
  "version" : "0.1.0",
  "name" : "SGHIFHIRProfileImplementationGuide",
  "title" : "SGHI FHIR Profile Implementation Guide",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "packageId" : "silfhirprofileig",
  "license" : "CC0-1.0",
  "fhirVersion" : ["5.0.0"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r5",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r5",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_r5_core",
      "uri" : "http://hl7.org/fhir/ImplementationGuide/fhir",
      "packageId" : "hl7.fhir.r5.core",
      "version" : "5.0.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.9.0"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ICD11Codes"
        },
        "name" : "All ICD-11 codes",
        "description" : "All codes from ICD-11",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ICHICodes"
        },
        "name" : "All ICHI codes",
        "description" : "All codes from ICHI",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/all-loinc-codes"
        },
        "name" : "All LOINC Codes",
        "description" : "A ValueSet that includes all codes from the LOINC code system.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/behaviour"
        },
        "name" : "Behaviour Value Sets",
        "description" : "Behaviour Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/blood-pressure-units"
        },
        "name" : "Blood Pressure Units",
        "description" : "Units used for measuring blood pressure.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cancer-stages"
        },
        "name" : "Cancer Stages Value Sets",
        "description" : "Cancer Stages Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/CIELtoFHIRRiskAssessmentMap"
        },
        "name" : "CIEL to FHIR Code Map",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/CIELtoLOINCObservationMap"
        },
        "name" : "CIEL to LOINC Observation Code Map",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/CIELtoLOINCServiceRequestMap"
        },
        "name" : "CIEL to LOINC ServiceRequest Code Map",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/CIELtoICD11Condition"
        },
        "name" : "CIEL → ICD-11 Condition Map (generated 2025-07-09)",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/CIELtoLoincDiagnosticReportMap"
        },
        "name" : "CIEL → LOINC DiagnosticReport .code Map (breast-imaging + chest US)",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/condition-severity"
        },
        "name" : "condition-severity",
        "description" : "Condition severity",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/distance-metastatis"
        },
        "name" : "Distance Metastatis Value Sets",
        "description" : "Distance Metastatis Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DoseForm"
        },
        "name" : "Dose Form",
        "description" : "Version 1",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-class"
        },
        "name" : "Encounter Class Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActivityDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActivityDefinition/ExampleActivityDefintion"
        },
        "name" : "Example ActivityDefinition Title",
        "description" : "An example of SGHIActivityDefinition resource",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/activitydefinition"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CarePlan"
          }
        ],
        "reference" : {
          "reference" : "CarePlan/ExampleSGHICarePlan"
        },
        "name" : "Example CarePlan",
        "description" : "SGHI CarePlan demonstration.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/careplan"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/ExampleSGHIConsent"
        },
        "name" : "Example SGHI Consent",
        "description" : "An example of consent conforming to the SGHIConsent profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/consent"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "EpisodeOfCare"
          }
        ],
        "reference" : {
          "reference" : "EpisodeOfCare/ExampleSGHIEpisodeOfCare"
        },
        "name" : "Example SGHI Episode of Care",
        "description" : "An example of an episode of care conforming to the SGHIEpisodeOfCare profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/episodeofcare"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ExampleSGHIOrganization"
        },
        "name" : "Example SGHI Organization",
        "description" : "An example Organization resource conforming to the SGHIOrganization profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/ExampleSGHIAllergyIntolerance"
        },
        "name" : "ExampleSGHIAllergyIntolerance",
        "description" : "An example of an AllergyIntolerance resource conforming to the SGHI AllergyIntolerance profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/allergyintolerance"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Appointment"
          }
        ],
        "reference" : {
          "reference" : "Appointment/ExampleSGHIAppointment"
        },
        "name" : "ExampleSGHIAppointment",
        "description" : "An example of an Appointment resource conforming to the SGHI Appointment profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/appointment"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ExampleSGHICondition"
        },
        "name" : "ExampleSGHICondition",
        "description" : "An example of a Condition resource conforming to the SGHI Condition profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/condition"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/ExampleSGHIDiagnosticReport"
        },
        "name" : "ExampleSGHIDiagnosticReport",
        "description" : "An example of an DiagnosticReport resource conforming to the SGHI DiagnostiReport profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/diagnosticreport"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/ExampleSGHIDocumentReference"
        },
        "name" : "ExampleSGHIDocumentReference",
        "description" : "An example of an DocumentReference resource conforming to the SGHI SGHIDocumentReference profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/documentreference"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/ExampleSGHIEncounter"
        },
        "name" : "ExampleSGHIEncounter",
        "description" : "An example of an Encounter resource conforming to the SGHI Encounter profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/encounter"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/ExampleSGHILocation"
        },
        "name" : "ExampleSGHILocation",
        "description" : "An example of an Location resource conforming to the SGHI Location profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/fhir-location"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/ExampleSGHIMedicationRequest"
        },
        "name" : "ExampleSGHIMedicationRequest",
        "description" : "An example of a MedicationRequest resource conforming to the SGHI MedicationRequest profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/medicationrequest"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/ExampleSGHIObservation"
        },
        "name" : "ExampleSGHIObservation",
        "description" : "An example of an Observation resource conforming to the SGHI Observation profile",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/observation"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/ExampleSGHIPatient"
        },
        "name" : "ExampleSGHIPatient",
        "description" : "An example of a patient profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/ExampleSGHIPractitioner"
        },
        "name" : "ExampleSGHIPractitioner",
        "description" : "An example of a Practitioner resource conforming to the SGHI Practitioner profile",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitioner"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/ExampleSGHIPractitionerRole"
        },
        "name" : "ExampleSGHIPractitionerRole",
        "description" : "An example of a PractitionerRole resource conforming to the SGHI PractitionerRole profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitionerrole"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/ExampleSGHIProcedure"
        },
        "name" : "ExampleSGHIProcedure",
        "description" : "An example of a Procedure resource conforming to the SGHI Procedure profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/procedure"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RiskAssessment"
          }
        ],
        "reference" : {
          "reference" : "RiskAssessment/ExampleSGHIRiskAssessment"
        },
        "name" : "ExampleSGHIRiskAssessment",
        "description" : "An example of a RiskAssessment resource conforming to the SGHI RiskAssessment profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/riskassessment"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/ExampleSGHIServiceRequest"
        },
        "name" : "ExampleSGHIServiceRequest",
        "description" : "An example of a ServiceRequest resource conforming to the SGHI ServiceRequest profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/servicerequest"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/ExampleSGHISpecimen"
        },
        "name" : "ExampleSGHISpecimen",
        "description" : "An example of Specimen resource that conforms to SGHI Specimen profile",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/specimen"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Substance"
          }
        ],
        "reference" : {
          "reference" : "Substance/ExampleSGHISubstance"
        },
        "name" : "ExampleSGHISubstance",
        "description" : "An example of a substance profile",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/substance"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/ExampleSGHITask"
        },
        "name" : "ExampleSGHITask",
        "description" : "An example of a Task resource conforming to the SGHI Task profile.",
        "isExample" : true,
        "profile" : ["https://fhir.slade360.co.ke/fhir/StructureDefinition/task"]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/grade"
        },
        "name" : "Grade Value Sets",
        "description" : "Grade Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hormone-receptor-status"
        },
        "name" : "Hormone Receptor Status",
        "description" : "Hormone Receptor Status",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ICD-10-WHO"
        },
        "name" : "International Classification for Diseases version 10, WHO",
        "description" : "Based on ICD102019-covid",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/ICD-11-WHO"
        },
        "name" : "International Classification for Diseases version 11, WHO",
        "description" : "This version contains the latest version of ICD-11 (2024)",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/investigations"
        },
        "name" : "Investigations",
        "description" : "First Version",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/KNC4Drugs"
        },
        "name" : "KNC4Drugs",
        "description" : "First Version",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/KNC4Investigations"
        },
        "name" : "KNC4Investigations",
        "description" : "First Version",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/laterality"
        },
        "name" : "Laterality Value Sets",
        "description" : "Laterality Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/legacy-identifier-types"
        },
        "name" : "Legacy Identifier Types (Deprecated)",
        "description" : "Obsolete identifier-type codes encountered in R4 data.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/LegacyIdentifierToSGHI"
        },
        "name" : "Legacy → SGHI Identifier Types",
        "description" : "Maps obsolete identifier-type codes to the SGHI canonical codes.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/molecular-Markers"
        },
        "name" : "Molecular Markers Value Sets",
        "description" : "Molecular Markers Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PlanDefinition"
          }
        ],
        "reference" : {
          "reference" : "PlanDefinition/ExampleSGHIPlanDefinition"
        },
        "name" : "PlanDefinition Title",
        "description" : "An example of an PlanDefintion resource conforming to the SGHI PlanDefinition profile.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/plandefinition"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/FHIRCodeCategoryMap"
        },
        "name" : "R4 to R5 Category Map",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
        },
        "name" : "R4 to R5 Category Map",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/FHIRClinicalStatusMap"
        },
        "name" : "R4 to R5 ClinicalStatus Map",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/retired-ciel-codes"
        },
        "name" : "Retired CIEL Codes",
        "description" : "A collection of CIEL codes formerly in use for clinical observations.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/retired-fhrr4-codes"
        },
        "name" : "Retired FHIR R4 Codes",
        "description" : "A collection of FHIR R 4 codes formerly in used in R4",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/route-of-administration"
        },
        "name" : "Route Of Administration",
        "description" : "A ValueSet defining the possible routes of drug administration.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/RouteOfAdministration"
        },
        "name" : "Route Of Administration",
        "description" : "Version 1",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/service-request-category"
        },
        "name" : "Service Request Categories",
        "description" : "A ValueSet categorizing different types of service requests.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/activitydefinition"
        },
        "name" : "SGHI Activity Defintion Profile",
        "description" : "This resouce allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/allergyintolerance"
        },
        "name" : "SGHI AllergyIntolerance",
        "description" : "Risk of harmful or undesirable physiological response which is specific to an individual and associated with exposure to a substance.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/annotation"
        },
        "name" : "SGHI Annotation",
        "description" : "A text note which also contains information about who made the statement and when.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/appointment"
        },
        "name" : "SGHI Appointment Profile",
        "description" : "A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/attachment"
        },
        "name" : "SGHI Attachment",
        "description" : "A custom document used for capturing the source of consent",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/bed-status"
        },
        "name" : "SGHI Bed Status",
        "description" : "Codes that can be used to indicate the operating status of an organization's location",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/body-site-value-set"
        },
        "name" : "SGHI Body Site Value Set",
        "description" : "Custom body site value set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/careplan"
        },
        "name" : "SGHI Care Plan",
        "description" : "A profile on the R5 CarePlan resource to represent a patient's treatment or management plan, such as a chemotherapy regimen.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/codeableconcept"
        },
        "name" : "SGHI CodeableConcept",
        "description" : "A CodeableConcept represents a value that is usually supplied by providing a reference to one or more terminologies or ontologies but may also be defined by the provision of text. This is a common pattern in healthcare data.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/codeable-reference"
        },
        "name" : "SGHI CodeableReference",
        "description" : "A reusable CodeableReference within SGHI systems",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/composition"
        },
        "name" : "SGHI Composition",
        "description" : "A set of healthcare-related information that is assembled together into a single logical package that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \nA Composition defines the structure and narrative content necessary for a document. However, a Composition alone does not constitute a document. Rather, the Composition must be the first entry in a Bundle where Bundle.type=document, \nand any other resources referenced from Composition must be included as subsequent entries in the Bundle (for example Patient, Practitioner, Encounter, etc.).",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition"
        },
        "name" : "SGHI Condition",
        "description" : "A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/consent"
        },
        "name" : "SGHI Consent",
        "description" : "A record of a healthcare consumer’s choices or choices made on their behalf by a third party, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contact-point-use"
        },
        "name" : "SGHI Contact Point Use",
        "description" : "Code used to indicate contact use",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contact-relationship"
        },
        "name" : "SGHI Contact Relationship Types",
        "description" : "Contact relationship types used in SGHI systems",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/contact-system"
        },
        "name" : "SGHI Contact System",
        "description" : "Code used to indicate what communications system is required to make use of the contact.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/contact-point"
        },
        "name" : "SGHI ContactPoint",
        "description" : "A custom contact point with stricter cardinality",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/default-code"
        },
        "name" : "SGHI Default Code Value Sets",
        "description" : "SGHI Default Code Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/default-identifier-types"
        },
        "name" : "SGHI Default Identifier Types",
        "description" : "Default identifier types used in SGHI's systems",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/diagnostic-conclusion-icd11"
        },
        "name" : "SGHI Diagnostic Conclusion ICD-11",
        "description" : "ICD-11 codes used for diagnostic conclusions in SGHI",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/diagnosticreport"
        },
        "name" : "SGHI DiagnosticReport",
        "description" : "SGHI's profile for DiagnosticReport",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/ExampleSGHIComposition"
        },
        "name" : "SGHI Discharge Summary for John Doe",
        "description" : "An expanded Composition demonstration.",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/composition"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/documentreference"
        },
        "name" : "SGHI DocumentReference Profile.",
        "description" : "A reference to a document of any kind for any purpose.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/dosage"
        },
        "name" : "SGHI Dosage",
        "description" : "A comprehensive Dosage profile for SGHI prescriptions, ensuring structured routes, methods, timing, and dose details.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/drugs-identifier-type"
        },
        "name" : "SGHI Drugs Identifier Types",
        "description" : "Identifier types used across dm+d hierarchy",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/encounter"
        },
        "name" : "SGHI Encounter",
        "description" : "An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient. Encounter is primarily used to record information about the actual activities that occurred, where Appointment is used to record planned activities.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-act-priority"
        },
        "name" : "SGHI Encounter Priority",
        "description" : "Urgency of an encounter",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/episodeofcare"
        },
        "name" : "SGHI EpisodeOfCare",
        "description" : "An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/human-name"
        },
        "name" : "SGHI HumanName",
        "description" : "A specialized human name data type with stricter cardinalities.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/identifier-codesystem"
        },
        "name" : "SGHI Identifier Code System",
        "description" : "A single code system enumerating the many local identifier types used across SGHI's environment.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/investigation-codes"
        },
        "name" : "SGHI Investigation Codes",
        "description" : "ValueSet containing SGHI investigation codes",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/fhir-location"
        },
        "name" : "SGHI Location",
        "description" : "SGHI profile for location",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/location-form"
        },
        "name" : "SGHI Location Form",
        "description" : "Physical form of the location, e.g. building, room, vehicle, road, virtual.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/location-mode"
        },
        "name" : "SGHI Location Mode",
        "description" : "Codes that can be used to indicate the mode of a location",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/loinc-codesystem"
        },
        "name" : "SGHI LOINC Code System",
        "description" : "A a subset of LOINC codes used across SGHI's environment.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication"
        },
        "name" : "SGHI Medication",
        "description" : "SGHI's Medication profile for Medication resource",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-codes"
        },
        "name" : "SGHI Medication Codes",
        "description" : "ValueSet containing SGHI medication codes",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicationdispense"
        },
        "name" : "SGHI Medication Dispense",
        "description" : "SGHI's profile for Medication Dispense resource",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/ExampleSGHIMedicationDispense"
        },
        "name" : "SGHI Medication Dispense",
        "description" : "An example of a Medication Dispense resource adhering to SGHI's Medication Dispense",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/medicationdispense"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-form-codes"
        },
        "name" : "SGHI Medication Form Codes",
        "description" : "ValueSet containing SGHI medication form codes",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/ExampleSGHIMedication"
        },
        "name" : "SGHI Medication resource example",
        "description" : "An example of SGHI Medication resource Example",
        "isExample" : true,
        "profile" : [
          "https://fhir.slade360.co.ke/fhir/StructureDefinition/medication"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medicationrequest"
        },
        "name" : "SGHI MedicationRequest",
        "description" : "An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called 'MedicationRequest' rather than 'MedicationPrescription' or 'MedicationOrder' to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/method-of-administration"
        },
        "name" : "SGHI Method Of Medication Administration",
        "description" : "Custom methods of administering medication",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation"
        },
        "name" : "SGHI Observation",
        "description" : "Measurements and simple assertions made about a patient, device or other subject.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization"
        },
        "name" : "SGHI Organization",
        "description" : "SGHI's profile for Organization",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/organization-identifier-types"
        },
        "name" : "SGHI Organization Identifier Types",
        "description" : "Identifier types used to identify an organization across in SIL's systems",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient"
        },
        "name" : "SGHI Patient",
        "description" : "Demographics and other administrative information about an individual or animal receiving care or other health-related services.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/patient-identifier-types"
        },
        "name" : "SGHI Person Identifier Types",
        "description" : "Identifier types used  to identify patient, practitioner, animal or a live actor in the healthcare context in SGHI's systems",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/plandefinition"
        },
        "name" : "SGHI Plan Definition Profile",
        "description" : "This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner"
        },
        "name" : "SGHI Practitioner",
        "description" : "SGHI's Practitioner used in SGHI systems",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/practitioner-role-value-set"
        },
        "name" : "SGHI Practitioner Value Set",
        "description" : "Custom practioner role value set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/practitioner-specialty-value-set"
        },
        "name" : "SGHI Practitioner Value Set",
        "description" : "Custom practioner specialty value set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerrole"
        },
        "name" : "SGHI PractitionerRole",
        "description" : "PractitionerRole describes the types of services that practitioners provide to SGHI Organization at specific location(s). The profile a specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/procedure"
        },
        "name" : "SGHI Procedure",
        "description" : "This resource is used to record the details of current and historical procedures performed on, with, or for a patient, practitioner, device, organization, or location. Examples include surgical procedures, diagnostic procedures, endoscopic procedures, biopsies, counseling, physiotherapy, personal support services, adult day care services, non-emergency transportation, home modification, exercise, verification of enrollment qualifications for a social program etc. Procedures may be performed by a healthcare professional, a service provider, a friend or relative or in some cases by the patient themselves.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/procedure-category"
        },
        "name" : "SGHI Procedure Category value set",
        "description" : "A value set for categorizing procedures, using LOINC codes where applicable.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/procedure-follow-up-codes"
        },
        "name" : "SGHI Procedure follow up codes",
        "description" : "Custom follow up procedure codes",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/procedure-outcome"
        },
        "name" : "SGHI Procedure outcome value set",
        "description" : "The outcome of the procedure - did it resolve the reasons for the procedure being performed?",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/procedure-status"
        },
        "name" : "SGHI Procedure status value set",
        "description" : "A value set for the status of a procedure, based on the FHIR ProcedureStatus codes.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/reference"
        },
        "name" : "SGHI Reference",
        "description" : "SGHI Reference",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/riskassessment"
        },
        "name" : "SGHI RiskAssessment",
        "description" : "An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/service-request-cs"
        },
        "name" : "SGHI Service Request CodeSystem",
        "description" : "A custom CodeSystem defining different elements of service requests.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/servicerequest"
        },
        "name" : "SGHI ServiceRequest",
        "description" : "ServiceRequest represents an order or proposal or plan, as distinguished by ServiceRequest.intent to perform a diagnostic or other service on or for a patient. ServiceRequest represents a proposal or plan or order for a service to be performed that would result in a Procedure or DiagnosticReport, which in turn may reference one or more Observations, which summarize the performance of the procedures and associated documentation such as observations, images, findings that are relevant to the treatment/management of the subject. This resource may be used to share relevant information required to support a referral or a transfer of care request from one practitioner or organization to another when a patient is required to be referred to another provider for a consultation /second opinion and/or for short term or longer term management of one or more health issues or problems.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/specialtycodesystem"
        },
        "name" : "SGHI Specialty Code System",
        "description" : "A Specialty Code System to be used in  SGHI's environment.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/specimen"
        },
        "name" : "SGHI Specimen",
        "description" : "A sample to be used for analysis.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/substance"
        },
        "name" : "SGHI Substance",
        "description" : "Profile for representing substances in the SGHI context",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/substance-codes"
        },
        "name" : "SGHI Substance Codes",
        "description" : "ValueSet containing SGHI substance codes",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/task"
        },
        "name" : "SGHI Task",
        "description" : "SGHI's profile for Task",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/SGHIConditionSeverityCodeSystem"
        },
        "name" : "SGHIConditionSeverityCodeSystem",
        "description" : "A single code system enumerating severity levels for clinical conditions within the SGHI ecosystem.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/SGHIDefaultIdentifierCodeSystem"
        },
        "name" : "SGHIDefaultIdentifierCodeSystem",
        "description" : "A single code system enumerating severity levels for clinical conditions within the SGHI ecosystem.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/SGHIOrganisationIdentifierCodeSystem"
        },
        "name" : "SGHIOrganisationIdentifierCodeSystem",
        "description" : "A single code system enumerating the identifier types used identify organisations across SIL's environment.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/SGHIPersonIdentifierCodeSystem"
        },
        "name" : "SGHIPersonIdentifierCodeSystem",
        "description" : "A code system different identifiers used to identify an animal, patient, practitioner or any other live actior in the healthcare context",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/speciality"
        },
        "name" : "speciality",
        "description" : "Speciality",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/specimentype"
        },
        "name" : "Specimen Type Value Sets",
        "description" : "Specimen Type Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/typeoftest"
        },
        "name" : "Type Of Test Value Sets",
        "description" : "Type Of Test Value Sets",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/AllergyIntoleranceSGHI5"
        },
        "name" : "Encounter Transforms: R4 → SGHI R5",
        "description" : "EncounterTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/AppointmentSGHI5"
        },
        "name" : "Appointment Transforms: R4 → SGHI R5",
        "description" : "AppointmentTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/Composition4toSGHI5"
        },
        "name" : "Composition Transforms: R4 to SGHI R5",
        "description" : "CompositionTransformsR4toSGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/ConditionSGHI5"
        },
        "name" : "Condition Transforms: R4 → SGHI R5",
        "description" : "ConditionTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/ConsenttoSGHI5"
        },
        "name" : "Consent Transforms: R4 → SGHI R5",
        "description" : "ConsentTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/DiagnosticReportSGHI5"
        },
        "name" : "DiagnosticReport Transforms: R4 → SGHI R5",
        "description" : "DiagnosticReportTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/DocumentReferenceSGHI5"
        },
        "name" : "DocumentReference Transforms: R4 to SGHI R5",
        "description" : "DocumentReferenceTransformsR4toSGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/Encounter4toSGHI5"
        },
        "name" : "Encounter Transforms: R4 → SGHI R5",
        "description" : "EncounterTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/EpisodeOfCare4toSGHI5"
        },
        "name" : "EpisodeOfCare Transforms: R4 → SGHI R5",
        "description" : "EpisodeOfCareTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/GlasgowCommaScaleExtract"
        },
        "name" : "Glasgow Coma Scale Extraction",
        "description" : "Extracts three Observation resources, one per GCS subscore, from a QuestionnaireResponse to the GCS questionnaire."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/MedicationRequestSGHI5"
        },
        "name" : "MedicationRequest Transforms: R4 → SGHI R5",
        "description" : "MedicationRequestTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/Observation4toSGHI5"
        },
        "name" : "Observation Transforms: R4 to SGHI R5",
        "description" : "ObservationTransformsR4toSGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/Organization4toSGHI5"
        },
        "name" : "Organization Transforms: R4 → SGHI R5",
        "description" : "OrganizationTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/Patient4toSGHI5"
        },
        "name" : "Patient Transforms: R4 → SGHI R5",
        "description" : "PatientTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/RiskAssessmentR4toSGHIR5"
        },
        "name" : "RiskAssessment Transforms: R4 → SGHI R5",
        "description" : "RiskAssessmentTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/ServiceRequestSGHI5"
        },
        "name" : "ServiceRequest Transforms: R4 → SGHI R5",
        "description" : "ServiceRequestTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/Task4toSGHI5"
        },
        "name" : "Task Transforms: R4 → SGHI R5",
        "description" : "TaskTransformsR4SGHIR5"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/ExtractVitalSigns"
        },
        "name" : "ExtractVitalSigns"
      }
    ],
    "page" : {
      "sourceUrl" : "toc.html",
      "name" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "sourceUrl" : "index.html",
          "name" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "copyrightyear"
        },
        "value" : "2025+"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "releaselabel"
        },
        "value" : "ci-build"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "autoload-resources"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/capabilities"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/examples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/extensions"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/models"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/operations"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/profiles"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/vocabulary"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/testing"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/history"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "fsh-generated/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "template/config"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/images"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "template/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "input/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-qa"
        },
        "value" : "temp/qa"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-temp"
        },
        "value" : "temp/pages"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-output"
        },
        "value" : "output"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-tx-cache"
        },
        "value" : "input-cache/txcache"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-suppressed-warnings"
        },
        "value" : "input/ignoreWarnings.txt"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-history"
        },
        "value" : "https://fhir.slade360.co.ke/fhir/history.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-html"
        },
        "value" : "template-page.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-md"
        },
        "value" : "template-page-md.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-contact"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-context"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-copyright"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-jurisdiction"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-license"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-publisher"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-version"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-wg"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "active-tables"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "fmm-definition"
        },
        "value" : "http://hl7.org/fhir/versions.html#maturity"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "propagate-status"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludelogbinaryformat"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "tabbed-snapshots"
        },
        "value" : "true"
      }
    ]
  }
}

```
