# ExampleSGHITask - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHITask**

## Example Task: ExampleSGHITask

Profile: [SGHI Task](StructureDefinition-task.md)

**identifier**: Placer Identifier/TASK123456 (use: official, )

**status**: In Progress

**businessStatus**: In Progress

**intent**: order

**priority**: Routine

**for**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**authoredOn**: 2023-11-20 09:00:00+0000

**lastModified**: 2023-11-20 09:30:00+0000

**requester**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

### RequestedPerformers

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Organzation](Organization-ExampleSGHIOrganization.md) |

**owner**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

### Inputs

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Request | Patient blood test request |

### Outputs

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Result | Blood test completed successfully |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "ExampleSGHITask",
  "meta" : {
    "profile" : ["https://fhir.slade360.co.ke/fhir/StructureDefinition/task"]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "TASK123456",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "in-progress",
  "businessStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/task-status",
        "code" : "in-progress",
        "display" : "In Progress"
      }
    ]
  },
  "intent" : "order",
  "priority" : "routine",
  "for" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "authoredOn" : "2023-11-20T09:00:00Z",
  "lastModified" : "2023-11-20T09:30:00Z",
  "requester" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "requestedPerformer" : [
    {
      "reference" : {
        "reference" : "Organization/ExampleSGHIOrganization",
        "display" : "Organzation"
      }
    }
  ],
  "owner" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "input" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/task-input-type",
            "code" : "request",
            "display" : "Request"
          }
        ]
      },
      "valueString" : "Patient blood test request"
    }
  ],
  "output" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/task-output-type",
            "code" : "result",
            "display" : "Result"
          }
        ]
      },
      "valueString" : "Blood test completed successfully"
    }
  ]
}

```
