# Task Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Task Transforms: R4 → SGHI R5**

## StructureMap: Task Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/Task4toSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:Task4toSGHI5 |

 
TaskTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "Task4toSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/Task4toSGHI5",
  "version" : "0.1.0",
  "name" : "Task4toSGHI5",
  "title" : "Task Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "TaskTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/Task",
      "mode" : "source",
      "alias" : "TaskR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/task",
      "mode" : "target",
      "alias" : "SGHITask"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHITask",
      "extends" : "DomainResource",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "TaskR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHITask",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "true"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "tgt_n",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "creating identifier",
          "source" : [
            {
              "context" : "src",
              "variable" : "sc",
              "condition" : "identifier.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "tt_id",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "creating id",
              "source" : [
                {
                  "context" : "src",
                  "element" : "id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "creating use",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "creating identifier type",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tt_id",
                  "element" : "type",
                  "variable" : "ty"
                }
              ],
              "rule" : [
                {
                  "name" : "creating identifier type",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ty",
                      "element" : "coding",
                      "variable" : "ty_c",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "CodeableConcept"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "creating coding",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "creating code",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "creating display",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "ty_c",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "creating system",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt_id",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "owner",
                  "source" : [
                    {
                      "context" : "src",
                      "element" : "owner",
                      "variable" : "sp"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt_id",
                      "element" : "assigner",
                      "variable" : "t_assigner",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "reference",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "reference",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_assigner",
                          "element" : "reference",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "setting default display",
                      "source" : [
                        {
                          "context" : "sp",
                          "condition" : "sp.display.exists().not()"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_assigner",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "Unknown display"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "display",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "display",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_assigner",
                          "element" : "display",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Create identifier"
        },
        {
          "name" : "set profile in meta",
          "source" : [
            {
              "context" : "src",
              "element" : "meta",
              "variable" : "s_meta"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "lastUpdated",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "lastUpdated",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "lastUpdated",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "language",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "language",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "language",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "tags",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "tags",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "tags",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setprofileinmeta",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "condition" : "profile.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/task"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "status",
          "source" : [
            {
              "context" : "src",
              "element" : "status",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "period",
          "source" : [
            {
              "context" : "src",
              "element" : "period",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "period",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "mapping business status",
          "source" : [
            {
              "context" : "src",
              "variable" : "sb",
              "condition" : "businessStatus.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "businessStatus",
              "variable" : "tb"
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sb",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tb",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "basedOn",
          "source" : [
            {
              "context" : "src",
              "element" : "basedOn",
              "variable" : "sb"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "basedOn",
              "variable" : "tb"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sb"
                },
                {
                  "valueId" : "tb"
                }
              ]
            }
          ]
        },
        {
          "name" : "authoredOn",
          "source" : [
            {
              "context" : "src",
              "element" : "authoredOn",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "authoredOn",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "encounter",
          "source" : [
            {
              "context" : "src",
              "element" : "encounter",
              "variable" : "se"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "encounter",
              "variable" : "te"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "se"
                },
                {
                  "valueId" : "te"
                }
              ]
            }
          ]
        },
        {
          "name" : "executionPeriod",
          "source" : [
            {
              "context" : "src",
              "element" : "executionPeriod",
              "variable" : "sp"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "executionPeriod",
              "variable" : "tp"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformPeriod",
              "parameter" : [
                {
                  "valueId" : "sp"
                },
                {
                  "valueId" : "tp"
                }
              ]
            }
          ]
        },
        {
          "name" : "focus",
          "source" : [
            {
              "context" : "src",
              "element" : "focus",
              "variable" : "sf"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "focus",
              "variable" : "tf"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sf"
                },
                {
                  "valueId" : "tf"
                }
              ]
            }
          ]
        },
        {
          "name" : "for",
          "source" : [
            {
              "context" : "src",
              "element" : "for",
              "variable" : "sf"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "for",
              "variable" : "tf"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sf"
                },
                {
                  "valueId" : "tf"
                }
              ]
            }
          ]
        },
        {
          "name" : "intent",
          "source" : [
            {
              "context" : "src",
              "element" : "intent",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "intent",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "owner",
          "source" : [
            {
              "context" : "src",
              "element" : "owner",
              "variable" : "so"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "owner",
              "variable" : "to"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "so"
                },
                {
                  "valueId" : "to"
                }
              ]
            }
          ]
        },
        {
          "name" : "priority",
          "source" : [
            {
              "context" : "src",
              "element" : "priority",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "priority",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "requester",
          "source" : [
            {
              "context" : "src",
              "element" : "requester",
              "variable" : "sr"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "requester",
              "variable" : "tr"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sr"
                },
                {
                  "valueId" : "tr"
                }
              ]
            }
          ]
        },
        {
          "name" : "creating requested performer",
          "source" : [
            {
              "context" : "src",
              "condition" : "requestedPerformer.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "requestedPerformer",
              "variable" : "to",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableReference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "owner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "owner",
                  "variable" : "so"
                }
              ],
              "target" : [
                {
                  "context" : "to",
                  "element" : "reference",
                  "variable" : "to"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "so"
                    },
                    {
                      "valueId" : "to"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "creating business status",
          "source" : [
            {
              "context" : "src",
              "condition" : "businessStatus.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "businessStatus",
              "variable" : "tb",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableConcept"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "basedOn",
              "source" : [
                {
                  "context" : "src",
                  "element" : "basedOn",
                  "listMode" : "first",
                  "variable" : "st"
                }
              ],
              "rule" : [
                {
                  "name" : "type",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "type",
                      "variable" : "text"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tb",
                      "element" : "text",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueId" : "text"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "businessStatus",
          "source" : [
            {
              "context" : "src",
              "element" : "businessStatus",
              "variable" : "st"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "businessStatus",
              "variable" : "ts"
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "st",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "ts",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformPeriod",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "start",
          "source" : [
            {
              "context" : "src",
              "element" : "start",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "start",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "end",
          "source" : [
            {
              "context" : "src",
              "element" : "end",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "end",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
