# Organization Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization Transforms: R4 → SGHI R5**

## StructureMap: Organization Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/Organization4toSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:Organization4toSGHI5 |

 
OrganizationTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "Organization4toSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/Organization4toSGHI5",
  "version" : "0.1.0",
  "name" : "Organization4toSGHI5",
  "title" : "Organization Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "OrganizationTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/Organization",
      "mode" : "source",
      "alias" : "OrganizationR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization",
      "mode" : "target",
      "alias" : "SGHIOrganization"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIOrganization",
      "extends" : "DomainResource",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "OrganizationR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIOrganization",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "processoneidentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "identifier",
              "variable" : "s",
              "condition" : "(s.system = 'SladeCode') and s.value.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t"
            }
          ],
          "rule" : [
            {
              "name" : "copyuse",
              "source" : [
                {
                  "context" : "s",
                  "element" : "use",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "use",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "copyvalue",
              "source" : [
                {
                  "context" : "s",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "copyperiod",
              "source" : [
                {
                  "context" : "s",
                  "element" : "period",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "period",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "type",
              "source" : [
                {
                  "context" : "s",
                  "element" : "type",
                  "variable" : "st"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "type",
                  "variable" : "tt"
                }
              ],
              "rule" : [
                {
                  "name" : "coding",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "coding",
                      "variable" : "sc",
                      "condition" : "(sc.system = 'SladeCode')"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt",
                      "element" : "coding",
                      "variable" : "tc",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "CodeableConcept"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "slade-code"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "Slade360 Code"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "SetFixedIdentifierSystem",
              "source" : [
                {
                  "context" : "s"
                }
              ],
              "target" : [
                {
                  "context" : "t",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "create the default FHIR ID identifier type",
          "source" : [
            {
              "context" : "src",
              "element" : "identifier",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_id"
            }
          ],
          "rule" : [
            {
              "name" : "copyuse",
              "source" : [
                {
                  "context" : "s_id",
                  "element" : "use",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "use",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "id",
              "source" : [
                {
                  "context" : "src",
                  "element" : "id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "period",
              "source" : [
                {
                  "context" : "s_id",
                  "element" : "period",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "period",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "type",
              "source" : [
                {
                  "context" : "s_id",
                  "element" : "type",
                  "variable" : "st"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "type",
                  "variable" : "tt"
                }
              ],
              "rule" : [
                {
                  "name" : "coding",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "coding"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt",
                      "element" : "coding",
                      "variable" : "tt",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "CodeableConcept"
                        }
                      ]
                    },
                    {
                      "context" : "tt",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    },
                    {
                      "context" : "tt",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "fhir-id"
                        }
                      ]
                    },
                    {
                      "context" : "tt",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "FHIR Id"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "SetFixedIdentifierSystem",
              "source" : [
                {
                  "context" : "s_id"
                }
              ],
              "target" : [
                {
                  "context" : "t_id",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "name",
          "source" : [
            {
              "context" : "src",
              "element" : "name",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "name",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "createcontact",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "contact",
              "variable" : "t_contact",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "ExtendedContactDetail"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "setcontact",
              "source" : [
                {
                  "context" : "src",
                  "element" : "telecom",
                  "variable" : "s_contact"
                }
              ],
              "target" : [
                {
                  "context" : "t_contact",
                  "element" : "telecom",
                  "variable" : "t_contact"
                }
              ],
              "dependent" : [
                {
                  "name" : "SGHIContactPointMap",
                  "parameter" : [
                    {
                      "valueId" : "s_contact"
                    },
                    {
                      "valueId" : "t_contact"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "tgt_n",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedprofile",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "tm",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Meta"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "setprofileinmeta",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tm",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SGHIContactPointMap",
      "extends" : "ContactPoint",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "value",
          "source" : [
            {
              "context" : "src",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "use",
          "source" : [
            {
              "context" : "src",
              "element" : "use",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "use",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "rank",
          "source" : [
            {
              "context" : "src",
              "element" : "rank",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "rank",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "period",
          "source" : [
            {
              "context" : "src",
              "element" : "period",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "period",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
