# Observation Transforms: R4 to SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation Transforms: R4 to SGHI R5**

## StructureMap: Observation Transforms: R4 to SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/Observation4toSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:Observation4toSGHI5 |

 
ObservationTransformsR4toSGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "Observation4toSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/Observation4toSGHI5",
  "version" : "0.1.0",
  "name" : "Observation4toSGHI5",
  "title" : "Observation Transforms: R4 to SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "ObservationTransformsR4toSGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/Observation",
      "mode" : "source",
      "alias" : "ObservationR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/observation",
      "mode" : "target",
      "alias" : "SGHIObservation"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIObservation",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "ObservationR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIObservation",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "uuid"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "uuid"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "addtometa",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "addprofile",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/observation"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src",
              "condition" : "text.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "t_text",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting text",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "ttt",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "src",
                  "element" : "text",
                  "variable" : "st"
                }
              ],
              "rule" : [
                {
                  "name" : "status",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "status",
                      "variable" : "s"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "status",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueId" : "s"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "wraptextinhtml",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "div",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "div",
                      "transform" : "evaluate",
                      "parameter" : [
                        {
                          "valueString" : "'<div xmlns=\\\"http://www.w3.org/1999/xhtml\\\"><p>' + d + '</p></div>'"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "addfhirididentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_ident",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "copyid",
              "source" : [
                {
                  "context" : "s_id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setuse",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setsystem",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "inittype",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "type",
                  "variable" : "t_type",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "initcoding",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_type",
                      "element" : "coding",
                      "variable" : "t_code",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "typesystem",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typecode",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typedisplay",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting owner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_ident",
                      "element" : "assigner",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "mapissuedfromeffective",
          "source" : [
            {
              "context" : "src",
              "element" : "effectiveInstant",
              "variable" : "se"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "issued",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "se"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "scode"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "scode",
                  "element" : "coding",
                  "variable" : "d",
                  "condition" : "system.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "coding",
                  "transform" : "translate",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    },
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                    },
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "scode",
                  "element" : "coding",
                  "variable" : "d",
                  "condition" : "system.exists()"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "coding",
                  "variable" : "tcoding",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "code"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "code",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "code"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                        },
                        {
                          "valueString" : "code"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "sd"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "system",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "sd"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                        },
                        {
                          "valueString" : "system"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "display",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcode",
                      "element" : "text",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "s_code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "t_code"
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "s_code",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "t_code",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "basedOn",
              "source" : [
                {
                  "context" : "src",
                  "element" : "basedOn",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "basedOn",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "partOf",
              "source" : [
                {
                  "context" : "src",
                  "element" : "partOf",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "partOf",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "category",
              "source" : [
                {
                  "context" : "src",
                  "element" : "category",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "category",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "status",
              "source" : [
                {
                  "context" : "src",
                  "element" : "status",
                  "variable" : "v"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "status",
                  "transform" : "translate",
                  "parameter" : [
                    {
                      "valueId" : "v"
                    },
                    {
                      "valueString" : "http://hl7.org/fhir/uv/xver/ConceptMap/obs.status-4to5"
                    },
                    {
                      "valueString" : "code"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "subject",
              "source" : [
                {
                  "context" : "src",
                  "element" : "subject",
                  "variable" : "sb"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "subject",
                  "variable" : "tb"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sb"
                    },
                    {
                      "valueId" : "tb"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "focus",
              "source" : [
                {
                  "context" : "src",
                  "element" : "focus",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "focus",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "encounter",
              "source" : [
                {
                  "context" : "src",
                  "element" : "encounter",
                  "variable" : "se"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "encounter",
                  "variable" : "te"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "se"
                    },
                    {
                      "valueId" : "te"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "effectiveDateTime",
              "source" : [
                {
                  "context" : "src",
                  "type" : "dateTime",
                  "element" : "effective",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "effective",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "effectivePeriod",
              "source" : [
                {
                  "context" : "src",
                  "type" : "Period",
                  "element" : "effective",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "effective",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "effectiveTiming",
              "source" : [
                {
                  "context" : "src",
                  "type" : "Timing",
                  "element" : "effective",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "effective",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "effectiveInstant",
              "source" : [
                {
                  "context" : "src",
                  "type" : "instant",
                  "element" : "effective",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "effective",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueQuantity",
              "source" : [
                {
                  "context" : "src",
                  "type" : "Quantity",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueCodeableConcept",
              "source" : [
                {
                  "context" : "src",
                  "type" : "CodeableConcept",
                  "element" : "value",
                  "variable" : "sv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "sv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueString",
              "source" : [
                {
                  "context" : "src",
                  "type" : "string",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueBoolean",
              "source" : [
                {
                  "context" : "src",
                  "type" : "boolean",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueInteger",
              "source" : [
                {
                  "context" : "src",
                  "type" : "integer",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueRange",
              "source" : [
                {
                  "context" : "src",
                  "type" : "Range",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueRatio",
              "source" : [
                {
                  "context" : "src",
                  "type" : "Ratio",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueSampledData",
              "source" : [
                {
                  "context" : "src",
                  "type" : "SampledData",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueTime",
              "source" : [
                {
                  "context" : "src",
                  "type" : "time",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valueDateTime",
              "source" : [
                {
                  "context" : "src",
                  "type" : "dateTime",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valuePeriod",
              "source" : [
                {
                  "context" : "src",
                  "type" : "Period",
                  "element" : "value",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "value",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "dataAbsentReason",
              "source" : [
                {
                  "context" : "src",
                  "element" : "dataAbsentReason",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "dataAbsentReason",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "interpretation",
              "source" : [
                {
                  "context" : "src",
                  "element" : "interpretation",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "interpretation",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "note",
              "source" : [
                {
                  "context" : "src",
                  "element" : "note",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "note",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "bodySite",
              "source" : [
                {
                  "context" : "src",
                  "element" : "bodySite",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "bodySite",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "method",
              "source" : [
                {
                  "context" : "src",
                  "element" : "method",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "method",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "specimen",
              "source" : [
                {
                  "context" : "src",
                  "element" : "specimen",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "specimen",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "device",
              "source" : [
                {
                  "context" : "src",
                  "element" : "device",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "device",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "referenceRange",
              "source" : [
                {
                  "context" : "src",
                  "element" : "referenceRange",
                  "variable" : "s"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "referenceRange",
                  "variable" : "t"
                }
              ],
              "dependent" : [
                {
                  "name" : "ObservationReferenceRange",
                  "parameter" : [
                    {
                      "valueId" : "s"
                    },
                    {
                      "valueId" : "t"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "hasMember",
              "source" : [
                {
                  "context" : "src",
                  "element" : "hasMember",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "hasMember",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "derivedFrom",
              "source" : [
                {
                  "context" : "src",
                  "element" : "derivedFrom",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "derivedFrom",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "component",
              "source" : [
                {
                  "context" : "src",
                  "element" : "component",
                  "variable" : "s"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "component",
                  "variable" : "t"
                }
              ],
              "dependent" : [
                {
                  "name" : "ObservationComponent",
                  "parameter" : [
                    {
                      "valueId" : "s"
                    },
                    {
                      "valueId" : "t"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "performer",
              "source" : [
                {
                  "context" : "src",
                  "element" : "performer",
                  "variable" : "spf"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "performer",
                  "variable" : "tpf"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "spf"
                    },
                    {
                      "valueId" : "tpf"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting performer",
              "source" : [
                {
                  "context" : "src",
                  "condition" : "performer.exists().not()"
                }
              ],
              "rule" : [
                {
                  "name" : "meta",
                  "source" : [
                    {
                      "context" : "src",
                      "element" : "meta",
                      "variable" : "sm"
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "tag",
                      "source" : [
                        {
                          "context" : "sm",
                          "element" : "tag",
                          "listMode" : "last",
                          "variable" : "st"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tgt",
                          "element" : "performer",
                          "variable" : "tp",
                          "transform" : "create",
                          "parameter" : [
                            {
                              "valueString" : "Reference"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "TransformAssigner",
                          "parameter" : [
                            {
                              "valueId" : "st"
                            },
                            {
                              "valueId" : "tp"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "ObservationReferenceRange",
      "extends" : "BackboneElement",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "low",
          "source" : [
            {
              "context" : "src",
              "element" : "low",
              "variable" : "sl"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "low",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sl"
                }
              ]
            }
          ]
        },
        {
          "name" : "high",
          "source" : [
            {
              "context" : "src",
              "element" : "high",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "high",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "type",
          "source" : [
            {
              "context" : "src",
              "element" : "type",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "type",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "appliesTo",
          "source" : [
            {
              "context" : "src",
              "element" : "appliesTo",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "appliesTo",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "age",
          "source" : [
            {
              "context" : "src",
              "element" : "age",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "age",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "ObservationComponent",
      "extends" : "BackboneElement",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "valueQuantity",
          "source" : [
            {
              "context" : "src",
              "type" : "Quantity",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueCodeableConcept",
          "source" : [
            {
              "context" : "src",
              "type" : "CodeableConcept",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueString",
          "source" : [
            {
              "context" : "src",
              "type" : "string",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueBoolean",
          "source" : [
            {
              "context" : "src",
              "type" : "boolean",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueInteger",
          "source" : [
            {
              "context" : "src",
              "type" : "integer",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueRange",
          "source" : [
            {
              "context" : "src",
              "type" : "Range",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueRatio",
          "source" : [
            {
              "context" : "src",
              "type" : "Ratio",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueSampledData",
          "source" : [
            {
              "context" : "src",
              "type" : "SampledData",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueTime",
          "source" : [
            {
              "context" : "src",
              "type" : "time",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valueDateTime",
          "source" : [
            {
              "context" : "src",
              "type" : "dateTime",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "valuePeriod",
          "source" : [
            {
              "context" : "src",
              "type" : "Period",
              "element" : "value",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "value",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "dataAbsentReason",
          "source" : [
            {
              "context" : "src",
              "element" : "dataAbsentReason",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "dataAbsentReason",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "interpretation",
          "source" : [
            {
              "context" : "src",
              "element" : "interpretation",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "interpretation",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "referenceRange",
          "source" : [
            {
              "context" : "src",
              "element" : "referenceRange",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "referenceRange",
              "variable" : "t"
            }
          ],
          "dependent" : [
            {
              "name" : "ObservationReferenceRange",
              "parameter" : [
                {
                  "valueId" : "s"
                },
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "Organization/"
                },
                {
                  "valueId" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
