# MedicationRequest Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Transforms: R4 → SGHI R5**

## StructureMap: MedicationRequest Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/MedicationRequestSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:MedicationRequestSGHI5 |

 
MedicationRequestTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "MedicationRequestSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/MedicationRequestSGHI5",
  "version" : "0.1.0",
  "name" : "MedicationRequestSGHI5",
  "title" : "MedicationRequest Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "MedicationRequestTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/MedicationRequest",
      "mode" : "source",
      "alias" : "MedicationRequestR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/medicationrequest",
      "mode" : "target",
      "alias" : "SGHIMedicationRequest"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIMedicationRequest",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "MedicationRequestR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIMedicationRequest",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "uuid"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "uuid"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "addtometa",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "addprofile",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/medicationrequest"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src",
              "condition" : "text.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "t_text",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting text",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "ttt",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "src",
                  "element" : "text",
                  "variable" : "st"
                }
              ],
              "rule" : [
                {
                  "name" : "status",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "status",
                      "variable" : "s"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "status",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueId" : "s"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "wraptextinhtml",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "div",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "div",
                      "transform" : "evaluate",
                      "parameter" : [
                        {
                          "valueString" : "'<div xmlns=\\\"http://www.w3.org/1999/xhtml\\\"><p>' + d + '</p></div>'"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "addfhirididentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_ident",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "copyid",
              "source" : [
                {
                  "context" : "s_id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setuse",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setsystem",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "inittype",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "type",
                  "variable" : "t_type",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "initcoding",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_type",
                      "element" : "coding",
                      "variable" : "t_code",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "typesystem",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typecode",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typedisplay",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting owner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_ident",
                      "element" : "assigner",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "status",
          "source" : [
            {
              "context" : "src",
              "element" : "status",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "intent",
          "source" : [
            {
              "context" : "src",
              "element" : "intent",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "intent",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "priority",
          "source" : [
            {
              "context" : "src",
              "element" : "priority",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "priority",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "authoredOn",
          "source" : [
            {
              "context" : "src",
              "element" : "authoredOn",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "authoredOn",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "medication",
          "source" : [
            {
              "context" : "src",
              "element" : "medication",
              "variable" : "sm"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "medication",
              "variable" : "tm",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableReference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "set reference",
              "source" : [
                {
                  "context" : "src",
                  "condition" : "reference.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "tm",
                  "element" : "reference",
                  "variable" : "trf",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "text",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "text",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "trf",
                      "element" : "display",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "dummy reference",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "text",
                      "variable" : "txt"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "trf",
                      "element" : "reference",
                      "transform" : "append",
                      "parameter" : [
                        {
                          "valueString" : "Medication/"
                        },
                        {
                          "valueId" : "txt"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "sb"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "subject",
              "variable" : "tb"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sb"
                },
                {
                  "valueId" : "tb"
                }
              ]
            }
          ]
        },
        {
          "name" : "encounter",
          "source" : [
            {
              "context" : "src",
              "element" : "encounter",
              "variable" : "se"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "encounter",
              "variable" : "te"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "se"
                },
                {
                  "valueId" : "te"
                }
              ]
            }
          ]
        },
        {
          "name" : "requester",
          "source" : [
            {
              "context" : "src",
              "element" : "requester",
              "variable" : "sr"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "requester",
              "variable" : "tr"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sr"
                },
                {
                  "valueId" : "tr"
                }
              ]
            }
          ]
        },
        {
          "name" : "category",
          "source" : [
            {
              "context" : "src",
              "element" : "category",
              "variable" : "sg"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "category",
              "variable" : "tg"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "sc"
                    },
                    {
                      "valueId" : "tc"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "note",
          "source" : [
            {
              "context" : "src",
              "element" : "note",
              "variable" : "sn"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "note",
              "variable" : "tn"
            }
          ],
          "rule" : [
            {
              "name" : "time",
              "source" : [
                {
                  "context" : "sn",
                  "element" : "time",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tn",
                  "element" : "time",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sn",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tn",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "dosageInstruction",
          "source" : [
            {
              "context" : "src",
              "element" : "dosageInstruction",
              "variable" : "sd"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "dosageInstruction",
              "variable" : "td"
            }
          ],
          "rule" : [
            {
              "name" : "asNeeded",
              "source" : [
                {
                  "context" : "sd",
                  "element" : "asNeeded",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "td",
                  "element" : "asNeeded",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "doseAndRate",
              "source" : [
                {
                  "context" : "sd",
                  "element" : "doseAndRate",
                  "variable" : "sd"
                }
              ],
              "target" : [
                {
                  "context" : "td",
                  "element" : "doseAndRate",
                  "variable" : "td"
                }
              ],
              "rule" : [
                {
                  "name" : "doseQuantity",
                  "source" : [
                    {
                      "context" : "sd",
                      "element" : "doseQuantity",
                      "variable" : "sq"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "td",
                      "element" : "doseQuantity",
                      "variable" : "tq"
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "code",
                      "source" : [
                        {
                          "context" : "sq",
                          "element" : "code",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tq",
                          "element" : "code",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "system",
                      "source" : [
                        {
                          "context" : "sq",
                          "element" : "system",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tq",
                          "element" : "system",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "unit",
                      "source" : [
                        {
                          "context" : "sq",
                          "element" : "unit",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tq",
                          "element" : "unit",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "value",
                      "source" : [
                        {
                          "context" : "sq",
                          "element" : "value",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tq",
                          "element" : "value",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "patientInstruction",
              "source" : [
                {
                  "context" : "sd",
                  "element" : "patientInstruction",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "td",
                  "element" : "patientInstruction",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "route",
              "source" : [
                {
                  "context" : "sd",
                  "element" : "route",
                  "variable" : "sr"
                }
              ],
              "target" : [
                {
                  "context" : "td",
                  "element" : "route",
                  "variable" : "tr"
                }
              ],
              "rule" : [
                {
                  "name" : "coding",
                  "source" : [
                    {
                      "context" : "sr",
                      "element" : "coding",
                      "variable" : "sc"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tr",
                      "element" : "coding",
                      "variable" : "tc"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformCoding",
                      "parameter" : [
                        {
                          "valueId" : "sc"
                        },
                        {
                          "valueId" : "tc"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "setting default route",
                  "source" : [
                    {
                      "context" : "sr",
                      "condition" : "coding.exists().not()"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tr",
                      "element" : "coding",
                      "variable" : "tc",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "iv"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "Intravenous"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "text",
                  "source" : [
                    {
                      "context" : "sr",
                      "element" : "text",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tr",
                      "element" : "text",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "timing",
              "source" : [
                {
                  "context" : "sd",
                  "element" : "timing",
                  "variable" : "st"
                }
              ],
              "target" : [
                {
                  "context" : "td",
                  "element" : "timing",
                  "variable" : "tt"
                }
              ],
              "rule" : [
                {
                  "name" : "repeat",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "repeat",
                      "variable" : "sp"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tt",
                      "element" : "repeat",
                      "variable" : "tp"
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "boundsPeriod",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "boundsPeriod",
                          "variable" : "sprd"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tp",
                          "element" : "boundsPeriod",
                          "variable" : "tprd"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "end",
                          "source" : [
                            {
                              "context" : "sprd",
                              "element" : "end",
                              "variable" : "vvv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "tprd",
                              "element" : "end",
                              "variable" : "vvv",
                              "transform" : "create"
                            }
                          ],
                          "dependent" : [
                            {
                              "name" : "DefaultMappingGroupAnonymousAlias",
                              "parameter" : [
                                {
                                  "valueId" : "vvv"
                                },
                                {
                                  "valueId" : "vvv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "start",
                          "source" : [
                            {
                              "context" : "sprd",
                              "element" : "start",
                              "variable" : "vvv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "tprd",
                              "element" : "start",
                              "variable" : "vvv",
                              "transform" : "create"
                            }
                          ],
                          "dependent" : [
                            {
                              "name" : "DefaultMappingGroupAnonymousAlias",
                              "parameter" : [
                                {
                                  "valueId" : "vvv"
                                },
                                {
                                  "valueId" : "vvv"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "duration",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "duration",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tp",
                          "element" : "duration",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "durationUnit",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "durationUnit",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tp",
                          "element" : "durationUnit",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "frequency",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "frequency",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tp",
                          "element" : "frequency",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "period",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "period",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tp",
                          "element" : "period",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "periodUnit",
                      "source" : [
                        {
                          "context" : "sp",
                          "element" : "periodUnit",
                          "variable" : "vvv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tp",
                          "element" : "periodUnit",
                          "variable" : "vvv",
                          "transform" : "create"
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "DefaultMappingGroupAnonymousAlias",
                          "parameter" : [
                            {
                              "valueId" : "vvv"
                            },
                            {
                              "valueId" : "vvv"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "Organization/"
                },
                {
                  "valueId" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformCoding",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "settingdefaultdisplay",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
