# Glasgow Coma Scale Extraction - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Glasgow Coma Scale Extraction**

## StructureMap: Glasgow Coma Scale Extraction (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/GlasgowCommaScaleExtract | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:GlasgowCommaScaleExtract |

 
Extracts three Observation resources, one per GCS subscore, from a QuestionnaireResponse to the GCS questionnaire. 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "GlasgowCommaScaleExtract",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/GlasgowCommaScaleExtract",
  "version" : "0.1.0",
  "name" : "GlasgowCommaScaleExtract",
  "title" : "Glasgow Coma Scale Extraction",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Extracts three Observation resources, one per GCS subscore, from a QuestionnaireResponse to the GCS questionnaire.",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
      "mode" : "source",
      "alias" : "QR"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/Bundle",
      "mode" : "target",
      "alias" : "Bundle"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/Observation",
      "mode" : "target",
      "alias" : "Observation"
    }
  ],
  "group" : [
    {
      "name" : "GlasgowCommaScaleExtract",
      "input" : [
        {
          "name" : "qr",
          "type" : "QR",
          "mode" : "source"
        },
        {
          "name" : "bundle",
          "type" : "Bundle",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "setBundleType",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "element" : "type",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "transaction"
                }
              ]
            }
          ]
        },
        {
          "name" : "verbalResponseObs",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itV",
              "condition" : "linkId = 'verbal-response'"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "element" : "entry",
              "variable" : "eV"
            },
            {
              "context" : "eV",
              "element" : "resource",
              "variable" : "oV",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Observation"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "baseV",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oV",
                  "element" : "id"
                }
              ],
              "dependent" : [
                {
                  "name" : "BuildBaseObs",
                  "parameter" : [
                    {
                      "valueId" : "qr"
                    },
                    {
                      "valueId" : "oV"
                    },
                    {
                      "valueId" : "eV"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "catVSystem",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oV",
                  "element" : "category",
                  "transform" : "cc",
                  "parameter" : [
                    {
                      "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                    },
                    {
                      "valueString" : "survey"
                    },
                    {
                      "valueString" : "Survey"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "codeVCode",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oV",
                  "element" : "code",
                  "transform" : "cc",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    },
                    {
                      "valueString" : "9270-0"
                    },
                    {
                      "valueString" : "Glasgow coma score verbal"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valV",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oV",
                  "element" : "id"
                }
              ],
              "dependent" : [
                {
                  "name" : "SetValueFromItem",
                  "parameter" : [
                    {
                      "valueId" : "itV"
                    },
                    {
                      "valueId" : "oV"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Verbal"
        },
        {
          "name" : "motorResponseObs",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itM",
              "condition" : "linkId = 'motor-response'"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "element" : "entry",
              "variable" : "eM"
            },
            {
              "context" : "eM",
              "element" : "resource",
              "variable" : "oM",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Observation"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "baseM",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oM",
                  "element" : "id"
                }
              ],
              "dependent" : [
                {
                  "name" : "BuildBaseObs",
                  "parameter" : [
                    {
                      "valueId" : "qr"
                    },
                    {
                      "valueId" : "oM"
                    },
                    {
                      "valueId" : "eM"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "catMSystem",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oM",
                  "element" : "category",
                  "transform" : "cc",
                  "parameter" : [
                    {
                      "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                    },
                    {
                      "valueString" : "survey"
                    },
                    {
                      "valueString" : "Survey"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "catMCode",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oM",
                  "element" : "code",
                  "transform" : "cc",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    },
                    {
                      "valueString" : "9268-4"
                    },
                    {
                      "valueString" : "Glasgow coma score motor"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valM",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oM",
                  "element" : "id"
                }
              ],
              "dependent" : [
                {
                  "name" : "SetValueFromItem",
                  "parameter" : [
                    {
                      "valueId" : "itM"
                    },
                    {
                      "valueId" : "oM"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Motor"
        },
        {
          "name" : "eyeResponseObs",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itE",
              "condition" : "linkId = 'eye-opening'"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "element" : "entry",
              "variable" : "eE"
            },
            {
              "context" : "eE",
              "element" : "resource",
              "variable" : "oE",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Observation"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "baseE",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oE",
                  "element" : "id"
                }
              ],
              "dependent" : [
                {
                  "name" : "BuildBaseObs",
                  "parameter" : [
                    {
                      "valueId" : "qr"
                    },
                    {
                      "valueId" : "oE"
                    },
                    {
                      "valueId" : "eE"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "catESystem",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oE",
                  "element" : "category",
                  "transform" : "cc",
                  "parameter" : [
                    {
                      "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                    },
                    {
                      "valueString" : "survey"
                    },
                    {
                      "valueString" : "Survey"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "catECode",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oE",
                  "element" : "code",
                  "transform" : "cc",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    },
                    {
                      "valueString" : "9267-6"
                    },
                    {
                      "valueString" : "Glasgow coma score eye opening"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "valE",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "oE",
                  "element" : "id"
                }
              ],
              "dependent" : [
                {
                  "name" : "SetValueFromItem",
                  "parameter" : [
                    {
                      "valueId" : "itE"
                    },
                    {
                      "valueId" : "oE"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Eye"
        }
      ]
    },
    {
      "name" : "BuildBaseObs",
      "input" : [
        {
          "name" : "qr",
          "type" : "QR",
          "mode" : "source"
        },
        {
          "name" : "obs",
          "type" : "Observation",
          "mode" : "target"
        },
        {
          "name" : "entry",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "entryRequest",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "entry",
              "element" : "request",
              "variable" : "req"
            }
          ],
          "rule" : [
            {
              "name" : "reqMethod",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "req",
                  "element" : "method",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "POST"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "reqUrl",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "req",
                  "element" : "url",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Observation"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setIdAndFullUrl",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "id",
              "transform" : "uuid"
            }
          ],
          "dependent" : [
            {
              "name" : "SetFullUrl",
              "parameter" : [
                {
                  "valueId" : "obs"
                },
                {
                  "valueId" : "entry"
                }
              ]
            }
          ]
        },
        {
          "name" : "setStatus",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "status",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "final"
                }
              ]
            }
          ]
        },
        {
          "name" : "setSubject",
          "source" : [
            {
              "context" : "qr",
              "element" : "subject",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "subject",
              "variable" : "r",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "subRef",
              "source" : [
                {
                  "context" : "s",
                  "element" : "reference",
                  "variable" : "ref"
                }
              ],
              "target" : [
                {
                  "context" : "r",
                  "element" : "reference",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "ref"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "subDisp",
              "source" : [
                {
                  "context" : "s",
                  "element" : "display",
                  "variable" : "disp"
                }
              ],
              "target" : [
                {
                  "context" : "r",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "disp"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setEffective",
          "source" : [
            {
              "context" : "qr",
              "element" : "authored",
              "variable" : "t"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "effective",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "setIssued",
          "source" : [
            {
              "context" : "qr",
              "element" : "authored",
              "variable" : "t"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "issued",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "setDerivedFrom",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "derivedFrom",
              "variable" : "dr",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "derRef",
              "source" : [
                {
                  "context" : "qr",
                  "element" : "id",
                  "variable" : "id"
                }
              ],
              "target" : [
                {
                  "context" : "dr",
                  "element" : "reference",
                  "transform" : "append",
                  "parameter" : [
                    {
                      "valueString" : "QuestionnaireResponse/"
                    },
                    {
                      "valueId" : "id"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SetValueFromItem",
      "input" : [
        {
          "name" : "it",
          "type" : "Element",
          "mode" : "source"
        },
        {
          "name" : "obs",
          "type" : "Observation",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "setValueCC",
          "source" : [
            {
              "context" : "it",
              "element" : "answer",
              "variable" : "a"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "value",
              "variable" : "c",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableConcept"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "copyCoding",
              "source" : [
                {
                  "context" : "a",
                  "element" : "value",
                  "variable" : "coding"
                }
              ],
              "target" : [
                {
                  "context" : "c",
                  "element" : "coding",
                  "variable" : "nc",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "coding"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SetFullUrl",
      "input" : [
        {
          "name" : "obs",
          "type" : "Observation",
          "mode" : "source"
        },
        {
          "name" : "entry",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "assignFullUrl",
          "source" : [
            {
              "context" : "obs",
              "element" : "id",
              "variable" : "id"
            }
          ],
          "target" : [
            {
              "context" : "entry",
              "element" : "fullUrl",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "https://fhir.slade360.co.ke/fhir/Observation/"
                },
                {
                  "valueId" : "id"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
