# ExtractVitalSigns - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtractVitalSigns**

## StructureMap: ExtractVitalSigns 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/ExtractVitalSigns | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:ExtractVitalSigns |



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "ExtractVitalSigns",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/ExtractVitalSigns",
  "version" : "0.1.0",
  "name" : "ExtractVitalSigns",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
      "mode" : "source",
      "alias" : "QR"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/Bundle",
      "mode" : "target",
      "alias" : "Bundle"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/Observation",
      "mode" : "target",
      "alias" : "Observation"
    }
  ],
  "group" : [
    {
      "name" : "ExtractVitalSigns",
      "input" : [
        {
          "name" : "qr",
          "type" : "QR",
          "mode" : "source"
        },
        {
          "name" : "bundle",
          "type" : "Bundle",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "setBundleType",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "element" : "type",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "transaction"
                }
              ]
            }
          ]
        },
        {
          "name" : "heightRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itH",
              "condition" : "(linkId = '8302-2')"
            }
          ],
          "rule" : [
            {
              "name" : "heightAns",
              "source" : [
                {
                  "context" : "itH",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aH"
                }
              ],
              "rule" : [
                {
                  "name" : "heightObs",
                  "source" : [
                    {
                      "context" : "aH"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eH"
                    },
                    {
                      "context" : "eH",
                      "element" : "resource",
                      "variable" : "oH",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "heightBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oH"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eH"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oH"
                            },
                            {
                              "valueId" : "eH"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeH",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oH",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "8302-2"
                            },
                            {
                              "valueString" : "Body Height"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "valH",
                      "source" : [
                        {
                          "context" : "aH",
                          "element" : "value",
                          "variable" : "hv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oH",
                          "element" : "valueQuantity",
                          "variable" : "vH"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setVal",
                          "source" : [
                            {
                              "context" : "hv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vH",
                              "element" : "value",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueId" : "hv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setSys",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vH",
                              "element" : "system",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "http://unitsofmeasure.org"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setCode",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vH",
                              "element" : "code",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "cm"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setUnit",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vH",
                              "element" : "unit",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "centimeter"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Height"
        },
        {
          "name" : "weightRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itW",
              "condition" : "(linkId = '29463-7')"
            }
          ],
          "rule" : [
            {
              "name" : "weightAns",
              "source" : [
                {
                  "context" : "itW",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aW"
                }
              ],
              "rule" : [
                {
                  "name" : "weightObs",
                  "source" : [
                    {
                      "context" : "aW"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eW"
                    },
                    {
                      "context" : "eW",
                      "element" : "resource",
                      "variable" : "oW",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "weightBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oW"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eW"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oW"
                            },
                            {
                              "valueId" : "eW"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeW",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oW",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "29463-7"
                            },
                            {
                              "valueString" : "Body Weight"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "valW",
                      "source" : [
                        {
                          "context" : "aW",
                          "element" : "value",
                          "variable" : "hv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oW",
                          "element" : "valueQuantity",
                          "variable" : "vW"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setVal",
                          "source" : [
                            {
                              "context" : "hv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vW",
                              "element" : "value",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueId" : "hv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setSys",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vW",
                              "element" : "system",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "http://unitsofmeasure.org"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setCode",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vW",
                              "element" : "code",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "kg"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setUnit",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vW",
                              "element" : "unit",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "kilogram"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Weight"
        },
        {
          "name" : "bmiRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itBmi",
              "condition" : "(linkId = '39156-5')"
            }
          ],
          "rule" : [
            {
              "name" : "bmiAns",
              "source" : [
                {
                  "context" : "itBmi",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aBmi"
                }
              ],
              "rule" : [
                {
                  "name" : "bmiObs",
                  "source" : [
                    {
                      "context" : "aBmi"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eBmi"
                    },
                    {
                      "context" : "eBmi",
                      "element" : "resource",
                      "variable" : "oBmi",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "bmiBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oBmi"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eBmi"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oBmi"
                            },
                            {
                              "valueId" : "eBmi"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeBmi",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oBmi",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "39156-5"
                            },
                            {
                              "valueString" : "Body mass index (BMI) [Ratio]"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "valBmi",
                      "source" : [
                        {
                          "context" : "aBmi",
                          "element" : "value",
                          "variable" : "hv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oBmi",
                          "element" : "valueQuantity",
                          "variable" : "vBmi"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setVal",
                          "source" : [
                            {
                              "context" : "hv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vBmi",
                              "element" : "value",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueId" : "hv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setSys",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vBmi",
                              "element" : "system",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "http://unitsofmeasure.org"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setCode",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vBmi",
                              "element" : "code",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "kg/m2"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setUnit",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vBmi",
                              "element" : "unit",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "kilogram per square meter"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "findBmiStatus",
                      "source" : [
                        {
                          "context" : "itBmi",
                          "element" : "item",
                          "variable" : "bmiStatusItem",
                          "condition" : "(linkId = '39156-5_status')"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setInterpBmi",
                          "source" : [
                            {
                              "context" : "bmiStatusItem",
                              "element" : "answer",
                              "listMode" : "first",
                              "variable" : "bmiStatusAns"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "oBmi",
                              "element" : "interpretation",
                              "variable" : "iBmi"
                            }
                          ],
                          "rule" : [
                            {
                              "name" : "interpBmi",
                              "source" : [
                                {
                                  "context" : "bmiStatusAns",
                                  "element" : "value",
                                  "variable" : "statusText"
                                }
                              ],
                              "target" : [
                                {
                                  "context" : "iBmi",
                                  "element" : "text",
                                  "transform" : "copy",
                                  "parameter" : [
                                    {
                                      "valueId" : "statusText"
                                    }
                                  ]
                                }
                              ]
                            }
                          ]
                        }
                      ],
                      "documentation" : "Interpretation 39156-5_status"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "BMI"
        },
        {
          "name" : "pulseRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itP",
              "condition" : "(linkId = '8889-8')"
            }
          ],
          "rule" : [
            {
              "name" : "pulseAns",
              "source" : [
                {
                  "context" : "itP",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aP"
                }
              ],
              "rule" : [
                {
                  "name" : "pulseObs",
                  "source" : [
                    {
                      "context" : "aP"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eP"
                    },
                    {
                      "context" : "eP",
                      "element" : "resource",
                      "variable" : "oP",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "pulseBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oP"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eP"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oP"
                            },
                            {
                              "valueId" : "eP"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeP",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oP",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "8889-8"
                            },
                            {
                              "valueString" : "Heart rate by Pulse oximetry"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "valP",
                      "source" : [
                        {
                          "context" : "aP",
                          "element" : "value",
                          "variable" : "hv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oP",
                          "element" : "valueQuantity",
                          "variable" : "vP"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setVal",
                          "source" : [
                            {
                              "context" : "hv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vP",
                              "element" : "value",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueId" : "hv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setSys",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vP",
                              "element" : "system",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "http://unitsofmeasure.org"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setCode",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vP",
                              "element" : "code",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "/min"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setUnit",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vP",
                              "element" : "unit",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "per minute"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Pulse"
        },
        {
          "name" : "bpRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itBP",
              "condition" : "(linkId = '55284-4')"
            }
          ],
          "rule" : [
            {
              "name" : "bpAns",
              "source" : [
                {
                  "context" : "itBP",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aPanel"
                }
              ],
              "rule" : [
                {
                  "name" : "bpObs",
                  "source" : [
                    {
                      "context" : "aPanel"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eBP"
                    },
                    {
                      "context" : "eBP",
                      "element" : "resource",
                      "variable" : "oBP",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "bpBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oBP"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eBP"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oBP"
                            },
                            {
                              "valueId" : "eBP"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeBP",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oBP",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "55284-4"
                            },
                            {
                              "valueString" : "Blood pressure systolic and diastolic"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "bpSysRule",
                      "source" : [
                        {
                          "context" : "itBP",
                          "element" : "item",
                          "variable" : "itSys",
                          "condition" : "(linkId = '8480-6')"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "bpSysComponent",
                          "source" : [
                            {
                              "context" : "itSys",
                              "element" : "answer",
                              "listMode" : "first",
                              "variable" : "aSys"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "oBP",
                              "element" : "component",
                              "variable" : "cSys"
                            }
                          ],
                          "rule" : [
                            {
                              "name" : "bpSysCode",
                              "source" : [
                                {
                                  "context" : "aSys"
                                }
                              ],
                              "target" : [
                                {
                                  "context" : "cSys",
                                  "element" : "code",
                                  "transform" : "cc",
                                  "parameter" : [
                                    {
                                      "valueString" : "http://loinc.org"
                                    },
                                    {
                                      "valueString" : "8480-6"
                                    },
                                    {
                                      "valueString" : "Systolic blood pressure"
                                    }
                                  ]
                                }
                              ]
                            },
                            {
                              "name" : "bpSysVal",
                              "source" : [
                                {
                                  "context" : "aSys",
                                  "element" : "value",
                                  "variable" : "hv"
                                }
                              ],
                              "target" : [
                                {
                                  "context" : "cSys",
                                  "element" : "valueQuantity",
                                  "variable" : "vSys"
                                }
                              ],
                              "rule" : [
                                {
                                  "name" : "setVal",
                                  "source" : [
                                    {
                                      "context" : "hv"
                                    }
                                  ],
                                  "target" : [
                                    {
                                      "context" : "vSys",
                                      "element" : "value",
                                      "transform" : "copy",
                                      "parameter" : [
                                        {
                                          "valueId" : "hv"
                                        }
                                      ]
                                    }
                                  ]
                                },
                                {
                                  "name" : "setSys",
                                  "source" : [
                                    {
                                      "context" : "qr"
                                    }
                                  ],
                                  "target" : [
                                    {
                                      "context" : "vSys",
                                      "element" : "system",
                                      "transform" : "copy",
                                      "parameter" : [
                                        {
                                          "valueString" : "http://unitsofmeasure.org"
                                        }
                                      ]
                                    }
                                  ]
                                },
                                {
                                  "name" : "setCode",
                                  "source" : [
                                    {
                                      "context" : "qr"
                                    }
                                  ],
                                  "target" : [
                                    {
                                      "context" : "vSys",
                                      "element" : "code",
                                      "transform" : "copy",
                                      "parameter" : [
                                        {
                                          "valueString" : "mm[Hg]"
                                        }
                                      ]
                                    }
                                  ]
                                },
                                {
                                  "name" : "setUnit",
                                  "source" : [
                                    {
                                      "context" : "qr"
                                    }
                                  ],
                                  "target" : [
                                    {
                                      "context" : "vSys",
                                      "element" : "unit",
                                      "transform" : "copy",
                                      "parameter" : [
                                        {
                                          "valueString" : "millimeter of mercury"
                                        }
                                      ]
                                    }
                                  ]
                                }
                              ]
                            }
                          ]
                        }
                      ],
                      "documentation" : "Systolic 8480-6"
                    },
                    {
                      "name" : "bpDiaRule",
                      "source" : [
                        {
                          "context" : "itBP",
                          "element" : "item",
                          "variable" : "itDia",
                          "condition" : "(linkId = '8462-4')"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "bpDiaComponent",
                          "source" : [
                            {
                              "context" : "itDia",
                              "element" : "answer",
                              "listMode" : "first",
                              "variable" : "aDia"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "oBP",
                              "element" : "component",
                              "variable" : "cDia"
                            }
                          ],
                          "rule" : [
                            {
                              "name" : "bpDiaCode",
                              "source" : [
                                {
                                  "context" : "aDia"
                                }
                              ],
                              "target" : [
                                {
                                  "context" : "cDia",
                                  "element" : "code",
                                  "transform" : "cc",
                                  "parameter" : [
                                    {
                                      "valueString" : "http://loinc.org"
                                    },
                                    {
                                      "valueString" : "8462-4"
                                    },
                                    {
                                      "valueString" : "Diastolic blood pressure"
                                    }
                                  ]
                                }
                              ]
                            },
                            {
                              "name" : "bpDiaVal",
                              "source" : [
                                {
                                  "context" : "aDia",
                                  "element" : "value",
                                  "variable" : "hv"
                                }
                              ],
                              "target" : [
                                {
                                  "context" : "cDia",
                                  "element" : "valueQuantity",
                                  "variable" : "vDia"
                                }
                              ],
                              "rule" : [
                                {
                                  "name" : "setVal",
                                  "source" : [
                                    {
                                      "context" : "hv"
                                    }
                                  ],
                                  "target" : [
                                    {
                                      "context" : "vDia",
                                      "element" : "value",
                                      "transform" : "copy",
                                      "parameter" : [
                                        {
                                          "valueId" : "hv"
                                        }
                                      ]
                                    }
                                  ]
                                },
                                {
                                  "name" : "setSys",
                                  "source" : [
                                    {
                                      "context" : "qr"
                                    }
                                  ],
                                  "target" : [
                                    {
                                      "context" : "vDia",
                                      "element" : "system",
                                      "transform" : "copy",
                                      "parameter" : [
                                        {
                                          "valueString" : "http://unitsofmeasure.org"
                                        }
                                      ]
                                    }
                                  ]
                                },
                                {
                                  "name" : "setCode",
                                  "source" : [
                                    {
                                      "context" : "qr"
                                    }
                                  ],
                                  "target" : [
                                    {
                                      "context" : "vDia",
                                      "element" : "code",
                                      "transform" : "copy",
                                      "parameter" : [
                                        {
                                          "valueString" : "mm[Hg]"
                                        }
                                      ]
                                    }
                                  ]
                                },
                                {
                                  "name" : "setUnit",
                                  "source" : [
                                    {
                                      "context" : "qr"
                                    }
                                  ],
                                  "target" : [
                                    {
                                      "context" : "vDia",
                                      "element" : "unit",
                                      "transform" : "copy",
                                      "parameter" : [
                                        {
                                          "valueString" : "millimeter of mercury"
                                        }
                                      ]
                                    }
                                  ]
                                }
                              ]
                            }
                          ]
                        }
                      ],
                      "documentation" : "Diastolic 8462-4"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Blood Pressure"
        },
        {
          "name" : "tempRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itT",
              "condition" : "(linkId = '8310-5')"
            }
          ],
          "rule" : [
            {
              "name" : "tempAns",
              "source" : [
                {
                  "context" : "itT",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aT"
                }
              ],
              "rule" : [
                {
                  "name" : "tempObs",
                  "source" : [
                    {
                      "context" : "aT"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eT"
                    },
                    {
                      "context" : "eT",
                      "element" : "resource",
                      "variable" : "oT",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "tempBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oT"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eT"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oT"
                            },
                            {
                              "valueId" : "eT"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeT",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oT",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "8310-5"
                            },
                            {
                              "valueString" : "Body Temperature"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "valT",
                      "source" : [
                        {
                          "context" : "aT",
                          "element" : "value",
                          "variable" : "hv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oT",
                          "element" : "valueQuantity",
                          "variable" : "vT"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setVal",
                          "source" : [
                            {
                              "context" : "hv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vT",
                              "element" : "value",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueId" : "hv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setSys",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vT",
                              "element" : "system",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "http://unitsofmeasure.org"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setCode",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vT",
                              "element" : "code",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "Cel"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setUnit",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vT",
                              "element" : "unit",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "degree Celsius"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "findTStatus",
                      "source" : [
                        {
                          "context" : "itT",
                          "element" : "item",
                          "variable" : "tStatusItem",
                          "condition" : "(linkId = '8310-5_status')"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setInterpT",
                          "source" : [
                            {
                              "context" : "tStatusItem",
                              "element" : "answer",
                              "listMode" : "first",
                              "variable" : "tStatusAns"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "oT",
                              "element" : "interpretation",
                              "variable" : "iT"
                            }
                          ],
                          "rule" : [
                            {
                              "name" : "interpT",
                              "source" : [
                                {
                                  "context" : "tStatusAns",
                                  "element" : "value",
                                  "variable" : "statusText"
                                }
                              ],
                              "target" : [
                                {
                                  "context" : "iT",
                                  "element" : "text",
                                  "transform" : "copy",
                                  "parameter" : [
                                    {
                                      "valueId" : "statusText"
                                    }
                                  ]
                                }
                              ]
                            }
                          ]
                        }
                      ],
                      "documentation" : "Interpretation 8310-5_status"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Temperature"
        },
        {
          "name" : "spo2Rule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itO2",
              "condition" : "(linkId = '20564-1')"
            }
          ],
          "rule" : [
            {
              "name" : "spo2Ans",
              "source" : [
                {
                  "context" : "itO2",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aO2"
                }
              ],
              "rule" : [
                {
                  "name" : "spo2Obs",
                  "source" : [
                    {
                      "context" : "aO2"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eO2"
                    },
                    {
                      "context" : "eO2",
                      "element" : "resource",
                      "variable" : "oO2",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "spo2Base",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oO2"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eO2"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oO2"
                            },
                            {
                              "valueId" : "eO2"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeO2",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oO2",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "20564-1"
                            },
                            {
                              "valueString" : "Oxygen saturation in Blood"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "valO2",
                      "source" : [
                        {
                          "context" : "aO2",
                          "element" : "value",
                          "variable" : "hv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oO2",
                          "element" : "valueQuantity",
                          "variable" : "vO2"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setVal",
                          "source" : [
                            {
                              "context" : "hv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vO2",
                              "element" : "value",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueId" : "hv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setSys",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vO2",
                              "element" : "system",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "http://unitsofmeasure.org"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setCode",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vO2",
                              "element" : "code",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "%"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setUnit",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vO2",
                              "element" : "unit",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "%"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "findO2Status",
                      "source" : [
                        {
                          "context" : "itO2",
                          "element" : "item",
                          "variable" : "o2StatusItem",
                          "condition" : "(linkId = '20564-1_status')"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setInterpO2",
                          "source" : [
                            {
                              "context" : "o2StatusItem",
                              "element" : "answer",
                              "listMode" : "first",
                              "variable" : "o2StatusAns"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "oO2",
                              "element" : "interpretation",
                              "variable" : "iO2"
                            }
                          ],
                          "rule" : [
                            {
                              "name" : "interpO2",
                              "source" : [
                                {
                                  "context" : "o2StatusAns",
                                  "element" : "value",
                                  "variable" : "statusText"
                                }
                              ],
                              "target" : [
                                {
                                  "context" : "iO2",
                                  "element" : "text",
                                  "transform" : "copy",
                                  "parameter" : [
                                    {
                                      "valueId" : "statusText"
                                    }
                                  ]
                                }
                              ]
                            }
                          ]
                        }
                      ],
                      "documentation" : "Interpretation of SpO2 20564-1_status"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "SpO2"
        },
        {
          "name" : "rrRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itRR",
              "condition" : "(linkId = '9279-1')"
            }
          ],
          "rule" : [
            {
              "name" : "rrAns",
              "source" : [
                {
                  "context" : "itRR",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aRR"
                }
              ],
              "rule" : [
                {
                  "name" : "rrObs",
                  "source" : [
                    {
                      "context" : "aRR"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eRR"
                    },
                    {
                      "context" : "eRR",
                      "element" : "resource",
                      "variable" : "oRR",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "rrBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oRR"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eRR"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oRR"
                            },
                            {
                              "valueId" : "eRR"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeRR",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oRR",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "9279-1"
                            },
                            {
                              "valueString" : "Respiratory rate"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "valRR",
                      "source" : [
                        {
                          "context" : "aRR",
                          "element" : "value",
                          "variable" : "hv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oRR",
                          "element" : "valueQuantity",
                          "variable" : "vRR"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setVal",
                          "source" : [
                            {
                              "context" : "hv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vRR",
                              "element" : "value",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueId" : "hv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setSys",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vRR",
                              "element" : "system",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "http://unitsofmeasure.org"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setCode",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vRR",
                              "element" : "code",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "/min"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setUnit",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vRR",
                              "element" : "unit",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "per minute"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Respiratory rate"
        },
        {
          "name" : "muacRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itMuac",
              "condition" : "(linkId = '9847-5')"
            }
          ],
          "rule" : [
            {
              "name" : "muacAns",
              "source" : [
                {
                  "context" : "itMuac",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aMuac"
                }
              ],
              "rule" : [
                {
                  "name" : "muacObs",
                  "source" : [
                    {
                      "context" : "aMuac"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eMuac"
                    },
                    {
                      "context" : "eMuac",
                      "element" : "resource",
                      "variable" : "oMuac",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "muacBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oMuac"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eMuac"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oMuac"
                            },
                            {
                              "valueId" : "eMuac"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "codeMuac",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oMuac",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "9847-5"
                            },
                            {
                              "valueString" : "Circumference"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "valMuac",
                      "source" : [
                        {
                          "context" : "aMuac",
                          "element" : "value",
                          "variable" : "hv"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oMuac",
                          "element" : "valueQuantity",
                          "variable" : "vMuac"
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "setVal",
                          "source" : [
                            {
                              "context" : "hv"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vMuac",
                              "element" : "value",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueId" : "hv"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setSys",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vMuac",
                              "element" : "system",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "http://unitsofmeasure.org"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setCode",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vMuac",
                              "element" : "code",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "mm"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "setUnit",
                          "source" : [
                            {
                              "context" : "qr"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "vMuac",
                              "element" : "unit",
                              "transform" : "copy",
                              "parameter" : [
                                {
                                  "valueString" : "millimeter"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "MUAC"
        },
        {
          "name" : "chiefComplaintRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "itCC",
              "condition" : "(linkId = '10154-3')"
            }
          ],
          "rule" : [
            {
              "name" : "chiefComplaintAns",
              "source" : [
                {
                  "context" : "itCC",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aCC"
                }
              ],
              "rule" : [
                {
                  "name" : "chiefComplaintObs",
                  "source" : [
                    {
                      "context" : "aCC"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eCC"
                    },
                    {
                      "context" : "eCC",
                      "element" : "resource",
                      "variable" : "oCC",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "chiefComplaintBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oCC"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eCC"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oCC"
                            },
                            {
                              "valueId" : "eCC"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "chiefComplaintCategory",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "category",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                            },
                            {
                              "valueString" : "social-history"
                            },
                            {
                              "valueString" : "Social History"
                            }
                          ]
                        }
                      ],
                      "documentation" : "Override category to social-history"
                    },
                    {
                      "name" : "chiefComplaintCode",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "10154-3"
                            },
                            {
                              "valueString" : "Chief complaint Narrative"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "chiefComplaintValue",
                      "source" : [
                        {
                          "context" : "aCC",
                          "element" : "value",
                          "variable" : "textVal"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "valueString",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "textVal"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Chief Complaint"
        },
        {
          "name" : "historyOfPIRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "hpiCC",
              "condition" : "(linkId = '8684-3')"
            }
          ],
          "rule" : [
            {
              "name" : "historyOfPIAns",
              "source" : [
                {
                  "context" : "hpiCC",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aCC"
                }
              ],
              "rule" : [
                {
                  "name" : "historyOfPIObs",
                  "source" : [
                    {
                      "context" : "aCC"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eCC"
                    },
                    {
                      "context" : "eCC",
                      "element" : "resource",
                      "variable" : "oCC",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "historyOfPIBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oCC"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eCC"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oCC"
                            },
                            {
                              "valueId" : "eCC"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "historyOfPICategory",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "category",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                            },
                            {
                              "valueString" : "social-history"
                            },
                            {
                              "valueString" : "Social History"
                            }
                          ]
                        }
                      ],
                      "documentation" : "Override category to social-history"
                    },
                    {
                      "name" : "historyOfPICode",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "8684-3"
                            },
                            {
                              "valueString" : "History of Present illness"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "historyOfPIValue",
                      "source" : [
                        {
                          "context" : "aCC",
                          "element" : "value",
                          "variable" : "textVal"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "valueString",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "textVal"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "History of Presenting Illness"
        },
        {
          "name" : "historyOfPastIRule",
          "source" : [
            {
              "context" : "qr",
              "element" : "item",
              "variable" : "hPastCC",
              "condition" : "(linkId = '11349-8')"
            }
          ],
          "rule" : [
            {
              "name" : "historyOfPastIAns",
              "source" : [
                {
                  "context" : "hPastCC",
                  "element" : "answer",
                  "listMode" : "first",
                  "variable" : "aCC"
                }
              ],
              "rule" : [
                {
                  "name" : "historyOfPastIObs",
                  "source" : [
                    {
                      "context" : "aCC"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "bundle",
                      "element" : "entry",
                      "variable" : "eCC"
                    },
                    {
                      "context" : "eCC",
                      "element" : "resource",
                      "variable" : "oCC",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Observation"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "historyOfPastIBase",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "oCC"
                            }
                          ]
                        },
                        {
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "eCC"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "BuildBaseObs",
                          "parameter" : [
                            {
                              "valueId" : "qr"
                            },
                            {
                              "valueId" : "oCC"
                            },
                            {
                              "valueId" : "eCC"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "historyOfPastICategory",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "category",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                            },
                            {
                              "valueString" : "social-history"
                            },
                            {
                              "valueString" : "Social History"
                            }
                          ]
                        }
                      ],
                      "documentation" : "Override category to social-history"
                    },
                    {
                      "name" : "historyOfPastICode",
                      "source" : [
                        {
                          "context" : "qr"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "code",
                          "transform" : "cc",
                          "parameter" : [
                            {
                              "valueString" : "http://loinc.org"
                            },
                            {
                              "valueString" : "11349-8"
                            },
                            {
                              "valueString" : "History of Past illness"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "historyOfPastIValue",
                      "source" : [
                        {
                          "context" : "aCC",
                          "element" : "value",
                          "variable" : "textVal"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "oCC",
                          "element" : "valueString",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueId" : "textVal"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "History of Past Illness"
        }
      ]
    },
    {
      "name" : "BuildBaseObs",
      "input" : [
        {
          "name" : "qr",
          "type" : "QR",
          "mode" : "source"
        },
        {
          "name" : "obs",
          "type" : "Observation",
          "mode" : "target"
        },
        {
          "name" : "entry",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "status",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "status",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "final"
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "qr",
              "element" : "subject",
              "variable" : "s"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "subject",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "s"
                }
              ]
            }
          ]
        },
        {
          "name" : "encounter",
          "source" : [
            {
              "context" : "qr",
              "element" : "encounter",
              "variable" : "e"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "encounter",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "e"
                }
              ]
            }
          ]
        },
        {
          "name" : "effective",
          "source" : [
            {
              "context" : "qr",
              "element" : "authored",
              "variable" : "t"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "effectiveDateTime",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "t"
                }
              ]
            }
          ]
        },
        {
          "name" : "category",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "category",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                },
                {
                  "valueString" : "vital-signs"
                },
                {
                  "valueString" : "Vital Signs"
                }
              ]
            }
          ],
          "documentation" : "Category (vital signs) - defaukt"
        },
        {
          "name" : "setObsIdAndFullUrl",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "id",
              "transform" : "uuid"
            }
          ],
          "dependent" : [
            {
              "name" : "SetObservationFullUrl",
              "parameter" : [
                {
                  "valueId" : "obs"
                },
                {
                  "valueId" : "entry"
                }
              ]
            }
          ],
          "documentation" : "Observation id and fullUrl"
        },
        {
          "name" : "entryRequest",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "entry",
              "element" : "request",
              "variable" : "request"
            }
          ],
          "rule" : [
            {
              "name" : "reqMethod",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "request",
                  "element" : "method",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "POST"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "reqUrl",
              "source" : [
                {
                  "context" : "qr"
                }
              ],
              "target" : [
                {
                  "context" : "request",
                  "element" : "url",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Observation"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Bundle.entry.request (transaction POST Observation)"
        },
        {
          "name" : "linkQR",
          "source" : [
            {
              "context" : "qr"
            }
          ],
          "target" : [
            {
              "context" : "obs",
              "element" : "derivedFrom",
              "variable" : "newRef",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "setQRRef",
              "source" : [
                {
                  "context" : "qr",
                  "element" : "id",
                  "variable" : "qid"
                }
              ],
              "target" : [
                {
                  "context" : "newRef",
                  "element" : "reference",
                  "transform" : "append",
                  "parameter" : [
                    {
                      "valueString" : "QuestionnaireResponse/"
                    },
                    {
                      "valueId" : "qid"
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Link Observation -> QuestionnaireResponse"
        }
      ]
    },
    {
      "name" : "SetObservationFullUrl",
      "input" : [
        {
          "name" : "obs",
          "type" : "Observation",
          "mode" : "source"
        },
        {
          "name" : "entry",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "assignFullUrl",
          "source" : [
            {
              "context" : "obs",
              "element" : "id",
              "variable" : "id"
            }
          ],
          "target" : [
            {
              "context" : "entry",
              "element" : "fullUrl",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "https://fhir.slade360.co.ke/fhir/Observation/"
                },
                {
                  "valueId" : "id"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
