# Condition Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition Transforms: R4 → SGHI R5**

## StructureMap: Condition Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/ConditionSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:ConditionSGHI5 |

 
ConditionTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "ConditionSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/ConditionSGHI5",
  "version" : "0.1.0",
  "name" : "ConditionSGHI5",
  "title" : "Condition Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "ConditionTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/Condition",
      "mode" : "source",
      "alias" : "ConditionR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/condition",
      "mode" : "target",
      "alias" : "SGHICondition"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHICondition",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "ConditionR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHICondition",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "uuid"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "uuid"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "addtometa",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "addprofile",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/condition"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src",
              "condition" : "text.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "t_text",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting text",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "ttt",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "src",
                  "element" : "text",
                  "variable" : "st"
                }
              ],
              "rule" : [
                {
                  "name" : "status",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "status",
                      "variable" : "s"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "status",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueId" : "s"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "wraptextinhtml",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "div",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "div",
                      "transform" : "evaluate",
                      "parameter" : [
                        {
                          "valueString" : "'<div xmlns=\\\"http://www.w3.org/1999/xhtml\\\"><p>' + d + '</p></div>'"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "addfhirididentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_ident",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "copyid",
              "source" : [
                {
                  "context" : "s_id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setuse",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setsystem",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "inittype",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "type",
                  "variable" : "t_type",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "initcoding",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_type",
                      "element" : "coding",
                      "variable" : "t_code",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "typesystem",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typecode",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typedisplay",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting owner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_ident",
                      "element" : "assigner",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "scode"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "scode",
                  "element" : "coding",
                  "variable" : "d",
                  "condition" : "system.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "coding",
                  "transform" : "translate",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    },
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoICD11Condition"
                    },
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "scode",
                  "element" : "coding",
                  "variable" : "d",
                  "condition" : "d.system.exists()"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "coding",
                  "variable" : "tcoding",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "code",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoICD11Condition"
                        },
                        {
                          "valueString" : "code"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "system",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoICD11Condition"
                        },
                        {
                          "valueString" : "system"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "display",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoICD11Condition"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcode",
                      "element" : "text",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoICD11Condition"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "sb"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "subject",
              "variable" : "tb"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sb"
                },
                {
                  "valueId" : "tb"
                }
              ]
            }
          ]
        },
        {
          "name" : "encounter",
          "source" : [
            {
              "context" : "src",
              "element" : "encounter",
              "variable" : "se"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "encounter",
              "variable" : "te"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "se"
                },
                {
                  "valueId" : "te"
                }
              ]
            }
          ]
        },
        {
          "name" : "verificationStatus",
          "source" : [
            {
              "context" : "src",
              "element" : "verificationStatus",
              "variable" : "sv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "verificationStatus",
              "variable" : "tv"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "sc"
                    },
                    {
                      "valueId" : "tc"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "category",
          "source" : [
            {
              "context" : "src",
              "element" : "category",
              "variable" : "sg"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "category",
              "variable" : "tg"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "coding",
                  "variable" : "d"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "coding",
                  "variable" : "tcode",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcode",
                      "element" : "code",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/FHIRCodeCategoryMap"
                        },
                        {
                          "valueString" : "code"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcode",
                      "element" : "system",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/FHIRCodeCategoryMap"
                        },
                        {
                          "valueString" : "system"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcode",
                      "element" : "display",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/FHIRCodeCategoryMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tg",
                      "element" : "text",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/FHIRCodeCategoryMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "severity",
          "source" : [
            {
              "context" : "src",
              "element" : "severity",
              "variable" : "sv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "severity",
              "variable" : "tv"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "rule" : [
                {
                  "name" : "system",
                  "source" : [
                    {
                      "context" : "sc",
                      "element" : "system"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "sc",
                      "element" : "code",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "code",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "display",
                  "source" : [
                    {
                      "context" : "sc",
                      "element" : "display",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "display",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "clinicalStatus",
          "source" : [
            {
              "context" : "src",
              "element" : "clinicalStatus",
              "variable" : "sg"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "clinicalStatus",
              "variable" : "tg"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "coding",
                  "variable" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "coding",
                  "variable" : "tcode",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "scode",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcode",
                      "element" : "code",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/FHIRClinicalStatusMap"
                        },
                        {
                          "valueString" : "code"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "scode",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcode",
                      "element" : "system",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/FHIRClinicalStatusMap"
                        },
                        {
                          "valueString" : "system"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "scode",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcode",
                      "element" : "display",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/FHIRClinicalStatusMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "scode",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tg",
                      "element" : "text",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/FHIRClinicalStatusMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "set default severity",
          "source" : [
            {
              "context" : "src",
              "condition" : "severity.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "severity",
              "variable" : "tcc",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableConcept"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "set severity coding",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tcc",
                  "element" : "coding",
                  "variable" : "tc",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "set default system",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "set default code",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "mild"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "setting default display",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "Mild"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting participant",
          "source" : [
            {
              "context" : "src",
              "condition" : "participant.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "participant",
              "variable" : "tb",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "BackboneElement"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "meta",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "meta",
                  "source" : [
                    {
                      "context" : "src",
                      "element" : "meta",
                      "variable" : "sm"
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "tag",
                      "source" : [
                        {
                          "context" : "sm",
                          "element" : "tag",
                          "listMode" : "last",
                          "variable" : "st"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tb",
                          "element" : "actor",
                          "variable" : "ta",
                          "transform" : "create",
                          "parameter" : [
                            {
                              "valueString" : "Reference"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "TransformAssigner",
                          "parameter" : [
                            {
                              "valueId" : "st"
                            },
                            {
                              "valueId" : "ta"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "recordedDate",
          "source" : [
            {
              "context" : "src",
              "element" : "recordedDate",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "recordedDate",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "onsetDate",
          "source" : [
            {
              "context" : "src",
              "element" : "onsetDate",
              "variable" : "sd"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "onset",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sd"
                }
              ]
            }
          ]
        },
        {
          "name" : "note",
          "source" : [
            {
              "context" : "src",
              "element" : "note",
              "variable" : "sn"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "note",
              "variable" : "tn"
            }
          ],
          "rule" : [
            {
              "name" : "time",
              "source" : [
                {
                  "context" : "sn",
                  "element" : "time",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tn",
                  "element" : "time",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sn",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tn",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "Organization/"
                },
                {
                  "valueId" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformCoding",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "settingdefaultdisplay",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
