# Appointment Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Appointment Transforms: R4 → SGHI R5**

## StructureMap: Appointment Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/AppointmentSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:AppointmentSGHI5 |

 
AppointmentTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "AppointmentSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/AppointmentSGHI5",
  "version" : "0.1.0",
  "name" : "AppointmentSGHI5",
  "title" : "Appointment Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "AppointmentTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/Appointment",
      "mode" : "source",
      "alias" : "AppointmentR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/appointment",
      "mode" : "target",
      "alias" : "SGHIAppointment"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIAppointment",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "AppointmentR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIAppointment",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "uuid"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "uuid"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "addtometa",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "addprofile",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/appointment"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src",
              "condition" : "text.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "t_text",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting text",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "ttt",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "src",
                  "element" : "text",
                  "variable" : "st"
                }
              ],
              "rule" : [
                {
                  "name" : "status",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "status",
                      "variable" : "s"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "status",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueId" : "s"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "wraptextinhtml",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "div",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "div",
                      "transform" : "evaluate",
                      "parameter" : [
                        {
                          "valueString" : "'<div xmlns=\\\"http://www.w3.org/1999/xhtml\\\"><p>' + d + '</p></div>'"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "addfhirididentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_ident",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "copyid",
              "source" : [
                {
                  "context" : "s_id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setuse",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setsystem",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "inittype",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "type",
                  "variable" : "t_type",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "initcoding",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_type",
                      "element" : "coding",
                      "variable" : "t_code",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "typesystem",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typecode",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typedisplay",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting owner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_ident",
                      "element" : "assigner",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "verificationStatus",
          "source" : [
            {
              "context" : "src",
              "element" : "verificationStatus",
              "variable" : "sv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "verificationStatus",
              "variable" : "tv"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "sc"
                    },
                    {
                      "valueId" : "tc"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "settingcreated",
          "source" : [
            {
              "context" : "src",
              "condition" : "created.exists()"
            }
          ],
          "rule" : [
            {
              "name" : "created",
              "source" : [
                {
                  "context" : "src",
                  "element" : "created",
                  "variable" : "sd"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "created",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "sd"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "settingcreated",
          "source" : [
            {
              "context" : "src",
              "condition" : "created.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "start",
              "source" : [
                {
                  "context" : "src",
                  "element" : "start",
                  "variable" : "sd"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "created",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "sd"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "start",
          "source" : [
            {
              "context" : "src",
              "element" : "start",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "start",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "end",
          "source" : [
            {
              "context" : "src",
              "element" : "end",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "end",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting participant",
          "source" : [
            {
              "context" : "src",
              "condition" : "participant.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "participant",
              "variable" : "tb",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "BackboneElement"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "patient",
              "source" : [
                {
                  "context" : "src",
                  "element" : "patient",
                  "variable" : "sp"
                }
              ],
              "target" : [
                {
                  "context" : "tb",
                  "element" : "actor",
                  "variable" : "trf",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sp"
                    },
                    {
                      "valueId" : "trf"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "participant",
          "source" : [
            {
              "context" : "src",
              "element" : "participant",
              "variable" : "sp"
            }
          ],
          "rule" : [
            {
              "name" : "actor",
              "source" : [
                {
                  "context" : "sp",
                  "element" : "actor",
                  "variable" : "sa"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "subject",
                  "variable" : "trf",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sa"
                    },
                    {
                      "valueId" : "trf"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "participant",
          "source" : [
            {
              "context" : "src",
              "element" : "participant",
              "variable" : "sp"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "participant",
              "variable" : "tp"
            }
          ],
          "rule" : [
            {
              "name" : "actor",
              "source" : [
                {
                  "context" : "sp",
                  "element" : "actor",
                  "variable" : "sa"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "actor",
                  "variable" : "ta"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sa"
                    },
                    {
                      "valueId" : "ta"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "status",
              "source" : [
                {
                  "context" : "sp",
                  "element" : "status",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "status",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settingparticipantstatus",
              "source" : [
                {
                  "context" : "sp",
                  "condition" : "status.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "tp",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "needs-action"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting reason code",
          "source" : [
            {
              "context" : "src",
              "condition" : "reasonCode.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reason",
              "variable" : "tcf",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableReference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settingconcept",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tcf",
                  "element" : "concept",
                  "variable" : "tcc",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Concept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "reasonCode",
                  "source" : [
                    {
                      "context" : "src",
                      "element" : "reasonCode",
                      "variable" : "sc"
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "coding",
                      "source" : [
                        {
                          "context" : "sc",
                          "element" : "coding",
                          "variable" : "scode"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tcc",
                          "element" : "coding",
                          "variable" : "tcoding",
                          "transform" : "create",
                          "parameter" : [
                            {
                              "valueString" : "Coding"
                            }
                          ]
                        }
                      ],
                      "rule" : [
                        {
                          "name" : "code",
                          "source" : [
                            {
                              "context" : "scode",
                              "element" : "code",
                              "variable" : "d"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "tcoding",
                              "element" : "code",
                              "transform" : "translate",
                              "parameter" : [
                                {
                                  "valueId" : "d"
                                },
                                {
                                  "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                                },
                                {
                                  "valueString" : "code"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "code",
                          "source" : [
                            {
                              "context" : "scode",
                              "element" : "code",
                              "variable" : "d"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "tcoding",
                              "element" : "system",
                              "transform" : "translate",
                              "parameter" : [
                                {
                                  "valueId" : "d"
                                },
                                {
                                  "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                                },
                                {
                                  "valueString" : "system"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "code",
                          "source" : [
                            {
                              "context" : "scode",
                              "element" : "code",
                              "variable" : "d"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "tcoding",
                              "element" : "display",
                              "transform" : "translate",
                              "parameter" : [
                                {
                                  "valueId" : "d"
                                },
                                {
                                  "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                                },
                                {
                                  "valueString" : "display"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "name" : "code",
                          "source" : [
                            {
                              "context" : "scode",
                              "element" : "code",
                              "variable" : "d"
                            }
                          ],
                          "target" : [
                            {
                              "context" : "tcc",
                              "element" : "text",
                              "transform" : "translate",
                              "parameter" : [
                                {
                                  "valueId" : "d"
                                },
                                {
                                  "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                                },
                                {
                                  "valueString" : "display"
                                }
                              ]
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "settingappointmenttype",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reason",
              "variable" : "tcrf",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableReference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "reasonCode",
              "source" : [
                {
                  "context" : "src",
                  "element" : "reasonCode",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tcrf",
                  "element" : "concept",
                  "variable" : "tcc",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "coding",
                  "source" : [
                    {
                      "context" : "sc",
                      "element" : "coding",
                      "variable" : "scode"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcc",
                      "element" : "coding",
                      "variable" : "tcoding",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "code",
                      "source" : [
                        {
                          "context" : "scode",
                          "element" : "code",
                          "variable" : "d"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tcoding",
                          "element" : "code",
                          "transform" : "translate",
                          "parameter" : [
                            {
                              "valueId" : "d"
                            },
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                            },
                            {
                              "valueString" : "code"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "code",
                      "source" : [
                        {
                          "context" : "scode",
                          "element" : "code",
                          "variable" : "d"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tcoding",
                          "element" : "system",
                          "transform" : "translate",
                          "parameter" : [
                            {
                              "valueId" : "d"
                            },
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                            },
                            {
                              "valueString" : "system"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "code",
                      "source" : [
                        {
                          "context" : "scode",
                          "element" : "code",
                          "variable" : "d"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tcoding",
                          "element" : "display",
                          "transform" : "translate",
                          "parameter" : [
                            {
                              "valueId" : "d"
                            },
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                            },
                            {
                              "valueString" : "display"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "code",
                      "source" : [
                        {
                          "context" : "scode",
                          "element" : "code",
                          "variable" : "d"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tcc",
                          "element" : "text",
                          "transform" : "translate",
                          "parameter" : [
                            {
                              "valueId" : "d"
                            },
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap"
                            },
                            {
                              "valueString" : "display"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "status",
          "source" : [
            {
              "context" : "src",
              "element" : "status",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "specialty",
          "source" : [
            {
              "context" : "src",
              "element" : "specialty",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "specialty",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "settingdefaultspecialty",
          "source" : [
            {
              "context" : "src",
              "condition" : "specialty.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "settingspeciality",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "specialty",
                  "variable" : "tcc",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "setspecialtycoding",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcc",
                      "element" : "coding",
                      "variable" : "tc",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/specialtycodesystem"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "general-practitioner"
                        }
                      ]
                    },
                    {
                      "context" : "tc",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "General Practitioner"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setpriority",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "priority",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://terminology.hl7.org/CodeSystem/v3-ActPriority"
                },
                {
                  "valueString" : "R"
                },
                {
                  "valueString" : "routine"
                }
              ]
            }
          ]
        },
        {
          "name" : "appointmentType",
          "source" : [
            {
              "context" : "src",
              "element" : "appointmentType",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "appointmentType",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting appointment type",
          "source" : [
            {
              "context" : "src",
              "condition" : "appointmentType.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "appointmentType",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://terminology.hl7.org/CodeSystem/v2-0276"
                },
                {
                  "valueString" : "ROUTINE"
                },
                {
                  "valueString" : "Routine appointment - default if not valued"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "Organization/"
                },
                {
                  "valueId" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformCoding",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "settingdefaultdisplay",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
