# Encounter Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter Transforms: R4 → SGHI R5**

## StructureMap: Encounter Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/AllergyIntoleranceSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:AllergyIntoleranceSGHI5 |

 
EncounterTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "AllergyIntoleranceSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/AllergyIntoleranceSGHI5",
  "version" : "0.1.0",
  "name" : "AllergyIntoleranceSGHI5",
  "title" : "Encounter Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "EncounterTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/AllergyIntolerance",
      "mode" : "source",
      "alias" : "AllergyIntoleranceR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/allergyintolerance",
      "mode" : "target",
      "alias" : "SGHIAllergyIntolerance"
    }
  ],
  "import" : ["http://hl7.org/fhir/StructureMap/*4to5"],
  "group" : [
    {
      "name" : "SGHIAllergyIntolerance",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "AllergyIntoleranceR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIAllergyIntolerance",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "uuid"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "uuid"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "addtometa",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "addprofile",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/allergyintolerance"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src",
              "condition" : "text.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "t_text",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_text",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting text",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "ttt",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "src",
                  "element" : "text",
                  "variable" : "st"
                }
              ],
              "rule" : [
                {
                  "name" : "status",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "status",
                      "variable" : "s"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "status",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueId" : "s"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "wraptextinhtml",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "div",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "div",
                      "transform" : "evaluate",
                      "parameter" : [
                        {
                          "valueString" : "'<div xmlns=\\\"http://www.w3.org/1999/xhtml\\\"><p>' + d + '</p></div>'"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "addfhirididentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_ident",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "copyid",
              "source" : [
                {
                  "context" : "s_id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setuse",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setsystem",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "inittype",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "type",
                  "variable" : "t_type",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "initcoding",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_type",
                      "element" : "coding",
                      "variable" : "t_code",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "typesystem",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typecode",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typedisplay",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting owner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_ident",
                      "element" : "assigner",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "clinicalStatus",
          "source" : [
            {
              "context" : "src",
              "element" : "clinicalStatus",
              "variable" : "sg"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "clinicalStatus",
              "variable" : "tg"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "sc"
                    },
                    {
                      "valueId" : "tc"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "verificationStatus",
          "source" : [
            {
              "context" : "src",
              "element" : "verificationStatus",
              "variable" : "sv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "verificationStatus",
              "variable" : "tv"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "sc"
                    },
                    {
                      "valueId" : "tc"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "type",
          "source" : [
            {
              "context" : "src",
              "element" : "type",
              "variable" : "st",
              "condition" : "type.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "type",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://hl7.org/fhir/allergy-intolerance-type"
                },
                {
                  "valueId" : "st"
                },
                {
                  "valueId" : "st"
                }
              ]
            }
          ]
        },
        {
          "name" : "patient",
          "source" : [
            {
              "context" : "src",
              "element" : "patient",
              "variable" : "sb"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "patient",
              "variable" : "tb"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sb"
                },
                {
                  "valueId" : "tb"
                }
              ]
            }
          ]
        },
        {
          "name" : "encounter",
          "source" : [
            {
              "context" : "src",
              "element" : "encounter",
              "variable" : "se"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "encounter",
              "variable" : "te"
            }
          ],
          "rule" : [
            {
              "name" : "id",
              "source" : [
                {
                  "context" : "se",
                  "element" : "id",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "id",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "reference",
              "source" : [
                {
                  "context" : "se",
                  "element" : "reference",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "reference",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting reference",
              "source" : [
                {
                  "context" : "se",
                  "condition" : "reference.exists().not()"
                }
              ],
              "rule" : [
                {
                  "name" : "id",
                  "source" : [
                    {
                      "context" : "se",
                      "element" : "id",
                      "variable" : "id"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "te",
                      "element" : "reference",
                      "transform" : "append",
                      "parameter" : [
                        {
                          "valueString" : "Encounter/"
                        },
                        {
                          "valueId" : "id"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "se",
                  "element" : "display",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "display",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting the default display",
              "source" : [
                {
                  "context" : "se",
                  "condition" : "display.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "te",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Unknown display"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "sc"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "tc"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sc",
                  "element" : "coding",
                  "variable" : "scc"
                }
              ],
              "target" : [
                {
                  "context" : "tc",
                  "element" : "coding",
                  "variable" : "tcc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "scc"
                    },
                    {
                      "valueId" : "tcc"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sc",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tc",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "category",
          "source" : [
            {
              "context" : "src",
              "element" : "category",
              "variable" : "sg"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "category",
              "variable" : "tg"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformCoding",
                  "parameter" : [
                    {
                      "valueId" : "sc"
                    },
                    {
                      "valueId" : "tc"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sg",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tg",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "criticality",
          "source" : [
            {
              "context" : "src",
              "element" : "criticality",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "criticality",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "onsetDateTime",
          "source" : [
            {
              "context" : "src",
              "element" : "onsetDateTime",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "recordedDate",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reaction",
          "source" : [
            {
              "context" : "src",
              "element" : "reaction",
              "variable" : "sre"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reaction",
              "variable" : "tre"
            }
          ],
          "rule" : [
            {
              "name" : "manifestation",
              "source" : [
                {
                  "context" : "sre",
                  "element" : "manifestation",
                  "variable" : "scpt"
                }
              ],
              "target" : [
                {
                  "context" : "tre",
                  "element" : "manifestation",
                  "variable" : "tcpt",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableReference"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "creating codeable concept",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcpt",
                      "element" : "concept",
                      "variable" : "tcc",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "CodeableConcept"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "coding",
                      "source" : [
                        {
                          "context" : "scpt",
                          "element" : "coding",
                          "variable" : "sc"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "tcc",
                          "element" : "coding",
                          "variable" : "tc",
                          "transform" : "create",
                          "parameter" : [
                            {
                              "valueString" : "Coding"
                            }
                          ]
                        }
                      ],
                      "dependent" : [
                        {
                          "name" : "TransformCoding",
                          "parameter" : [
                            {
                              "valueId" : "sc"
                            },
                            {
                              "valueId" : "tc"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "description",
              "source" : [
                {
                  "context" : "sre",
                  "element" : "description",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tre",
                  "element" : "description",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "severity",
              "source" : [
                {
                  "context" : "sre",
                  "element" : "severity",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tre",
                  "element" : "severity",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "note",
              "source" : [
                {
                  "context" : "sre",
                  "element" : "note",
                  "variable" : "sn"
                }
              ],
              "target" : [
                {
                  "context" : "tre",
                  "element" : "note",
                  "variable" : "tn"
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformNote",
                  "parameter" : [
                    {
                      "valueId" : "sn"
                    },
                    {
                      "valueId" : "tn"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "severity",
          "source" : [
            {
              "context" : "src",
              "element" : "severity",
              "variable" : "sv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "severity",
              "variable" : "tv"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "coding",
                  "variable" : "sc"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "coding",
                  "variable" : "tc"
                }
              ],
              "rule" : [
                {
                  "name" : "system",
                  "source" : [
                    {
                      "context" : "sc",
                      "element" : "system"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "sc",
                      "element" : "code",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "code",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "display",
                  "source" : [
                    {
                      "context" : "sc",
                      "element" : "display",
                      "variable" : "vvv"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tc",
                      "element" : "display",
                      "variable" : "vvv",
                      "transform" : "create"
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "DefaultMappingGroupAnonymousAlias",
                      "parameter" : [
                        {
                          "valueId" : "vvv"
                        },
                        {
                          "valueId" : "vvv"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "sv",
                  "element" : "text",
                  "variable" : "vvv"
                }
              ],
              "target" : [
                {
                  "context" : "tv",
                  "element" : "text",
                  "variable" : "vvv",
                  "transform" : "create"
                }
              ],
              "dependent" : [
                {
                  "name" : "DefaultMappingGroupAnonymousAlias",
                  "parameter" : [
                    {
                      "valueId" : "vvv"
                    },
                    {
                      "valueId" : "vvv"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting participant",
          "source" : [
            {
              "context" : "src",
              "condition" : "participant.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "participant",
              "variable" : "tb",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "BackboneElement"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "patient",
              "source" : [
                {
                  "context" : "src",
                  "element" : "patient",
                  "variable" : "sp"
                }
              ],
              "target" : [
                {
                  "context" : "tb",
                  "element" : "actor",
                  "variable" : "trf",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Reference"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TransformReference",
                  "parameter" : [
                    {
                      "valueId" : "sp"
                    },
                    {
                      "valueId" : "trf"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "recordedDate",
          "source" : [
            {
              "context" : "src",
              "element" : "recordedDate",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "recordedDate",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting onset date",
          "source" : [
            {
              "context" : "src",
              "condition" : "onsetDateTime.exists()"
            }
          ],
          "rule" : [
            {
              "name" : "onsetDateTime",
              "source" : [
                {
                  "context" : "src",
                  "element" : "onsetDateTime",
                  "variable" : "sd"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "onset",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "sd"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting onset date",
          "source" : [
            {
              "context" : "src",
              "condition" : "onsetDateTime.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "recordedDate",
              "source" : [
                {
                  "context" : "src",
                  "element" : "recordedDate",
                  "variable" : "sd"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "onset",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "sd"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "note",
          "source" : [
            {
              "context" : "src",
              "element" : "note",
              "variable" : "sn"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "note",
              "variable" : "tn"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformNote",
              "parameter" : [
                {
                  "valueId" : "sn"
                },
                {
                  "valueId" : "tn"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "Organization/"
                },
                {
                  "valueId" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformCoding",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "settingdefaultdisplay",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "system",
          "source" : [
            {
              "context" : "src",
              "element" : "system",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "system",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformNote",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "time",
          "source" : [
            {
              "context" : "src",
              "element" : "time",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "time",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        },
        {
          "name" : "text",
          "source" : [
            {
              "context" : "src",
              "element" : "text",
              "variable" : "vvv"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "vvv",
              "transform" : "create"
            }
          ],
          "dependent" : [
            {
              "name" : "DefaultMappingGroupAnonymousAlias",
              "parameter" : [
                {
                  "valueId" : "vvv"
                },
                {
                  "valueId" : "vvv"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
