# SGHI Task - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Task**

## Resource Profile: SGHI Task 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/task | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHITask |

 
SGHI's profile for Task 

**Usages:**

* Refer to this Profile: [SGHI Care Plan](StructureDefinition-careplan.md) and [SGHI Task](StructureDefinition-task.md)
* Examples for this Profile: [Task/ExampleSGHITask](Task-ExampleSGHITask.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/task)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-task.csv), [Excel](StructureDefinition-task.xlsx), [Schematron](StructureDefinition-task.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "task",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/task",
  "version" : "0.1.0",
  "name" : "SGHITask",
  "title" : "SGHI Task",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "SGHI's profile for Task",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task",
        "constraint" : [
          {
            "key" : "task-lastModified",
            "severity" : "error",
            "human" : "Last modified date must be greater than or equal to authored-on date",
            "expression" : "lastModified.empty() or authoredOn.empty() or lastModified >= authoredOn",
            "source" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/task"
          }
        ]
      },
      {
        "id" : "Task.identifier",
        "path" : "Task.identifier",
        "min" : 1
      },
      {
        "id" : "Task.identifier.use",
        "path" : "Task.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "Task.identifier.type",
        "path" : "Task.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "Task.identifier.system",
        "path" : "Task.identifier.system",
        "min" : 1
      },
      {
        "id" : "Task.identifier.value",
        "path" : "Task.identifier.value",
        "min" : 1
      },
      {
        "id" : "Task.identifier.assigner",
        "path" : "Task.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Task.partOf",
        "path" : "Task.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : ["https://fhir.slade360.co.ke/fhir/StructureDefinition/task"]
          }
        ]
      },
      {
        "id" : "Task.businessStatus",
        "path" : "Task.businessStatus",
        "min" : 1
      },
      {
        "id" : "Task.priority",
        "path" : "Task.priority",
        "min" : 1
      },
      {
        "id" : "Task.for",
        "path" : "Task.for",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "Task.encounter",
        "path" : "Task.encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/encounter"
            ]
          }
        ]
      },
      {
        "id" : "Task.authoredOn",
        "path" : "Task.authoredOn",
        "min" : 1
      },
      {
        "id" : "Task.requester",
        "path" : "Task.requester",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Task.requestedPerformer",
        "path" : "Task.requestedPerformer",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Task.owner",
        "path" : "Task.owner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Task.performer",
        "path" : "Task.performer",
        "max" : "1"
      },
      {
        "id" : "Task.performer.actor",
        "path" : "Task.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Task.restriction.recipient",
        "path" : "Task.restriction.recipient",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "Task.input.value[x]",
        "path" : "Task.input.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Task.input.value[x]:valueCodeableConcept",
        "path" : "Task.input.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Task.input.value[x]:valueCodeableReference",
        "path" : "Task.input.value[x]",
        "sliceName" : "valueCodeableReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ]
          }
        ]
      },
      {
        "id" : "Task.input.value[x]:valueDosage",
        "path" : "Task.input.value[x]",
        "sliceName" : "valueDosage",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/dosage"
            ]
          }
        ]
      },
      {
        "id" : "Task.output.type",
        "path" : "Task.output.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Task.output.value[x]",
        "path" : "Task.output.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Task.output.value[x]:valueCodeableConcept",
        "path" : "Task.output.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Task.output.value[x]:valueCodeableReference",
        "path" : "Task.output.value[x]",
        "sliceName" : "valueCodeableReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ]
          }
        ]
      },
      {
        "id" : "Task.output.value[x]:valueDosage",
        "path" : "Task.output.value[x]",
        "sliceName" : "valueDosage",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/dosage"
            ]
          }
        ]
      }
    ]
  }
}

```
