# SGHI Specimen - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Specimen**

## Resource Profile: SGHI Specimen 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/specimen | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHISpecimen |

 
A sample to be used for analysis. 

**Usages:**

* Examples for this Profile: [Specimen/ExampleSGHISpecimen](Specimen-ExampleSGHISpecimen.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/specimen)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-specimen.csv), [Excel](StructureDefinition-specimen.xlsx), [Schematron](StructureDefinition-specimen.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "specimen",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/specimen",
  "version" : "0.1.0",
  "name" : "SGHISpecimen",
  "title" : "SGHI Specimen",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A sample to be used for analysis.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Specimen",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen",
        "path" : "Specimen"
      },
      {
        "id" : "Specimen.identifier",
        "path" : "Specimen.identifier",
        "min" : 1
      },
      {
        "id" : "Specimen.identifier.use",
        "path" : "Specimen.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "Specimen.identifier.type",
        "path" : "Specimen.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "Specimen.identifier.system",
        "path" : "Specimen.identifier.system",
        "min" : 1
      },
      {
        "id" : "Specimen.identifier.value",
        "path" : "Specimen.identifier.value",
        "min" : 1
      },
      {
        "id" : "Specimen.identifier.assigner",
        "path" : "Specimen.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.accessionIdentifier",
        "path" : "Specimen.accessionIdentifier",
        "min" : 1
      },
      {
        "id" : "Specimen.status",
        "path" : "Specimen.status",
        "min" : 1
      },
      {
        "id" : "Specimen.subject",
        "path" : "Specimen.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.receivedTime",
        "path" : "Specimen.receivedTime",
        "min" : 1
      },
      {
        "id" : "Specimen.role",
        "path" : "Specimen.role",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection",
        "path" : "Specimen.collection",
        "min" : 1
      },
      {
        "id" : "Specimen.collection.collector",
        "path" : "Specimen.collection.collector",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection.collected[x]",
        "path" : "Specimen.collection.collected[x]",
        "min" : 1
      },
      {
        "id" : "Specimen.processing",
        "path" : "Specimen.processing",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Specimen.processing.method",
        "path" : "Specimen.processing.method",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/specimentype"
        }
      },
      {
        "id" : "Specimen.processing.additive",
        "path" : "Specimen.processing.additive",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Substance"]
          }
        ]
      }
    ]
  }
}

```
