# SGHI RiskAssessment - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI RiskAssessment**

## Resource Profile: SGHI RiskAssessment 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/riskassessment | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIRiskAssessment |

 
An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome. 

**Usages:**

* Examples for this Profile: [RiskAssessment/ExampleSGHIRiskAssessment](RiskAssessment-ExampleSGHIRiskAssessment.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/riskassessment)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-riskassessment.csv), [Excel](StructureDefinition-riskassessment.xlsx), [Schematron](StructureDefinition-riskassessment.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "riskassessment",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/riskassessment",
  "version" : "0.1.0",
  "name" : "SGHIRiskAssessment",
  "title" : "SGHI RiskAssessment",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "openehr",
      "uri" : "http://openehr.org",
      "name" : "Open EHR Archetype Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RiskAssessment",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/RiskAssessment",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RiskAssessment",
        "path" : "RiskAssessment"
      },
      {
        "id" : "RiskAssessment.identifier",
        "path" : "RiskAssessment.identifier",
        "min" : 1
      },
      {
        "id" : "RiskAssessment.identifier.use",
        "path" : "RiskAssessment.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "RiskAssessment.identifier.type",
        "path" : "RiskAssessment.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "RiskAssessment.identifier.system",
        "path" : "RiskAssessment.identifier.system",
        "min" : 1
      },
      {
        "id" : "RiskAssessment.identifier.value",
        "path" : "RiskAssessment.identifier.value",
        "min" : 1
      },
      {
        "id" : "RiskAssessment.identifier.assigner",
        "path" : "RiskAssessment.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "RiskAssessment.basedOn",
        "path" : "RiskAssessment.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ]
      },
      {
        "id" : "RiskAssessment.subject",
        "path" : "RiskAssessment.subject",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "RiskAssessment.encounter",
        "path" : "RiskAssessment.encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/encounter"
            ]
          }
        ]
      },
      {
        "id" : "RiskAssessment.condition",
        "path" : "RiskAssessment.condition",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/condition"
            ]
          }
        ]
      },
      {
        "id" : "RiskAssessment.performer",
        "path" : "RiskAssessment.performer",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient",
              "http://hl7.org/fhir/StructureDefinition/Practitioner"
            ]
          }
        ]
      },
      {
        "id" : "RiskAssessment.reason",
        "path" : "RiskAssessment.reason",
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/condition",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/observation",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/diagnosticreport"
            ]
          }
        ]
      },
      {
        "id" : "RiskAssessment.basis",
        "path" : "RiskAssessment.basis",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      },
      {
        "id" : "RiskAssessment.prediction",
        "path" : "RiskAssessment.prediction",
        "min" : 1
      },
      {
        "id" : "RiskAssessment.prediction.qualitativeRisk",
        "path" : "RiskAssessment.prediction.qualitativeRisk",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "RiskAssessment.note",
        "path" : "RiskAssessment.note",
        "type" : [
          {
            "code" : "Annotation",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/annotation"
            ]
          }
        ]
      }
    ]
  }
}

```
