# SGHI Reference - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Reference**

## Data Type Profile: SGHI Reference 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/reference | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIReference |

 
SGHI Reference 

**Usages:**

* Use this DataType Profile: [SGHI Activity Defintion Profile](StructureDefinition-activitydefinition.md), [SGHI AllergyIntolerance](StructureDefinition-allergyintolerance.md), [SGHI Annotation](StructureDefinition-annotation.md), [SGHI Appointment Profile](StructureDefinition-appointment.md)...Show 25 more,[SGHI Care Plan](StructureDefinition-careplan.md),[SGHI CodeableReference](StructureDefinition-codeable-reference.md),[SGHI Composition](StructureDefinition-composition.md),[SGHI Condition](StructureDefinition-condition.md),[SGHI Consent](StructureDefinition-consent.md),[SGHI DiagnosticReport](StructureDefinition-diagnosticreport.md),[SGHI DocumentReference Profile.](StructureDefinition-documentreference.md),[SGHI Encounter](StructureDefinition-encounter.md),[SGHI EpisodeOfCare](StructureDefinition-episodeofcare.md),[SGHI Location](StructureDefinition-fhir-location.md),[SGHI Medication](StructureDefinition-medication.md),[SGHI Medication Dispense](StructureDefinition-medicationdispense.md),[SGHI MedicationRequest](StructureDefinition-medicationrequest.md),[SGHI Observation](StructureDefinition-observation.md),[SGHI Organization](StructureDefinition-organization.md),[SGHI Patient](StructureDefinition-patient.md),[SGHI Plan Definition Profile](StructureDefinition-plandefinition.md),[SGHI Practitioner](StructureDefinition-practitioner.md),[SGHI PractitionerRole](StructureDefinition-practitionerrole.md),[SGHI Procedure](StructureDefinition-procedure.md),[SGHI RiskAssessment](StructureDefinition-riskassessment.md),[SGHI ServiceRequest](StructureDefinition-servicerequest.md),[SGHI Specimen](StructureDefinition-specimen.md),[SGHI Substance](StructureDefinition-substance.md)and[SGHI Task](StructureDefinition-task.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/reference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-reference.csv), [Excel](StructureDefinition-reference.xlsx), [Schematron](StructureDefinition-reference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "reference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "has-target"
    }
  ],
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference",
  "version" : "0.1.0",
  "name" : "SGHIReference",
  "title" : "SGHI Reference",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "SGHI Reference",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Reference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Reference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Reference.reference",
        "path" : "Reference.reference",
        "min" : 1
      }
    ]
  }
}

```
