# SGHI PractitionerRole - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI PractitionerRole**

## Resource Profile: SGHI PractitionerRole 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/practitionerrole | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIPractitionerRole |

 
PractitionerRole describes the types of services that practitioners provide to SGHI Organization at specific location(s). The profile a specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time. 

**Usages:**

* Refer to this Profile: [SGHI Appointment Profile](StructureDefinition-appointment.md), [SGHI DocumentReference Profile.](StructureDefinition-documentreference.md), [SGHI MedicationRequest](StructureDefinition-medicationrequest.md) and [SGHI Procedure](StructureDefinition-procedure.md)
* Examples for this Profile: [PractitionerRole/ExampleSGHIPractitionerRole](PractitionerRole-ExampleSGHIPractitionerRole.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/practitionerrole)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-practitionerrole.csv), [Excel](StructureDefinition-practitionerrole.xlsx), [Schematron](StructureDefinition-practitionerrole.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "practitionerrole",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitionerrole",
  "version" : "0.1.0",
  "name" : "SGHIPractitionerRole",
  "title" : "SGHI PractitionerRole",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "PractitionerRole describes the types of services that practitioners provide to SGHI Organization at specific location(s). The profile a specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.identifier.use",
        "path" : "PractitionerRole.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "PractitionerRole.identifier.type",
        "path" : "PractitionerRole.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "PractitionerRole.identifier.system",
        "path" : "PractitionerRole.identifier.system",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.identifier.value",
        "path" : "PractitionerRole.identifier.value",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.identifier.assigner",
        "path" : "PractitionerRole.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.active",
        "path" : "PractitionerRole.active",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.period.start",
        "path" : "PractitionerRole.period.start",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.period.end",
        "path" : "PractitionerRole.period.end",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitioner"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/practitioner-role-value-set"
        }
      },
      {
        "id" : "PractitionerRole.specialty",
        "path" : "PractitionerRole.specialty",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/practitioner-specialty-value-set"
        }
      },
      {
        "id" : "PractitionerRole.location",
        "path" : "PractitionerRole.location",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/fhir-location"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.contact.name",
        "path" : "PractitionerRole.contact.name",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/human-name"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.contact.telecom",
        "path" : "PractitionerRole.contact.telecom",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/contact-point"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.availability.availableTime.daysOfWeek",
        "path" : "PractitionerRole.availability.availableTime.daysOfWeek",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.availability.availableTime.allDay",
        "path" : "PractitionerRole.availability.availableTime.allDay",
        "min" : 1
      }
    ]
  }
}

```
